/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class WidgetsBundle
extends BaseData<WidgetsBundleId>
implements TenantEntity,
ExportableEntity<WidgetsBundleId>,
HasTitle,
HasImage,
HasVersion {
    private static final long serialVersionUID = -7627368878362410489L;
    @Schema(description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="alias")
    @Schema(description="Unique alias that is used in widget types as a reference widget bundle", accessMode=Schema.AccessMode.READ_ONLY)
    private String alias;
    @NoXss
    @Length(fieldName="title")
    @Schema(description="Title used in search and UI", accessMode=Schema.AccessMode.READ_ONLY)
    private String title;
    @Schema(description="Relative or external image URL. Replaced with image data URL (Base64) in case of relative URL and 'inlineImages' option enabled.", accessMode=Schema.AccessMode.READ_ONLY)
    private String image;
    @Schema(description="Whether widgets bundle contains SCADA symbol widget types.", accessMode=Schema.AccessMode.READ_ONLY)
    private boolean scada;
    @NoXss
    @Length(fieldName="description", max=1024)
    @Schema(description="Description", accessMode=Schema.AccessMode.READ_ONLY)
    private String description;
    @Schema(description="Order", accessMode=Schema.AccessMode.READ_ONLY)
    private Integer order;
    private WidgetsBundleId externalId;
    private Long version;

    public WidgetsBundle() {
    }

    public WidgetsBundle(WidgetsBundleId id) {
        super(id);
    }

    public WidgetsBundle(WidgetsBundle widgetsBundle) {
        super(widgetsBundle);
        this.tenantId = widgetsBundle.getTenantId();
        this.alias = widgetsBundle.getAlias();
        this.title = widgetsBundle.getTitle();
        this.image = widgetsBundle.getImage();
        this.scada = widgetsBundle.isScada();
        this.description = widgetsBundle.getDescription();
        this.order = widgetsBundle.getOrder();
        this.externalId = widgetsBundle.getExternalId();
        this.version = widgetsBundle.getVersion();
    }

    @Override
    @Schema(description="JSON object with the Widget Bundle Id. Specify this field to update the Widget Bundle. Referencing non-existing Widget Bundle Id will cause error. Omit this field to create new Widget Bundle.")
    public WidgetsBundleId getId() {
        return (WidgetsBundleId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the Widget Bundle creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Same as title of the Widget Bundle. Read-only field. Update the 'title' to change the 'name' of the Widget Bundle.", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.WIDGETS_BUNDLE;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public boolean isScada() {
        return this.scada;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Override
    @Generated
    public WidgetsBundleId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setScada(boolean scada) {
        this.scada = scada;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    @Generated
    public void setExternalId(WidgetsBundleId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "WidgetsBundle(tenantId=" + String.valueOf(this.getTenantId()) + ", alias=" + this.getAlias() + ", title=" + this.getTitle() + ", scada=" + this.isScada() + ", description=" + this.getDescription() + ", order=" + this.getOrder() + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetsBundle)) {
            return false;
        }
        WidgetsBundle other = (WidgetsBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isScada() != other.isScada()) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        WidgetsBundleId this$externalId = this.getExternalId();
        WidgetsBundleId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WidgetsBundle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isScada() ? 79 : 97);
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        WidgetsBundleId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

