/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.NoXss;
import org.thingsboard.server.common.data.widget.BaseWidgetType;
import org.thingsboard.server.common.data.widget.WidgetBundleInfo;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;

public class WidgetTypeInfo
extends BaseWidgetType {
    private static final long serialVersionUID = 1343617007959780969L;
    @Schema(description="Base64 encoded widget thumbnail", accessMode=Schema.AccessMode.READ_ONLY)
    private String image;
    @NoXss
    @Schema(description="Description of the widget type", accessMode=Schema.AccessMode.READ_ONLY)
    private String description;
    @NoXss
    @Schema(description="Tags of the widget type", accessMode=Schema.AccessMode.READ_ONLY)
    private String[] tags;
    @NoXss
    @Schema(description="Type of the widget (timeseries, latest, control, alarm or static)", accessMode=Schema.AccessMode.READ_ONLY)
    private String widgetType;
    @Valid
    @Schema(description="Bundles", accessMode=Schema.AccessMode.READ_ONLY)
    private List<WidgetBundleInfo> bundles;

    public WidgetTypeInfo() {
    }

    public WidgetTypeInfo(WidgetTypeId id) {
        super(id);
    }

    public WidgetTypeInfo(BaseWidgetType baseWidgetType) {
        super(baseWidgetType);
    }

    public WidgetTypeInfo(WidgetTypeInfo widgetTypeInfo) {
        this(widgetTypeInfo, Collections.emptyList());
    }

    public WidgetTypeInfo(WidgetTypeInfo widgetTypeInfo, List<WidgetBundleInfo> bundles) {
        super(widgetTypeInfo);
        this.image = widgetTypeInfo.getImage();
        this.description = widgetTypeInfo.getDescription();
        this.tags = widgetTypeInfo.getTags();
        this.widgetType = widgetTypeInfo.getWidgetType();
        this.bundles = bundles;
    }

    public WidgetTypeInfo(WidgetTypeDetails widgetTypeDetails) {
        this(widgetTypeDetails, Collections.emptyList());
    }

    public WidgetTypeInfo(WidgetTypeDetails widgetTypeDetails, List<WidgetBundleInfo> bundles) {
        super(widgetTypeDetails);
        this.image = widgetTypeDetails.getImage();
        this.description = widgetTypeDetails.getDescription();
        this.tags = widgetTypeDetails.getTags();
        this.widgetType = widgetTypeDetails.getDescriptor() != null && widgetTypeDetails.getDescriptor().has("type") ? widgetTypeDetails.getDescriptor().get("type").asText() : "";
        this.bundles = bundles;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String[] getTags() {
        return this.tags;
    }

    @Generated
    public String getWidgetType() {
        return this.widgetType;
    }

    @Generated
    public List<WidgetBundleInfo> getBundles() {
        return this.bundles;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Generated
    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    @Generated
    public void setBundles(List<WidgetBundleInfo> bundles) {
        this.bundles = bundles;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetTypeInfo)) {
            return false;
        }
        WidgetTypeInfo other = (WidgetTypeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTags(), other.getTags())) {
            return false;
        }
        String this$widgetType = this.getWidgetType();
        String other$widgetType = other.getWidgetType();
        if (this$widgetType == null ? other$widgetType != null : !this$widgetType.equals(other$widgetType)) {
            return false;
        }
        List<WidgetBundleInfo> this$bundles = this.getBundles();
        List<WidgetBundleInfo> other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !((Object)this$bundles).equals(other$bundles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WidgetTypeInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTags());
        String $widgetType = this.getWidgetType();
        result = result * 59 + ($widgetType == null ? 43 : $widgetType.hashCode());
        List<WidgetBundleInfo> $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : ((Object)$bundles).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WidgetTypeInfo(image=" + this.getImage() + ", description=" + this.getDescription() + ", tags=" + Arrays.deepToString(this.getTags()) + ", widgetType=" + this.getWidgetType() + ", bundles=" + String.valueOf(this.getBundles()) + ")";
    }
}

