/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.widget.BaseWidgetType;

public class WidgetType
extends BaseWidgetType {
    @Schema(description="Complex JSON object that describes the widget type", accessMode=Schema.AccessMode.READ_ONLY)
    private JsonNode descriptor;

    public WidgetType() {
    }

    public WidgetType(WidgetTypeId id) {
        super(id);
    }

    public WidgetType(BaseWidgetType baseWidgetType) {
        super(baseWidgetType);
    }

    public WidgetType(WidgetType widgetType) {
        super(widgetType);
        this.descriptor = widgetType.getDescriptor();
    }

    @JsonIgnore
    public JsonNode getDefaultConfig() {
        return Optional.ofNullable(this.descriptor).map(descriptor -> descriptor.get("defaultConfig")).filter(JsonNode::isTextual).map(JsonNode::asText).map(json -> {
            try {
                return mapper.readTree(json);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }).orElse(null);
    }

    public void setDefaultConfig(JsonNode defaultConfig) {
        ((ObjectNode)this.descriptor).put("defaultConfig", defaultConfig.toString());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetType)) {
            return false;
        }
        WidgetType other = (WidgetType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonNode this$descriptor = this.getDescriptor();
        JsonNode other$descriptor = other.getDescriptor();
        return !(this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WidgetType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonNode $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        return result;
    }

    @Generated
    public JsonNode getDescriptor() {
        return this.descriptor;
    }

    @Generated
    public void setDescriptor(JsonNode descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    @Generated
    public String toString() {
        return "WidgetType(descriptor=" + String.valueOf(this.getDescriptor()) + ")";
    }
}

