/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class BaseWidgetType
extends BaseData<WidgetTypeId>
implements HasName,
TenantEntity,
HasVersion {
    private static final long serialVersionUID = 8388684344603660756L;
    @Schema(description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="fqn")
    @Schema(description="Unique FQN that is used in dashboards as a reference widget type", accessMode=Schema.AccessMode.READ_ONLY)
    private String fqn;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="Widget name used in search and UI", accessMode=Schema.AccessMode.READ_ONLY)
    private String name;
    @Schema(description="Whether widget type is deprecated.", example="true")
    private boolean deprecated;
    @Schema(description="Whether widget type is SCADA symbol.", example="true")
    private boolean scada;
    private Long version;

    public BaseWidgetType() {
    }

    public BaseWidgetType(WidgetTypeId id) {
        super(id);
    }

    public BaseWidgetType(BaseWidgetType widgetType) {
        super(widgetType);
        this.tenantId = widgetType.getTenantId();
        this.fqn = widgetType.getFqn();
        this.name = widgetType.getName();
        this.deprecated = widgetType.isDeprecated();
        this.scada = widgetType.isScada();
        this.version = widgetType.getVersion();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.WIDGET_TYPE;
    }

    @Override
    @Schema(description="JSON object with the Widget Type Id. Specify this field to update the Widget Type. Referencing non-existing Widget Type Id will cause error. Omit this field to create new Widget Type.")
    public WidgetTypeId getId() {
        return (WidgetTypeId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the Widget Type creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getFqn() {
        return this.fqn;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Generated
    public boolean isScada() {
        return this.scada;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Generated
    public void setScada(boolean scada) {
        this.scada = scada;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "BaseWidgetType(tenantId=" + String.valueOf(this.getTenantId()) + ", fqn=" + this.getFqn() + ", name=" + this.getName() + ", deprecated=" + this.isDeprecated() + ", scada=" + this.isScada() + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWidgetType)) {
            return false;
        }
        BaseWidgetType other = (BaseWidgetType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeprecated() != other.isDeprecated()) {
            return false;
        }
        if (this.isScada() != other.isScada()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$fqn = this.getFqn();
        String other$fqn = other.getFqn();
        if (this$fqn == null ? other$fqn != null : !this$fqn.equals(other$fqn)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseWidgetType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        result = result * 59 + (this.isScada() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $fqn = this.getFqn();
        result = result * 59 + ($fqn == null ? 43 : $fqn.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

