/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import java.math.BigDecimal;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.thingsboard.server.common.data.kv.DataType;

public class TypeCastUtil {
    private TypeCastUtil() {
    }

    public static Pair<DataType, Object> castValue(String value) {
        block7: {
            if (TypeCastUtil.isNumber(value)) {
                String formattedValue = value.replace(',', '.');
                try {
                    BigDecimal bd = new BigDecimal(formattedValue);
                    if (bd.stripTrailingZeros().scale() > 0 || TypeCastUtil.isSimpleDouble(formattedValue)) {
                        if (bd.scale() <= 16) {
                            return Pair.of((Object)((Object)DataType.DOUBLE), (Object)bd.doubleValue());
                        }
                        break block7;
                    }
                    return Pair.of((Object)((Object)DataType.LONG), (Object)bd.longValueExact());
                }
                catch (RuntimeException runtimeException) {}
            } else if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return Pair.of((Object)((Object)DataType.BOOLEAN), (Object)Boolean.parseBoolean(value));
            }
        }
        return Pair.of((Object)((Object)DataType.STRING), (Object)value);
    }

    public static Pair<DataType, Number> castToNumber(String value) {
        if (TypeCastUtil.isNumber(value)) {
            String formattedValue = value.replace(',', '.');
            BigDecimal bd = new BigDecimal(formattedValue);
            if (bd.stripTrailingZeros().scale() > 0 || TypeCastUtil.isSimpleDouble(formattedValue)) {
                if (bd.scale() <= 16) {
                    return Pair.of((Object)((Object)DataType.DOUBLE), (Object)bd.doubleValue());
                }
                return Pair.of((Object)((Object)DataType.DOUBLE), (Object)bd);
            }
            return Pair.of((Object)((Object)DataType.LONG), (Object)bd.longValueExact());
        }
        throw new IllegalArgumentException("'" + value + "' can't be parsed as number");
    }

    private static boolean isNumber(String value) {
        return NumberUtils.isNumber((String)value.replace(',', '.'));
    }

    private static boolean isSimpleDouble(String valueAsString) {
        return valueAsString.contains(".") && !valueAsString.contains("E") && !valueAsString.contains("e");
    }
}

