/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TemplateUtils {
    private static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\$\\{(.+?)(:[a-zA-Z]+)?}");
    private static final Map<String, UnaryOperator<String>> FUNCTIONS = Map.of("upperCase", String::toUpperCase, "lowerCase", String::toLowerCase, "capitalize", StringUtils::capitalize);

    private TemplateUtils() {
    }

    public static String processTemplate(String template, Map<String, String> context, Map<String, UnaryOperator<String>> customFunctions) {
        return TEMPLATE_PARAM_PATTERN.matcher(template).replaceAll(matchResult -> {
            String key = matchResult.group(1);
            String functionName = StringUtils.removeStart((String)matchResult.group(2), (String)":");
            if (!(context.containsKey(key) || functionName != null && customFunctions != null && customFunctions.containsKey(functionName))) {
                return "\\" + matchResult.group();
            }
            String value = Strings.nullToEmpty((String)((String)context.get(key)));
            if (functionName != null) {
                UnaryOperator function = FUNCTIONS.get(functionName);
                if (function != null) {
                    value = (String)function.apply(value);
                } else if (customFunctions != null && (function = (UnaryOperator)customFunctions.get(functionName)) != null) {
                    value = (String)function.apply(key);
                    value = TemplateUtils.processTemplate(value, context, null);
                }
            }
            return Matcher.quoteReplacement(value);
        });
    }
}

