/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.model.InvalidDDFFileException;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.util.TbDefaultDDFFileValidator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TbDDFFileParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbDDFFileParser.class);
    private static final TbDefaultDDFFileValidator ddfFileValidator = new TbDefaultDDFFileValidator();

    public List<ObjectModel> parse(InputStream inputStream, String streamName) throws InvalidDDFFileException, IOException {
        streamName = streamName == null ? "" : streamName;
        log.debug("Parsing DDF file {}", (Object)streamName);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            LwM2m.LwM2mVersion lwm2mVersion = null;
            ddfFileValidator.validate(document);
            ArrayList<ObjectModel> objects = new ArrayList<ObjectModel>();
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("Object");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                objects.add(this.parseObject(nodeList.item(i), streamName, lwm2mVersion, true));
            }
            return objects;
        }
        catch (InvalidDDFFileException | SAXException e) {
            throw new InvalidDDFFileException(e, "Invalid DDF file %s", new Object[]{streamName});
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to create Document Builder", e);
        }
    }

    private ObjectModel parseObject(Node object, String streamName, LwM2m.LwM2mVersion schemaVersion, boolean validate) throws InvalidDDFFileException {
        Node objectType = object.getAttributes().getNamedItem("ObjectType");
        if (validate && (objectType == null || !"MODefinition".equals(objectType.getTextContent()))) {
            throw new InvalidDDFFileException("Object element in %s MUST have a ObjectType attribute equals to 'MODefinition'.", new Object[]{streamName});
        }
        Integer id = null;
        String name = null;
        String description = null;
        String version = "1.0";
        Boolean multiple = null;
        Boolean mandatory = null;
        HashMap<Integer, ResourceModel> resources = new HashMap<Integer, ResourceModel>();
        String urn = null;
        String description2 = null;
        String lwm2mVersion = "1.0";
        block24: for (int i = 0; i < object.getChildNodes().getLength(); ++i) {
            Node field = object.getChildNodes().item(i);
            if (field.getNodeType() != 1) continue;
            switch (field.getNodeName()) {
                case "ObjectID": {
                    id = Integer.valueOf(field.getTextContent());
                    continue block24;
                }
                case "Name": {
                    name = field.getTextContent();
                    continue block24;
                }
                case "Description1": {
                    description = field.getTextContent();
                    continue block24;
                }
                case "ObjectVersion": {
                    if (StringUtils.isEmpty((String)field.getTextContent())) continue block24;
                    version = field.getTextContent();
                    continue block24;
                }
                case "MultipleInstances": {
                    if ("Multiple".equals(field.getTextContent())) {
                        multiple = true;
                        continue block24;
                    }
                    if (!"Single".equals(field.getTextContent())) continue block24;
                    multiple = false;
                    continue block24;
                }
                case "Mandatory": {
                    if ("Mandatory".equals(field.getTextContent())) {
                        mandatory = true;
                        continue block24;
                    }
                    if (!"Optional".equals(field.getTextContent())) continue block24;
                    mandatory = false;
                    continue block24;
                }
                case "Resources": {
                    for (int j = 0; j < field.getChildNodes().getLength(); ++j) {
                        Node item = field.getChildNodes().item(j);
                        if (item.getNodeType() != 1 || !item.getNodeName().equals("Item")) continue;
                        ResourceModel resource = this.parseResource(item, streamName);
                        if (validate && resources.containsKey(resource.id)) {
                            throw new InvalidDDFFileException("Object %s in %s contains at least 2 resources with same id %s.", new Object[]{id != null ? id : "", streamName, resource.id});
                        }
                        resources.put(resource.id, resource);
                    }
                    continue block24;
                }
                case "ObjectURN": {
                    urn = field.getTextContent();
                    continue block24;
                }
                case "LWM2MVersion": {
                    if (StringUtils.isEmpty((String)field.getTextContent())) continue block24;
                    lwm2mVersion = field.getTextContent();
                    if (schemaVersion == null || schemaVersion.toString().equals(lwm2mVersion)) continue block24;
                    throw new InvalidDDFFileException("LWM2MVersion is not consistent with xml shema(xsi:noNamespaceSchemaLocation) in %s : %s  expected but was %s.", new Object[]{streamName, schemaVersion, lwm2mVersion});
                }
                case "Description2": {
                    description2 = field.getTextContent();
                    continue block24;
                }
            }
        }
        return new ObjectModel(id, name, description, version, multiple, mandatory, resources.values(), urn, lwm2mVersion, description2);
    }

    private ResourceModel parseResource(Node item, String streamName) throws DOMException, InvalidDDFFileException {
        Integer id = Integer.valueOf(item.getAttributes().getNamedItem("ID").getTextContent());
        String name = null;
        ResourceModel.Operations operations = null;
        Boolean multiple = false;
        Boolean mandatory = false;
        ResourceModel.Type type = null;
        String rangeEnumeration = null;
        String units = null;
        String description = null;
        block44: for (int i = 0; i < item.getChildNodes().getLength(); ++i) {
            Node field = item.getChildNodes().item(i);
            if (field.getNodeType() != 1) continue;
            switch (field.getNodeName()) {
                case "Name": {
                    name = field.getTextContent();
                    continue block44;
                }
                case "Operations": {
                    String strOp = field.getTextContent();
                    if (strOp != null && !strOp.isEmpty()) {
                        operations = ResourceModel.Operations.valueOf((String)strOp);
                        continue block44;
                    }
                    operations = ResourceModel.Operations.NONE;
                    continue block44;
                }
                case "MultipleInstances": {
                    if ("Multiple".equals(field.getTextContent())) {
                        multiple = true;
                        continue block44;
                    }
                    if (!"Single".equals(field.getTextContent())) continue block44;
                    multiple = false;
                    continue block44;
                }
                case "Mandatory": {
                    if ("Mandatory".equals(field.getTextContent())) {
                        mandatory = true;
                        continue block44;
                    }
                    if (!"Optional".equals(field.getTextContent())) continue block44;
                    mandatory = false;
                    continue block44;
                }
                case "Type": {
                    switch (field.getTextContent()) {
                        case "String": {
                            type = ResourceModel.Type.STRING;
                            continue block44;
                        }
                        case "Integer": {
                            type = ResourceModel.Type.INTEGER;
                            continue block44;
                        }
                        case "Float": {
                            type = ResourceModel.Type.FLOAT;
                            continue block44;
                        }
                        case "Boolean": {
                            type = ResourceModel.Type.BOOLEAN;
                            continue block44;
                        }
                        case "Opaque": {
                            type = ResourceModel.Type.OPAQUE;
                            continue block44;
                        }
                        case "Time": {
                            type = ResourceModel.Type.TIME;
                            continue block44;
                        }
                        case "Objlnk": {
                            type = ResourceModel.Type.OBJLNK;
                            continue block44;
                        }
                        case "Unsigned Integer": {
                            type = ResourceModel.Type.UNSIGNED_INTEGER;
                            continue block44;
                        }
                        case "Corelnk": {
                            type = ResourceModel.Type.CORELINK;
                            continue block44;
                        }
                        case "": {
                            type = ResourceModel.Type.NONE;
                            continue block44;
                        }
                    }
                    continue block44;
                }
                case "RangeEnumeration": {
                    rangeEnumeration = field.getTextContent();
                    continue block44;
                }
                case "Units": {
                    units = field.getTextContent();
                    continue block44;
                }
                case "Description": {
                    description = field.getTextContent();
                    continue block44;
                }
            }
        }
        return new ResourceModel(id, name, operations, multiple, mandatory, type, rangeEnumeration, units, description);
    }
}

