/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.transport.snmp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.regex.Pattern;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.kv.DataType;

public class SnmpMapping
implements Serializable {
    private static final long serialVersionUID = 2042438869374145944L;
    private String oid;
    private String key;
    private DataType dataType;
    private static final Pattern OID_PATTERN = Pattern.compile("^\\.?([0-2])((\\.0)|(\\.[1-9][0-9]*))*$");

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.isNotEmpty(this.oid) && OID_PATTERN.matcher(this.oid).matches() && StringUtils.isNotBlank(this.key);
    }

    @Generated
    public String getOid() {
        return this.oid;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Generated
    public void setOid(String oid) {
        this.oid = oid;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpMapping)) {
            return false;
        }
        SnmpMapping other = (SnmpMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oid = this.getOid();
        String other$oid = other.getOid();
        if (this$oid == null ? other$oid != null : !this$oid.equals(other$oid)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpMapping;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oid = this.getOid();
        result = result * 59 + ($oid == null ? 43 : $oid.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnmpMapping(oid=" + this.getOid() + ", key=" + this.getKey() + ", dataType=" + String.valueOf((Object)this.getDataType()) + ")";
    }

    @ConstructorProperties(value={"oid", "key", "dataType"})
    @Generated
    public SnmpMapping(String oid, String key, DataType dataType) {
        this.oid = oid;
        this.key = key;
        this.dataType = dataType;
    }

    @Generated
    public SnmpMapping() {
    }
}

