/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.translation;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema
public class TranslationInfo
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslationInfo.class);
    @Schema(description="Locale code formed by combining the ISO 639-1 language code and the ISO 3166-1 region code. For example, \"en_US\"")
    private String localeCode;
    @Schema(description="Locale code language display name. For example, \"Polish (Polski)\"")
    private String language;
    @Schema(description="Locale code country display name. For example, \"Poland\"")
    private String country;
    @Schema(description="Number representing translation percentage progress. For example, 40 that means 40% of all keys are translated.")
    private int progress;
    @Schema(description="Boolean representing if current language has customization.")
    private boolean customized;

    @Generated
    public static TranslationInfoBuilder builder() {
        return new TranslationInfoBuilder();
    }

    @Generated
    public String getLocaleCode() {
        return this.localeCode;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public int getProgress() {
        return this.progress;
    }

    @Generated
    public boolean isCustomized() {
        return this.customized;
    }

    @Generated
    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Generated
    public void setCustomized(boolean customized) {
        this.customized = customized;
    }

    @Generated
    public String toString() {
        return "TranslationInfo(localeCode=" + this.getLocaleCode() + ", language=" + this.getLanguage() + ", country=" + this.getCountry() + ", progress=" + this.getProgress() + ", customized=" + this.isCustomized() + ")";
    }

    @Generated
    public TranslationInfo() {
    }

    @ConstructorProperties(value={"localeCode", "language", "country", "progress", "customized"})
    @Generated
    public TranslationInfo(String localeCode, String language, String country, int progress, boolean customized) {
        this.localeCode = localeCode;
        this.language = language;
        this.country = country;
        this.progress = progress;
        this.customized = customized;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationInfo)) {
            return false;
        }
        TranslationInfo other = (TranslationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProgress() != other.getProgress()) {
            return false;
        }
        if (this.isCustomized() != other.isCustomized()) {
            return false;
        }
        String this$localeCode = this.getLocaleCode();
        String other$localeCode = other.getLocaleCode();
        if (this$localeCode == null ? other$localeCode != null : !this$localeCode.equals(other$localeCode)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        return !(this$country == null ? other$country != null : !this$country.equals(other$country));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TranslationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProgress();
        result = result * 59 + (this.isCustomized() ? 79 : 97);
        String $localeCode = this.getLocaleCode();
        result = result * 59 + ($localeCode == null ? 43 : $localeCode.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        return result;
    }

    @Generated
    public static class TranslationInfoBuilder {
        @Generated
        private String localeCode;
        @Generated
        private String language;
        @Generated
        private String country;
        @Generated
        private int progress;
        @Generated
        private boolean customized;

        @Generated
        TranslationInfoBuilder() {
        }

        @Generated
        public TranslationInfoBuilder localeCode(String localeCode) {
            this.localeCode = localeCode;
            return this;
        }

        @Generated
        public TranslationInfoBuilder language(String language) {
            this.language = language;
            return this;
        }

        @Generated
        public TranslationInfoBuilder country(String country) {
            this.country = country;
            return this;
        }

        @Generated
        public TranslationInfoBuilder progress(int progress) {
            this.progress = progress;
            return this;
        }

        @Generated
        public TranslationInfoBuilder customized(boolean customized) {
            this.customized = customized;
            return this;
        }

        @Generated
        public TranslationInfo build() {
            return new TranslationInfo(this.localeCode, this.language, this.country, this.progress, this.customized);
        }

        @Generated
        public String toString() {
            return "TranslationInfo.TranslationInfoBuilder(localeCode=" + this.localeCode + ", language=" + this.language + ", country=" + this.country + ", progress=" + this.progress + ", customized=" + this.customized + ")";
        }
    }
}

