/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.translation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class CustomTranslation
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTranslation.class);
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="localeCode", max=5)
    private String localeCode;
    @NoXss
    @Length(fieldName="value", max=1000000)
    private transient JsonNode value;
    @JsonIgnore
    private byte[] valueBytes;

    public JsonNode getValue() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.value, () -> this.valueBytes);
    }

    public void setValue(JsonNode value) {
        BaseDataWithAdditionalInfo.setJson(value, json -> {
            this.value = json;
        }, bytes -> {
            this.valueBytes = bytes;
        });
    }

    @Generated
    public static CustomTranslationBuilder builder() {
        return new CustomTranslationBuilder();
    }

    @Generated
    public CustomTranslationBuilder toBuilder() {
        return new CustomTranslationBuilder().tenantId(this.tenantId).customerId(this.customerId).localeCode(this.localeCode).value(this.value).valueBytes(this.valueBytes);
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getLocaleCode() {
        return this.localeCode;
    }

    @Generated
    public byte[] getValueBytes() {
        return this.valueBytes;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @JsonIgnore
    @Generated
    public void setValueBytes(byte[] valueBytes) {
        this.valueBytes = valueBytes;
    }

    @Generated
    public String toString() {
        return "CustomTranslation(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", localeCode=" + this.getLocaleCode() + ", value=" + String.valueOf(this.getValue()) + ", valueBytes=" + Arrays.toString(this.getValueBytes()) + ")";
    }

    @Generated
    public CustomTranslation() {
    }

    @ConstructorProperties(value={"tenantId", "customerId", "localeCode", "value", "valueBytes"})
    @Generated
    public CustomTranslation(TenantId tenantId, CustomerId customerId, String localeCode, JsonNode value, byte[] valueBytes) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.localeCode = localeCode;
        this.value = value;
        this.valueBytes = valueBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTranslation)) {
            return false;
        }
        CustomTranslation other = (CustomTranslation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$localeCode = this.getLocaleCode();
        String other$localeCode = other.getLocaleCode();
        if (this$localeCode == null ? other$localeCode != null : !this$localeCode.equals(other$localeCode)) {
            return false;
        }
        return Arrays.equals(this.getValueBytes(), other.getValueBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomTranslation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $localeCode = this.getLocaleCode();
        result = result * 59 + ($localeCode == null ? 43 : $localeCode.hashCode());
        result = result * 59 + Arrays.hashCode(this.getValueBytes());
        return result;
    }

    @Generated
    public static class CustomTranslationBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private CustomerId customerId;
        @Generated
        private String localeCode;
        @Generated
        private JsonNode value;
        @Generated
        private byte[] valueBytes;

        @Generated
        CustomTranslationBuilder() {
        }

        @Generated
        public CustomTranslationBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public CustomTranslationBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        @Generated
        public CustomTranslationBuilder localeCode(String localeCode) {
            this.localeCode = localeCode;
            return this;
        }

        @Generated
        public CustomTranslationBuilder value(JsonNode value) {
            this.value = value;
            return this;
        }

        @JsonIgnore
        @Generated
        public CustomTranslationBuilder valueBytes(byte[] valueBytes) {
            this.valueBytes = valueBytes;
            return this;
        }

        @Generated
        public CustomTranslation build() {
            return new CustomTranslation(this.tenantId, this.customerId, this.localeCode, this.value, this.valueBytes);
        }

        @Generated
        public String toString() {
            return "CustomTranslation.CustomTranslationBuilder(tenantId=" + String.valueOf(this.tenantId) + ", customerId=" + String.valueOf(this.customerId) + ", localeCode=" + this.localeCode + ", value=" + String.valueOf(this.value) + ", valueBytes=" + Arrays.toString(this.valueBytes) + ")";
        }
    }
}

