/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.tenant.profile;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfileType;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.validation.RateLimit;

@Schema
public class DefaultTenantProfileConfiguration
implements TenantProfileConfiguration {
    private static final long serialVersionUID = -7134932690332578595L;
    private long maxDevices;
    private long maxAssets;
    private long maxCustomers;
    private long maxUsers;
    private long maxDashboards;
    private long maxRuleChains;
    private long maxEdges;
    private long maxResourcesInBytes;
    private long maxOtaPackagesInBytes;
    private long maxResourceSize;
    private long maxReportSizeInBytes;
    private long maxIntegrations;
    private long maxConverters;
    private long maxSchedulerEvents;
    @Schema(example="1000:1,20000:60")
    @RateLimit(fieldName="Transport tenant messages")
    private String transportTenantMsgRateLimit;
    @Schema(example="1000:1,20000:60")
    @RateLimit(fieldName="Transport tenant telemetry messages")
    private String transportTenantTelemetryMsgRateLimit;
    @Schema(example="1000:1,20000:60")
    @RateLimit(fieldName="Transport tenant telemetry data points")
    private String transportTenantTelemetryDataPointsRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport device messages")
    private String transportDeviceMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport device telemetry messages")
    private String transportDeviceTelemetryMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport device telemetry data points")
    private String transportDeviceTelemetryDataPointsRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway messages")
    private String transportGatewayMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway telemetry messages")
    private String transportGatewayTelemetryMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway telemetry data points")
    private String transportGatewayTelemetryDataPointsRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway device messages")
    private String transportGatewayDeviceMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway device telemetry messages")
    private String transportGatewayDeviceTelemetryMsgRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Transport gateway device telemetry data points")
    private String transportGatewayDeviceTelemetryDataPointsRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Tenant integration messages")
    private String integrationMsgsPerTenantRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Device integration messages")
    private String integrationMsgsPerDeviceRateLimit;
    @RateLimit(fieldName="Asset integration messages")
    private String integrationMsgsPerAssetRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Entity version creation")
    private String tenantEntityExportRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Entity version load")
    private String tenantEntityImportRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Notification requests")
    private String tenantNotificationRequestsRateLimit;
    @Schema(example="20:1,600:60")
    @RateLimit(fieldName="Notification requests per notification rule")
    private String tenantNotificationRequestsPerRuleRateLimit;
    @Schema(example="10000000")
    private long maxTransportMessages;
    @Schema(example="10000000")
    private long maxTransportDataPoints;
    @Schema(example="4000000")
    private long maxREExecutions;
    @Schema(example="5000000")
    private long maxJSExecutions;
    @Schema(example="5000000")
    private long maxTbelExecutions;
    @Schema(example="0")
    private long maxDPStorageDays;
    @Schema(example="50")
    private int maxRuleNodeExecutionsPerMessage;
    @Schema(example="15")
    private int maxDebugModeDurationMinutes;
    @Schema(example="0")
    private long maxEmails;
    @Schema(example="true")
    private Boolean smsEnabled;
    @Schema(example="0")
    private long maxSms;
    @Schema(example="1000")
    private long maxCreatedAlarms;
    @Schema(example="10000")
    private long maxGeneratedReports;
    @RateLimit(fieldName="REST requests for tenant")
    private String tenantServerRestLimitsConfiguration;
    @RateLimit(fieldName="REST requests for customer")
    private String customerServerRestLimitsConfiguration;
    private int maxWsSessionsPerTenant;
    private int maxWsSessionsPerCustomer;
    private int maxWsSessionsPerRegularUser;
    private int maxWsSessionsPerPublicUser;
    private int wsMsgQueueLimitPerSession;
    private long maxWsSubscriptionsPerTenant;
    private long maxWsSubscriptionsPerCustomer;
    private long maxWsSubscriptionsPerRegularUser;
    private long maxWsSubscriptionsPerPublicUser;
    @RateLimit(fieldName="WS updates per session")
    private String wsUpdatesPerSessionRateLimit;
    @RateLimit(fieldName="Rest API and WS telemetry Cassandra read queries")
    private String cassandraReadQueryTenantCoreRateLimits;
    @RateLimit(fieldName="Rest API Cassandra write queries")
    private String cassandraWriteQueryTenantCoreRateLimits;
    @RateLimit(fieldName="Rule Engine telemetry Cassandra read queries")
    private String cassandraReadQueryTenantRuleEngineRateLimits;
    @RateLimit(fieldName="Rule Engine telemetry Cassandra write queries")
    private String cassandraWriteQueryTenantRuleEngineRateLimits;
    @RateLimit(fieldName="Edge events")
    private String edgeEventRateLimits;
    @RateLimit(fieldName="Edge events per edge")
    private String edgeEventRateLimitsPerEdge;
    @RateLimit(fieldName="Edge uplink messages")
    private String edgeUplinkMessagesRateLimits;
    @RateLimit(fieldName="Edge uplink messages per edge")
    private String edgeUplinkMessagesRateLimitsPerEdge;
    private int defaultStorageTtlDays;
    private int alarmsTtlDays;
    private int rpcTtlDays;
    private int queueStatsTtlDays;
    private int ruleEngineExceptionsTtlDays;
    private int blobEntityTtlDays;
    private int reportTtlDays;
    private double warnThreshold;
    @Schema(example="5")
    private long maxCalculatedFieldsPerEntity = 5L;
    @Schema(example="10")
    private long maxArgumentsPerCF = 10L;
    @Min(value=1L, message="must be at least 1")
    @Schema(example="1000")
    private @Min(value=1L, message="must be at least 1") long maxDataPointsPerRollingArg;
    @Schema(example="32")
    private long maxStateSizeInKBytes = 32L;
    @Schema(example="2")
    private long maxSingleValueArgumentSizeInKBytes = 2L;

    @Override
    public long getProfileThreshold(ApiUsageRecordKey key) {
        return switch (key) {
            case ApiUsageRecordKey.TRANSPORT_MSG_COUNT -> this.maxTransportMessages;
            case ApiUsageRecordKey.TRANSPORT_DP_COUNT -> this.maxTransportDataPoints;
            case ApiUsageRecordKey.JS_EXEC_COUNT -> this.maxJSExecutions;
            case ApiUsageRecordKey.TBEL_EXEC_COUNT -> this.maxTbelExecutions;
            case ApiUsageRecordKey.RE_EXEC_COUNT -> this.maxREExecutions;
            case ApiUsageRecordKey.STORAGE_DP_COUNT -> this.maxDPStorageDays;
            case ApiUsageRecordKey.EMAIL_EXEC_COUNT -> this.maxEmails;
            case ApiUsageRecordKey.SMS_EXEC_COUNT -> this.maxSms;
            case ApiUsageRecordKey.CREATED_ALARMS_COUNT -> this.maxCreatedAlarms;
            case ApiUsageRecordKey.GENERATED_REPORTS_COUNT -> this.maxGeneratedReports;
            default -> 0L;
        };
    }

    @Override
    public boolean getProfileFeatureEnabled(ApiUsageRecordKey key) {
        switch (key) {
            case SMS_EXEC_COUNT: {
                return this.smsEnabled == null || Boolean.TRUE.equals(this.smsEnabled);
            }
        }
        return true;
    }

    @Override
    public long getWarnThreshold(ApiUsageRecordKey key) {
        return (long)((double)this.getProfileThreshold(key) * (this.warnThreshold > 0.0 ? this.warnThreshold : 0.8));
    }

    public long getEntitiesLimit(EntityType entityType) {
        return switch (entityType) {
            case EntityType.DEVICE -> this.maxDevices;
            case EntityType.ASSET -> this.maxAssets;
            case EntityType.CUSTOMER -> this.maxCustomers;
            case EntityType.USER -> this.maxUsers;
            case EntityType.DASHBOARD -> this.maxDashboards;
            case EntityType.RULE_CHAIN -> this.maxRuleChains;
            case EntityType.EDGE -> this.maxEdges;
            case EntityType.INTEGRATION -> this.maxIntegrations;
            case EntityType.CONVERTER -> this.maxConverters;
            case EntityType.SCHEDULER_EVENT -> this.maxSchedulerEvents;
            default -> 0L;
        };
    }

    @Override
    public TenantProfileType getType() {
        return TenantProfileType.DEFAULT;
    }

    @Override
    public int getMaxRuleNodeExecsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    @Generated
    private static long $default$maxDataPointsPerRollingArg() {
        return 1000L;
    }

    @Generated
    public static DefaultTenantProfileConfigurationBuilder builder() {
        return new DefaultTenantProfileConfigurationBuilder();
    }

    @ConstructorProperties(value={"maxDevices", "maxAssets", "maxCustomers", "maxUsers", "maxDashboards", "maxRuleChains", "maxEdges", "maxResourcesInBytes", "maxOtaPackagesInBytes", "maxResourceSize", "maxReportSizeInBytes", "maxIntegrations", "maxConverters", "maxSchedulerEvents", "transportTenantMsgRateLimit", "transportTenantTelemetryMsgRateLimit", "transportTenantTelemetryDataPointsRateLimit", "transportDeviceMsgRateLimit", "transportDeviceTelemetryMsgRateLimit", "transportDeviceTelemetryDataPointsRateLimit", "transportGatewayMsgRateLimit", "transportGatewayTelemetryMsgRateLimit", "transportGatewayTelemetryDataPointsRateLimit", "transportGatewayDeviceMsgRateLimit", "transportGatewayDeviceTelemetryMsgRateLimit", "transportGatewayDeviceTelemetryDataPointsRateLimit", "integrationMsgsPerTenantRateLimit", "integrationMsgsPerDeviceRateLimit", "integrationMsgsPerAssetRateLimit", "tenantEntityExportRateLimit", "tenantEntityImportRateLimit", "tenantNotificationRequestsRateLimit", "tenantNotificationRequestsPerRuleRateLimit", "maxTransportMessages", "maxTransportDataPoints", "maxREExecutions", "maxJSExecutions", "maxTbelExecutions", "maxDPStorageDays", "maxRuleNodeExecutionsPerMessage", "maxDebugModeDurationMinutes", "maxEmails", "smsEnabled", "maxSms", "maxCreatedAlarms", "maxGeneratedReports", "tenantServerRestLimitsConfiguration", "customerServerRestLimitsConfiguration", "maxWsSessionsPerTenant", "maxWsSessionsPerCustomer", "maxWsSessionsPerRegularUser", "maxWsSessionsPerPublicUser", "wsMsgQueueLimitPerSession", "maxWsSubscriptionsPerTenant", "maxWsSubscriptionsPerCustomer", "maxWsSubscriptionsPerRegularUser", "maxWsSubscriptionsPerPublicUser", "wsUpdatesPerSessionRateLimit", "cassandraReadQueryTenantCoreRateLimits", "cassandraWriteQueryTenantCoreRateLimits", "cassandraReadQueryTenantRuleEngineRateLimits", "cassandraWriteQueryTenantRuleEngineRateLimits", "edgeEventRateLimits", "edgeEventRateLimitsPerEdge", "edgeUplinkMessagesRateLimits", "edgeUplinkMessagesRateLimitsPerEdge", "defaultStorageTtlDays", "alarmsTtlDays", "rpcTtlDays", "queueStatsTtlDays", "ruleEngineExceptionsTtlDays", "blobEntityTtlDays", "reportTtlDays", "warnThreshold", "maxCalculatedFieldsPerEntity", "maxArgumentsPerCF", "maxDataPointsPerRollingArg", "maxStateSizeInKBytes", "maxSingleValueArgumentSizeInKBytes"})
    @Generated
    public DefaultTenantProfileConfiguration(long maxDevices, long maxAssets, long maxCustomers, long maxUsers, long maxDashboards, long maxRuleChains, long maxEdges, long maxResourcesInBytes, long maxOtaPackagesInBytes, long maxResourceSize, long maxReportSizeInBytes, long maxIntegrations, long maxConverters, long maxSchedulerEvents, String transportTenantMsgRateLimit, String transportTenantTelemetryMsgRateLimit, String transportTenantTelemetryDataPointsRateLimit, String transportDeviceMsgRateLimit, String transportDeviceTelemetryMsgRateLimit, String transportDeviceTelemetryDataPointsRateLimit, String transportGatewayMsgRateLimit, String transportGatewayTelemetryMsgRateLimit, String transportGatewayTelemetryDataPointsRateLimit, String transportGatewayDeviceMsgRateLimit, String transportGatewayDeviceTelemetryMsgRateLimit, String transportGatewayDeviceTelemetryDataPointsRateLimit, String integrationMsgsPerTenantRateLimit, String integrationMsgsPerDeviceRateLimit, String integrationMsgsPerAssetRateLimit, String tenantEntityExportRateLimit, String tenantEntityImportRateLimit, String tenantNotificationRequestsRateLimit, String tenantNotificationRequestsPerRuleRateLimit, long maxTransportMessages, long maxTransportDataPoints, long maxREExecutions, long maxJSExecutions, long maxTbelExecutions, long maxDPStorageDays, int maxRuleNodeExecutionsPerMessage, int maxDebugModeDurationMinutes, long maxEmails, Boolean smsEnabled, long maxSms, long maxCreatedAlarms, long maxGeneratedReports, String tenantServerRestLimitsConfiguration, String customerServerRestLimitsConfiguration, int maxWsSessionsPerTenant, int maxWsSessionsPerCustomer, int maxWsSessionsPerRegularUser, int maxWsSessionsPerPublicUser, int wsMsgQueueLimitPerSession, long maxWsSubscriptionsPerTenant, long maxWsSubscriptionsPerCustomer, long maxWsSubscriptionsPerRegularUser, long maxWsSubscriptionsPerPublicUser, String wsUpdatesPerSessionRateLimit, String cassandraReadQueryTenantCoreRateLimits, String cassandraWriteQueryTenantCoreRateLimits, String cassandraReadQueryTenantRuleEngineRateLimits, String cassandraWriteQueryTenantRuleEngineRateLimits, String edgeEventRateLimits, String edgeEventRateLimitsPerEdge, String edgeUplinkMessagesRateLimits, String edgeUplinkMessagesRateLimitsPerEdge, int defaultStorageTtlDays, int alarmsTtlDays, int rpcTtlDays, int queueStatsTtlDays, int ruleEngineExceptionsTtlDays, int blobEntityTtlDays, int reportTtlDays, double warnThreshold, long maxCalculatedFieldsPerEntity, long maxArgumentsPerCF, long maxDataPointsPerRollingArg, long maxStateSizeInKBytes, long maxSingleValueArgumentSizeInKBytes) {
        this.maxDevices = maxDevices;
        this.maxAssets = maxAssets;
        this.maxCustomers = maxCustomers;
        this.maxUsers = maxUsers;
        this.maxDashboards = maxDashboards;
        this.maxRuleChains = maxRuleChains;
        this.maxEdges = maxEdges;
        this.maxResourcesInBytes = maxResourcesInBytes;
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
        this.maxResourceSize = maxResourceSize;
        this.maxReportSizeInBytes = maxReportSizeInBytes;
        this.maxIntegrations = maxIntegrations;
        this.maxConverters = maxConverters;
        this.maxSchedulerEvents = maxSchedulerEvents;
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
        this.transportGatewayMsgRateLimit = transportGatewayMsgRateLimit;
        this.transportGatewayTelemetryMsgRateLimit = transportGatewayTelemetryMsgRateLimit;
        this.transportGatewayTelemetryDataPointsRateLimit = transportGatewayTelemetryDataPointsRateLimit;
        this.transportGatewayDeviceMsgRateLimit = transportGatewayDeviceMsgRateLimit;
        this.transportGatewayDeviceTelemetryMsgRateLimit = transportGatewayDeviceTelemetryMsgRateLimit;
        this.transportGatewayDeviceTelemetryDataPointsRateLimit = transportGatewayDeviceTelemetryDataPointsRateLimit;
        this.integrationMsgsPerTenantRateLimit = integrationMsgsPerTenantRateLimit;
        this.integrationMsgsPerDeviceRateLimit = integrationMsgsPerDeviceRateLimit;
        this.integrationMsgsPerAssetRateLimit = integrationMsgsPerAssetRateLimit;
        this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
        this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
        this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
        this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
        this.maxTransportMessages = maxTransportMessages;
        this.maxTransportDataPoints = maxTransportDataPoints;
        this.maxREExecutions = maxREExecutions;
        this.maxJSExecutions = maxJSExecutions;
        this.maxTbelExecutions = maxTbelExecutions;
        this.maxDPStorageDays = maxDPStorageDays;
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
        this.maxDebugModeDurationMinutes = maxDebugModeDurationMinutes;
        this.maxEmails = maxEmails;
        this.smsEnabled = smsEnabled;
        this.maxSms = maxSms;
        this.maxCreatedAlarms = maxCreatedAlarms;
        this.maxGeneratedReports = maxGeneratedReports;
        this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
        this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
        this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
        this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
        this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
        this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
        this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
        this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
        this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
        this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
        this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
        this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
        this.cassandraReadQueryTenantCoreRateLimits = cassandraReadQueryTenantCoreRateLimits;
        this.cassandraWriteQueryTenantCoreRateLimits = cassandraWriteQueryTenantCoreRateLimits;
        this.cassandraReadQueryTenantRuleEngineRateLimits = cassandraReadQueryTenantRuleEngineRateLimits;
        this.cassandraWriteQueryTenantRuleEngineRateLimits = cassandraWriteQueryTenantRuleEngineRateLimits;
        this.edgeEventRateLimits = edgeEventRateLimits;
        this.edgeEventRateLimitsPerEdge = edgeEventRateLimitsPerEdge;
        this.edgeUplinkMessagesRateLimits = edgeUplinkMessagesRateLimits;
        this.edgeUplinkMessagesRateLimitsPerEdge = edgeUplinkMessagesRateLimitsPerEdge;
        this.defaultStorageTtlDays = defaultStorageTtlDays;
        this.alarmsTtlDays = alarmsTtlDays;
        this.rpcTtlDays = rpcTtlDays;
        this.queueStatsTtlDays = queueStatsTtlDays;
        this.ruleEngineExceptionsTtlDays = ruleEngineExceptionsTtlDays;
        this.blobEntityTtlDays = blobEntityTtlDays;
        this.reportTtlDays = reportTtlDays;
        this.warnThreshold = warnThreshold;
        this.maxCalculatedFieldsPerEntity = maxCalculatedFieldsPerEntity;
        this.maxArgumentsPerCF = maxArgumentsPerCF;
        this.maxDataPointsPerRollingArg = maxDataPointsPerRollingArg;
        this.maxStateSizeInKBytes = maxStateSizeInKBytes;
        this.maxSingleValueArgumentSizeInKBytes = maxSingleValueArgumentSizeInKBytes;
    }

    @Generated
    public DefaultTenantProfileConfiguration() {
        this.maxDataPointsPerRollingArg = DefaultTenantProfileConfiguration.$default$maxDataPointsPerRollingArg();
    }

    @Generated
    public long getMaxDevices() {
        return this.maxDevices;
    }

    @Generated
    public long getMaxAssets() {
        return this.maxAssets;
    }

    @Generated
    public long getMaxCustomers() {
        return this.maxCustomers;
    }

    @Generated
    public long getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public long getMaxDashboards() {
        return this.maxDashboards;
    }

    @Generated
    public long getMaxRuleChains() {
        return this.maxRuleChains;
    }

    @Generated
    public long getMaxEdges() {
        return this.maxEdges;
    }

    @Generated
    public long getMaxResourcesInBytes() {
        return this.maxResourcesInBytes;
    }

    @Generated
    public long getMaxOtaPackagesInBytes() {
        return this.maxOtaPackagesInBytes;
    }

    @Generated
    public long getMaxResourceSize() {
        return this.maxResourceSize;
    }

    @Generated
    public long getMaxReportSizeInBytes() {
        return this.maxReportSizeInBytes;
    }

    @Generated
    public long getMaxIntegrations() {
        return this.maxIntegrations;
    }

    @Generated
    public long getMaxConverters() {
        return this.maxConverters;
    }

    @Generated
    public long getMaxSchedulerEvents() {
        return this.maxSchedulerEvents;
    }

    @Generated
    public String getTransportTenantMsgRateLimit() {
        return this.transportTenantMsgRateLimit;
    }

    @Generated
    public String getTransportTenantTelemetryMsgRateLimit() {
        return this.transportTenantTelemetryMsgRateLimit;
    }

    @Generated
    public String getTransportTenantTelemetryDataPointsRateLimit() {
        return this.transportTenantTelemetryDataPointsRateLimit;
    }

    @Generated
    public String getTransportDeviceMsgRateLimit() {
        return this.transportDeviceMsgRateLimit;
    }

    @Generated
    public String getTransportDeviceTelemetryMsgRateLimit() {
        return this.transportDeviceTelemetryMsgRateLimit;
    }

    @Generated
    public String getTransportDeviceTelemetryDataPointsRateLimit() {
        return this.transportDeviceTelemetryDataPointsRateLimit;
    }

    @Generated
    public String getTransportGatewayMsgRateLimit() {
        return this.transportGatewayMsgRateLimit;
    }

    @Generated
    public String getTransportGatewayTelemetryMsgRateLimit() {
        return this.transportGatewayTelemetryMsgRateLimit;
    }

    @Generated
    public String getTransportGatewayTelemetryDataPointsRateLimit() {
        return this.transportGatewayTelemetryDataPointsRateLimit;
    }

    @Generated
    public String getTransportGatewayDeviceMsgRateLimit() {
        return this.transportGatewayDeviceMsgRateLimit;
    }

    @Generated
    public String getTransportGatewayDeviceTelemetryMsgRateLimit() {
        return this.transportGatewayDeviceTelemetryMsgRateLimit;
    }

    @Generated
    public String getTransportGatewayDeviceTelemetryDataPointsRateLimit() {
        return this.transportGatewayDeviceTelemetryDataPointsRateLimit;
    }

    @Generated
    public String getIntegrationMsgsPerTenantRateLimit() {
        return this.integrationMsgsPerTenantRateLimit;
    }

    @Generated
    public String getIntegrationMsgsPerDeviceRateLimit() {
        return this.integrationMsgsPerDeviceRateLimit;
    }

    @Generated
    public String getIntegrationMsgsPerAssetRateLimit() {
        return this.integrationMsgsPerAssetRateLimit;
    }

    @Generated
    public String getTenantEntityExportRateLimit() {
        return this.tenantEntityExportRateLimit;
    }

    @Generated
    public String getTenantEntityImportRateLimit() {
        return this.tenantEntityImportRateLimit;
    }

    @Generated
    public String getTenantNotificationRequestsRateLimit() {
        return this.tenantNotificationRequestsRateLimit;
    }

    @Generated
    public String getTenantNotificationRequestsPerRuleRateLimit() {
        return this.tenantNotificationRequestsPerRuleRateLimit;
    }

    @Generated
    public long getMaxTransportMessages() {
        return this.maxTransportMessages;
    }

    @Generated
    public long getMaxTransportDataPoints() {
        return this.maxTransportDataPoints;
    }

    @Generated
    public long getMaxREExecutions() {
        return this.maxREExecutions;
    }

    @Generated
    public long getMaxJSExecutions() {
        return this.maxJSExecutions;
    }

    @Generated
    public long getMaxTbelExecutions() {
        return this.maxTbelExecutions;
    }

    @Generated
    public long getMaxDPStorageDays() {
        return this.maxDPStorageDays;
    }

    @Generated
    public int getMaxRuleNodeExecutionsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    @Generated
    public int getMaxDebugModeDurationMinutes() {
        return this.maxDebugModeDurationMinutes;
    }

    @Generated
    public long getMaxEmails() {
        return this.maxEmails;
    }

    @Generated
    public Boolean getSmsEnabled() {
        return this.smsEnabled;
    }

    @Generated
    public long getMaxSms() {
        return this.maxSms;
    }

    @Generated
    public long getMaxCreatedAlarms() {
        return this.maxCreatedAlarms;
    }

    @Generated
    public long getMaxGeneratedReports() {
        return this.maxGeneratedReports;
    }

    @Generated
    public String getTenantServerRestLimitsConfiguration() {
        return this.tenantServerRestLimitsConfiguration;
    }

    @Generated
    public String getCustomerServerRestLimitsConfiguration() {
        return this.customerServerRestLimitsConfiguration;
    }

    @Generated
    public int getMaxWsSessionsPerTenant() {
        return this.maxWsSessionsPerTenant;
    }

    @Generated
    public int getMaxWsSessionsPerCustomer() {
        return this.maxWsSessionsPerCustomer;
    }

    @Generated
    public int getMaxWsSessionsPerRegularUser() {
        return this.maxWsSessionsPerRegularUser;
    }

    @Generated
    public int getMaxWsSessionsPerPublicUser() {
        return this.maxWsSessionsPerPublicUser;
    }

    @Generated
    public int getWsMsgQueueLimitPerSession() {
        return this.wsMsgQueueLimitPerSession;
    }

    @Generated
    public long getMaxWsSubscriptionsPerTenant() {
        return this.maxWsSubscriptionsPerTenant;
    }

    @Generated
    public long getMaxWsSubscriptionsPerCustomer() {
        return this.maxWsSubscriptionsPerCustomer;
    }

    @Generated
    public long getMaxWsSubscriptionsPerRegularUser() {
        return this.maxWsSubscriptionsPerRegularUser;
    }

    @Generated
    public long getMaxWsSubscriptionsPerPublicUser() {
        return this.maxWsSubscriptionsPerPublicUser;
    }

    @Generated
    public String getWsUpdatesPerSessionRateLimit() {
        return this.wsUpdatesPerSessionRateLimit;
    }

    @Generated
    public String getCassandraReadQueryTenantCoreRateLimits() {
        return this.cassandraReadQueryTenantCoreRateLimits;
    }

    @Generated
    public String getCassandraWriteQueryTenantCoreRateLimits() {
        return this.cassandraWriteQueryTenantCoreRateLimits;
    }

    @Generated
    public String getCassandraReadQueryTenantRuleEngineRateLimits() {
        return this.cassandraReadQueryTenantRuleEngineRateLimits;
    }

    @Generated
    public String getCassandraWriteQueryTenantRuleEngineRateLimits() {
        return this.cassandraWriteQueryTenantRuleEngineRateLimits;
    }

    @Generated
    public String getEdgeEventRateLimits() {
        return this.edgeEventRateLimits;
    }

    @Generated
    public String getEdgeEventRateLimitsPerEdge() {
        return this.edgeEventRateLimitsPerEdge;
    }

    @Generated
    public String getEdgeUplinkMessagesRateLimits() {
        return this.edgeUplinkMessagesRateLimits;
    }

    @Generated
    public String getEdgeUplinkMessagesRateLimitsPerEdge() {
        return this.edgeUplinkMessagesRateLimitsPerEdge;
    }

    @Generated
    public int getDefaultStorageTtlDays() {
        return this.defaultStorageTtlDays;
    }

    @Generated
    public int getAlarmsTtlDays() {
        return this.alarmsTtlDays;
    }

    @Generated
    public int getRpcTtlDays() {
        return this.rpcTtlDays;
    }

    @Generated
    public int getQueueStatsTtlDays() {
        return this.queueStatsTtlDays;
    }

    @Generated
    public int getRuleEngineExceptionsTtlDays() {
        return this.ruleEngineExceptionsTtlDays;
    }

    @Generated
    public int getBlobEntityTtlDays() {
        return this.blobEntityTtlDays;
    }

    @Generated
    public int getReportTtlDays() {
        return this.reportTtlDays;
    }

    @Generated
    public double getWarnThreshold() {
        return this.warnThreshold;
    }

    @Generated
    public long getMaxCalculatedFieldsPerEntity() {
        return this.maxCalculatedFieldsPerEntity;
    }

    @Generated
    public long getMaxArgumentsPerCF() {
        return this.maxArgumentsPerCF;
    }

    @Generated
    public long getMaxDataPointsPerRollingArg() {
        return this.maxDataPointsPerRollingArg;
    }

    @Generated
    public long getMaxStateSizeInKBytes() {
        return this.maxStateSizeInKBytes;
    }

    @Generated
    public long getMaxSingleValueArgumentSizeInKBytes() {
        return this.maxSingleValueArgumentSizeInKBytes;
    }

    @Generated
    public void setMaxDevices(long maxDevices) {
        this.maxDevices = maxDevices;
    }

    @Generated
    public void setMaxAssets(long maxAssets) {
        this.maxAssets = maxAssets;
    }

    @Generated
    public void setMaxCustomers(long maxCustomers) {
        this.maxCustomers = maxCustomers;
    }

    @Generated
    public void setMaxUsers(long maxUsers) {
        this.maxUsers = maxUsers;
    }

    @Generated
    public void setMaxDashboards(long maxDashboards) {
        this.maxDashboards = maxDashboards;
    }

    @Generated
    public void setMaxRuleChains(long maxRuleChains) {
        this.maxRuleChains = maxRuleChains;
    }

    @Generated
    public void setMaxEdges(long maxEdges) {
        this.maxEdges = maxEdges;
    }

    @Generated
    public void setMaxResourcesInBytes(long maxResourcesInBytes) {
        this.maxResourcesInBytes = maxResourcesInBytes;
    }

    @Generated
    public void setMaxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
    }

    @Generated
    public void setMaxResourceSize(long maxResourceSize) {
        this.maxResourceSize = maxResourceSize;
    }

    @Generated
    public void setMaxReportSizeInBytes(long maxReportSizeInBytes) {
        this.maxReportSizeInBytes = maxReportSizeInBytes;
    }

    @Generated
    public void setMaxIntegrations(long maxIntegrations) {
        this.maxIntegrations = maxIntegrations;
    }

    @Generated
    public void setMaxConverters(long maxConverters) {
        this.maxConverters = maxConverters;
    }

    @Generated
    public void setMaxSchedulerEvents(long maxSchedulerEvents) {
        this.maxSchedulerEvents = maxSchedulerEvents;
    }

    @Generated
    public void setTransportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
    }

    @Generated
    public void setTransportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
    }

    @Generated
    public void setTransportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
    }

    @Generated
    public void setTransportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
    }

    @Generated
    public void setTransportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
    }

    @Generated
    public void setTransportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
    }

    @Generated
    public void setTransportGatewayMsgRateLimit(String transportGatewayMsgRateLimit) {
        this.transportGatewayMsgRateLimit = transportGatewayMsgRateLimit;
    }

    @Generated
    public void setTransportGatewayTelemetryMsgRateLimit(String transportGatewayTelemetryMsgRateLimit) {
        this.transportGatewayTelemetryMsgRateLimit = transportGatewayTelemetryMsgRateLimit;
    }

    @Generated
    public void setTransportGatewayTelemetryDataPointsRateLimit(String transportGatewayTelemetryDataPointsRateLimit) {
        this.transportGatewayTelemetryDataPointsRateLimit = transportGatewayTelemetryDataPointsRateLimit;
    }

    @Generated
    public void setTransportGatewayDeviceMsgRateLimit(String transportGatewayDeviceMsgRateLimit) {
        this.transportGatewayDeviceMsgRateLimit = transportGatewayDeviceMsgRateLimit;
    }

    @Generated
    public void setTransportGatewayDeviceTelemetryMsgRateLimit(String transportGatewayDeviceTelemetryMsgRateLimit) {
        this.transportGatewayDeviceTelemetryMsgRateLimit = transportGatewayDeviceTelemetryMsgRateLimit;
    }

    @Generated
    public void setTransportGatewayDeviceTelemetryDataPointsRateLimit(String transportGatewayDeviceTelemetryDataPointsRateLimit) {
        this.transportGatewayDeviceTelemetryDataPointsRateLimit = transportGatewayDeviceTelemetryDataPointsRateLimit;
    }

    @Generated
    public void setIntegrationMsgsPerTenantRateLimit(String integrationMsgsPerTenantRateLimit) {
        this.integrationMsgsPerTenantRateLimit = integrationMsgsPerTenantRateLimit;
    }

    @Generated
    public void setIntegrationMsgsPerDeviceRateLimit(String integrationMsgsPerDeviceRateLimit) {
        this.integrationMsgsPerDeviceRateLimit = integrationMsgsPerDeviceRateLimit;
    }

    @Generated
    public void setIntegrationMsgsPerAssetRateLimit(String integrationMsgsPerAssetRateLimit) {
        this.integrationMsgsPerAssetRateLimit = integrationMsgsPerAssetRateLimit;
    }

    @Generated
    public void setTenantEntityExportRateLimit(String tenantEntityExportRateLimit) {
        this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
    }

    @Generated
    public void setTenantEntityImportRateLimit(String tenantEntityImportRateLimit) {
        this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
    }

    @Generated
    public void setTenantNotificationRequestsRateLimit(String tenantNotificationRequestsRateLimit) {
        this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
    }

    @Generated
    public void setTenantNotificationRequestsPerRuleRateLimit(String tenantNotificationRequestsPerRuleRateLimit) {
        this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
    }

    @Generated
    public void setMaxTransportMessages(long maxTransportMessages) {
        this.maxTransportMessages = maxTransportMessages;
    }

    @Generated
    public void setMaxTransportDataPoints(long maxTransportDataPoints) {
        this.maxTransportDataPoints = maxTransportDataPoints;
    }

    @Generated
    public void setMaxREExecutions(long maxREExecutions) {
        this.maxREExecutions = maxREExecutions;
    }

    @Generated
    public void setMaxJSExecutions(long maxJSExecutions) {
        this.maxJSExecutions = maxJSExecutions;
    }

    @Generated
    public void setMaxTbelExecutions(long maxTbelExecutions) {
        this.maxTbelExecutions = maxTbelExecutions;
    }

    @Generated
    public void setMaxDPStorageDays(long maxDPStorageDays) {
        this.maxDPStorageDays = maxDPStorageDays;
    }

    @Generated
    public void setMaxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
    }

    @Generated
    public void setMaxDebugModeDurationMinutes(int maxDebugModeDurationMinutes) {
        this.maxDebugModeDurationMinutes = maxDebugModeDurationMinutes;
    }

    @Generated
    public void setMaxEmails(long maxEmails) {
        this.maxEmails = maxEmails;
    }

    @Generated
    public void setSmsEnabled(Boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
    }

    @Generated
    public void setMaxSms(long maxSms) {
        this.maxSms = maxSms;
    }

    @Generated
    public void setMaxCreatedAlarms(long maxCreatedAlarms) {
        this.maxCreatedAlarms = maxCreatedAlarms;
    }

    @Generated
    public void setMaxGeneratedReports(long maxGeneratedReports) {
        this.maxGeneratedReports = maxGeneratedReports;
    }

    @Generated
    public void setTenantServerRestLimitsConfiguration(String tenantServerRestLimitsConfiguration) {
        this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
    }

    @Generated
    public void setCustomerServerRestLimitsConfiguration(String customerServerRestLimitsConfiguration) {
        this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
    }

    @Generated
    public void setMaxWsSessionsPerTenant(int maxWsSessionsPerTenant) {
        this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
    }

    @Generated
    public void setMaxWsSessionsPerCustomer(int maxWsSessionsPerCustomer) {
        this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
    }

    @Generated
    public void setMaxWsSessionsPerRegularUser(int maxWsSessionsPerRegularUser) {
        this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
    }

    @Generated
    public void setMaxWsSessionsPerPublicUser(int maxWsSessionsPerPublicUser) {
        this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
    }

    @Generated
    public void setWsMsgQueueLimitPerSession(int wsMsgQueueLimitPerSession) {
        this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
    }

    @Generated
    public void setMaxWsSubscriptionsPerTenant(long maxWsSubscriptionsPerTenant) {
        this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
    }

    @Generated
    public void setMaxWsSubscriptionsPerCustomer(long maxWsSubscriptionsPerCustomer) {
        this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
    }

    @Generated
    public void setMaxWsSubscriptionsPerRegularUser(long maxWsSubscriptionsPerRegularUser) {
        this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
    }

    @Generated
    public void setMaxWsSubscriptionsPerPublicUser(long maxWsSubscriptionsPerPublicUser) {
        this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
    }

    @Generated
    public void setWsUpdatesPerSessionRateLimit(String wsUpdatesPerSessionRateLimit) {
        this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
    }

    @Generated
    public void setCassandraReadQueryTenantCoreRateLimits(String cassandraReadQueryTenantCoreRateLimits) {
        this.cassandraReadQueryTenantCoreRateLimits = cassandraReadQueryTenantCoreRateLimits;
    }

    @Generated
    public void setCassandraWriteQueryTenantCoreRateLimits(String cassandraWriteQueryTenantCoreRateLimits) {
        this.cassandraWriteQueryTenantCoreRateLimits = cassandraWriteQueryTenantCoreRateLimits;
    }

    @Generated
    public void setCassandraReadQueryTenantRuleEngineRateLimits(String cassandraReadQueryTenantRuleEngineRateLimits) {
        this.cassandraReadQueryTenantRuleEngineRateLimits = cassandraReadQueryTenantRuleEngineRateLimits;
    }

    @Generated
    public void setCassandraWriteQueryTenantRuleEngineRateLimits(String cassandraWriteQueryTenantRuleEngineRateLimits) {
        this.cassandraWriteQueryTenantRuleEngineRateLimits = cassandraWriteQueryTenantRuleEngineRateLimits;
    }

    @Generated
    public void setEdgeEventRateLimits(String edgeEventRateLimits) {
        this.edgeEventRateLimits = edgeEventRateLimits;
    }

    @Generated
    public void setEdgeEventRateLimitsPerEdge(String edgeEventRateLimitsPerEdge) {
        this.edgeEventRateLimitsPerEdge = edgeEventRateLimitsPerEdge;
    }

    @Generated
    public void setEdgeUplinkMessagesRateLimits(String edgeUplinkMessagesRateLimits) {
        this.edgeUplinkMessagesRateLimits = edgeUplinkMessagesRateLimits;
    }

    @Generated
    public void setEdgeUplinkMessagesRateLimitsPerEdge(String edgeUplinkMessagesRateLimitsPerEdge) {
        this.edgeUplinkMessagesRateLimitsPerEdge = edgeUplinkMessagesRateLimitsPerEdge;
    }

    @Generated
    public void setDefaultStorageTtlDays(int defaultStorageTtlDays) {
        this.defaultStorageTtlDays = defaultStorageTtlDays;
    }

    @Generated
    public void setAlarmsTtlDays(int alarmsTtlDays) {
        this.alarmsTtlDays = alarmsTtlDays;
    }

    @Generated
    public void setRpcTtlDays(int rpcTtlDays) {
        this.rpcTtlDays = rpcTtlDays;
    }

    @Generated
    public void setQueueStatsTtlDays(int queueStatsTtlDays) {
        this.queueStatsTtlDays = queueStatsTtlDays;
    }

    @Generated
    public void setRuleEngineExceptionsTtlDays(int ruleEngineExceptionsTtlDays) {
        this.ruleEngineExceptionsTtlDays = ruleEngineExceptionsTtlDays;
    }

    @Generated
    public void setBlobEntityTtlDays(int blobEntityTtlDays) {
        this.blobEntityTtlDays = blobEntityTtlDays;
    }

    @Generated
    public void setReportTtlDays(int reportTtlDays) {
        this.reportTtlDays = reportTtlDays;
    }

    @Generated
    public void setWarnThreshold(double warnThreshold) {
        this.warnThreshold = warnThreshold;
    }

    @Generated
    public void setMaxCalculatedFieldsPerEntity(long maxCalculatedFieldsPerEntity) {
        this.maxCalculatedFieldsPerEntity = maxCalculatedFieldsPerEntity;
    }

    @Generated
    public void setMaxArgumentsPerCF(long maxArgumentsPerCF) {
        this.maxArgumentsPerCF = maxArgumentsPerCF;
    }

    @Generated
    public void setMaxDataPointsPerRollingArg(long maxDataPointsPerRollingArg) {
        this.maxDataPointsPerRollingArg = maxDataPointsPerRollingArg;
    }

    @Generated
    public void setMaxStateSizeInKBytes(long maxStateSizeInKBytes) {
        this.maxStateSizeInKBytes = maxStateSizeInKBytes;
    }

    @Generated
    public void setMaxSingleValueArgumentSizeInKBytes(long maxSingleValueArgumentSizeInKBytes) {
        this.maxSingleValueArgumentSizeInKBytes = maxSingleValueArgumentSizeInKBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTenantProfileConfiguration)) {
            return false;
        }
        DefaultTenantProfileConfiguration other = (DefaultTenantProfileConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxDevices() != other.getMaxDevices()) {
            return false;
        }
        if (this.getMaxAssets() != other.getMaxAssets()) {
            return false;
        }
        if (this.getMaxCustomers() != other.getMaxCustomers()) {
            return false;
        }
        if (this.getMaxUsers() != other.getMaxUsers()) {
            return false;
        }
        if (this.getMaxDashboards() != other.getMaxDashboards()) {
            return false;
        }
        if (this.getMaxRuleChains() != other.getMaxRuleChains()) {
            return false;
        }
        if (this.getMaxEdges() != other.getMaxEdges()) {
            return false;
        }
        if (this.getMaxResourcesInBytes() != other.getMaxResourcesInBytes()) {
            return false;
        }
        if (this.getMaxOtaPackagesInBytes() != other.getMaxOtaPackagesInBytes()) {
            return false;
        }
        if (this.getMaxResourceSize() != other.getMaxResourceSize()) {
            return false;
        }
        if (this.getMaxReportSizeInBytes() != other.getMaxReportSizeInBytes()) {
            return false;
        }
        if (this.getMaxIntegrations() != other.getMaxIntegrations()) {
            return false;
        }
        if (this.getMaxConverters() != other.getMaxConverters()) {
            return false;
        }
        if (this.getMaxSchedulerEvents() != other.getMaxSchedulerEvents()) {
            return false;
        }
        if (this.getMaxTransportMessages() != other.getMaxTransportMessages()) {
            return false;
        }
        if (this.getMaxTransportDataPoints() != other.getMaxTransportDataPoints()) {
            return false;
        }
        if (this.getMaxREExecutions() != other.getMaxREExecutions()) {
            return false;
        }
        if (this.getMaxJSExecutions() != other.getMaxJSExecutions()) {
            return false;
        }
        if (this.getMaxTbelExecutions() != other.getMaxTbelExecutions()) {
            return false;
        }
        if (this.getMaxDPStorageDays() != other.getMaxDPStorageDays()) {
            return false;
        }
        if (this.getMaxRuleNodeExecutionsPerMessage() != other.getMaxRuleNodeExecutionsPerMessage()) {
            return false;
        }
        if (this.getMaxDebugModeDurationMinutes() != other.getMaxDebugModeDurationMinutes()) {
            return false;
        }
        if (this.getMaxEmails() != other.getMaxEmails()) {
            return false;
        }
        if (this.getMaxSms() != other.getMaxSms()) {
            return false;
        }
        if (this.getMaxCreatedAlarms() != other.getMaxCreatedAlarms()) {
            return false;
        }
        if (this.getMaxGeneratedReports() != other.getMaxGeneratedReports()) {
            return false;
        }
        if (this.getMaxWsSessionsPerTenant() != other.getMaxWsSessionsPerTenant()) {
            return false;
        }
        if (this.getMaxWsSessionsPerCustomer() != other.getMaxWsSessionsPerCustomer()) {
            return false;
        }
        if (this.getMaxWsSessionsPerRegularUser() != other.getMaxWsSessionsPerRegularUser()) {
            return false;
        }
        if (this.getMaxWsSessionsPerPublicUser() != other.getMaxWsSessionsPerPublicUser()) {
            return false;
        }
        if (this.getWsMsgQueueLimitPerSession() != other.getWsMsgQueueLimitPerSession()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerTenant() != other.getMaxWsSubscriptionsPerTenant()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerCustomer() != other.getMaxWsSubscriptionsPerCustomer()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerRegularUser() != other.getMaxWsSubscriptionsPerRegularUser()) {
            return false;
        }
        if (this.getMaxWsSubscriptionsPerPublicUser() != other.getMaxWsSubscriptionsPerPublicUser()) {
            return false;
        }
        if (this.getDefaultStorageTtlDays() != other.getDefaultStorageTtlDays()) {
            return false;
        }
        if (this.getAlarmsTtlDays() != other.getAlarmsTtlDays()) {
            return false;
        }
        if (this.getRpcTtlDays() != other.getRpcTtlDays()) {
            return false;
        }
        if (this.getQueueStatsTtlDays() != other.getQueueStatsTtlDays()) {
            return false;
        }
        if (this.getRuleEngineExceptionsTtlDays() != other.getRuleEngineExceptionsTtlDays()) {
            return false;
        }
        if (this.getBlobEntityTtlDays() != other.getBlobEntityTtlDays()) {
            return false;
        }
        if (this.getReportTtlDays() != other.getReportTtlDays()) {
            return false;
        }
        if (Double.compare(this.getWarnThreshold(), other.getWarnThreshold()) != 0) {
            return false;
        }
        if (this.getMaxCalculatedFieldsPerEntity() != other.getMaxCalculatedFieldsPerEntity()) {
            return false;
        }
        if (this.getMaxArgumentsPerCF() != other.getMaxArgumentsPerCF()) {
            return false;
        }
        if (this.getMaxDataPointsPerRollingArg() != other.getMaxDataPointsPerRollingArg()) {
            return false;
        }
        if (this.getMaxStateSizeInKBytes() != other.getMaxStateSizeInKBytes()) {
            return false;
        }
        if (this.getMaxSingleValueArgumentSizeInKBytes() != other.getMaxSingleValueArgumentSizeInKBytes()) {
            return false;
        }
        Boolean this$smsEnabled = this.getSmsEnabled();
        Boolean other$smsEnabled = other.getSmsEnabled();
        if (this$smsEnabled == null ? other$smsEnabled != null : !((Object)this$smsEnabled).equals(other$smsEnabled)) {
            return false;
        }
        String this$transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        String other$transportTenantMsgRateLimit = other.getTransportTenantMsgRateLimit();
        if (this$transportTenantMsgRateLimit == null ? other$transportTenantMsgRateLimit != null : !this$transportTenantMsgRateLimit.equals(other$transportTenantMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        String other$transportTenantTelemetryMsgRateLimit = other.getTransportTenantTelemetryMsgRateLimit();
        if (this$transportTenantTelemetryMsgRateLimit == null ? other$transportTenantTelemetryMsgRateLimit != null : !this$transportTenantTelemetryMsgRateLimit.equals(other$transportTenantTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        String other$transportTenantTelemetryDataPointsRateLimit = other.getTransportTenantTelemetryDataPointsRateLimit();
        if (this$transportTenantTelemetryDataPointsRateLimit == null ? other$transportTenantTelemetryDataPointsRateLimit != null : !this$transportTenantTelemetryDataPointsRateLimit.equals(other$transportTenantTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        String other$transportDeviceMsgRateLimit = other.getTransportDeviceMsgRateLimit();
        if (this$transportDeviceMsgRateLimit == null ? other$transportDeviceMsgRateLimit != null : !this$transportDeviceMsgRateLimit.equals(other$transportDeviceMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        String other$transportDeviceTelemetryMsgRateLimit = other.getTransportDeviceTelemetryMsgRateLimit();
        if (this$transportDeviceTelemetryMsgRateLimit == null ? other$transportDeviceTelemetryMsgRateLimit != null : !this$transportDeviceTelemetryMsgRateLimit.equals(other$transportDeviceTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        String other$transportDeviceTelemetryDataPointsRateLimit = other.getTransportDeviceTelemetryDataPointsRateLimit();
        if (this$transportDeviceTelemetryDataPointsRateLimit == null ? other$transportDeviceTelemetryDataPointsRateLimit != null : !this$transportDeviceTelemetryDataPointsRateLimit.equals(other$transportDeviceTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$transportGatewayMsgRateLimit = this.getTransportGatewayMsgRateLimit();
        String other$transportGatewayMsgRateLimit = other.getTransportGatewayMsgRateLimit();
        if (this$transportGatewayMsgRateLimit == null ? other$transportGatewayMsgRateLimit != null : !this$transportGatewayMsgRateLimit.equals(other$transportGatewayMsgRateLimit)) {
            return false;
        }
        String this$transportGatewayTelemetryMsgRateLimit = this.getTransportGatewayTelemetryMsgRateLimit();
        String other$transportGatewayTelemetryMsgRateLimit = other.getTransportGatewayTelemetryMsgRateLimit();
        if (this$transportGatewayTelemetryMsgRateLimit == null ? other$transportGatewayTelemetryMsgRateLimit != null : !this$transportGatewayTelemetryMsgRateLimit.equals(other$transportGatewayTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportGatewayTelemetryDataPointsRateLimit = this.getTransportGatewayTelemetryDataPointsRateLimit();
        String other$transportGatewayTelemetryDataPointsRateLimit = other.getTransportGatewayTelemetryDataPointsRateLimit();
        if (this$transportGatewayTelemetryDataPointsRateLimit == null ? other$transportGatewayTelemetryDataPointsRateLimit != null : !this$transportGatewayTelemetryDataPointsRateLimit.equals(other$transportGatewayTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$transportGatewayDeviceMsgRateLimit = this.getTransportGatewayDeviceMsgRateLimit();
        String other$transportGatewayDeviceMsgRateLimit = other.getTransportGatewayDeviceMsgRateLimit();
        if (this$transportGatewayDeviceMsgRateLimit == null ? other$transportGatewayDeviceMsgRateLimit != null : !this$transportGatewayDeviceMsgRateLimit.equals(other$transportGatewayDeviceMsgRateLimit)) {
            return false;
        }
        String this$transportGatewayDeviceTelemetryMsgRateLimit = this.getTransportGatewayDeviceTelemetryMsgRateLimit();
        String other$transportGatewayDeviceTelemetryMsgRateLimit = other.getTransportGatewayDeviceTelemetryMsgRateLimit();
        if (this$transportGatewayDeviceTelemetryMsgRateLimit == null ? other$transportGatewayDeviceTelemetryMsgRateLimit != null : !this$transportGatewayDeviceTelemetryMsgRateLimit.equals(other$transportGatewayDeviceTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportGatewayDeviceTelemetryDataPointsRateLimit = this.getTransportGatewayDeviceTelemetryDataPointsRateLimit();
        String other$transportGatewayDeviceTelemetryDataPointsRateLimit = other.getTransportGatewayDeviceTelemetryDataPointsRateLimit();
        if (this$transportGatewayDeviceTelemetryDataPointsRateLimit == null ? other$transportGatewayDeviceTelemetryDataPointsRateLimit != null : !this$transportGatewayDeviceTelemetryDataPointsRateLimit.equals(other$transportGatewayDeviceTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$integrationMsgsPerTenantRateLimit = this.getIntegrationMsgsPerTenantRateLimit();
        String other$integrationMsgsPerTenantRateLimit = other.getIntegrationMsgsPerTenantRateLimit();
        if (this$integrationMsgsPerTenantRateLimit == null ? other$integrationMsgsPerTenantRateLimit != null : !this$integrationMsgsPerTenantRateLimit.equals(other$integrationMsgsPerTenantRateLimit)) {
            return false;
        }
        String this$integrationMsgsPerDeviceRateLimit = this.getIntegrationMsgsPerDeviceRateLimit();
        String other$integrationMsgsPerDeviceRateLimit = other.getIntegrationMsgsPerDeviceRateLimit();
        if (this$integrationMsgsPerDeviceRateLimit == null ? other$integrationMsgsPerDeviceRateLimit != null : !this$integrationMsgsPerDeviceRateLimit.equals(other$integrationMsgsPerDeviceRateLimit)) {
            return false;
        }
        String this$integrationMsgsPerAssetRateLimit = this.getIntegrationMsgsPerAssetRateLimit();
        String other$integrationMsgsPerAssetRateLimit = other.getIntegrationMsgsPerAssetRateLimit();
        if (this$integrationMsgsPerAssetRateLimit == null ? other$integrationMsgsPerAssetRateLimit != null : !this$integrationMsgsPerAssetRateLimit.equals(other$integrationMsgsPerAssetRateLimit)) {
            return false;
        }
        String this$tenantEntityExportRateLimit = this.getTenantEntityExportRateLimit();
        String other$tenantEntityExportRateLimit = other.getTenantEntityExportRateLimit();
        if (this$tenantEntityExportRateLimit == null ? other$tenantEntityExportRateLimit != null : !this$tenantEntityExportRateLimit.equals(other$tenantEntityExportRateLimit)) {
            return false;
        }
        String this$tenantEntityImportRateLimit = this.getTenantEntityImportRateLimit();
        String other$tenantEntityImportRateLimit = other.getTenantEntityImportRateLimit();
        if (this$tenantEntityImportRateLimit == null ? other$tenantEntityImportRateLimit != null : !this$tenantEntityImportRateLimit.equals(other$tenantEntityImportRateLimit)) {
            return false;
        }
        String this$tenantNotificationRequestsRateLimit = this.getTenantNotificationRequestsRateLimit();
        String other$tenantNotificationRequestsRateLimit = other.getTenantNotificationRequestsRateLimit();
        if (this$tenantNotificationRequestsRateLimit == null ? other$tenantNotificationRequestsRateLimit != null : !this$tenantNotificationRequestsRateLimit.equals(other$tenantNotificationRequestsRateLimit)) {
            return false;
        }
        String this$tenantNotificationRequestsPerRuleRateLimit = this.getTenantNotificationRequestsPerRuleRateLimit();
        String other$tenantNotificationRequestsPerRuleRateLimit = other.getTenantNotificationRequestsPerRuleRateLimit();
        if (this$tenantNotificationRequestsPerRuleRateLimit == null ? other$tenantNotificationRequestsPerRuleRateLimit != null : !this$tenantNotificationRequestsPerRuleRateLimit.equals(other$tenantNotificationRequestsPerRuleRateLimit)) {
            return false;
        }
        String this$tenantServerRestLimitsConfiguration = this.getTenantServerRestLimitsConfiguration();
        String other$tenantServerRestLimitsConfiguration = other.getTenantServerRestLimitsConfiguration();
        if (this$tenantServerRestLimitsConfiguration == null ? other$tenantServerRestLimitsConfiguration != null : !this$tenantServerRestLimitsConfiguration.equals(other$tenantServerRestLimitsConfiguration)) {
            return false;
        }
        String this$customerServerRestLimitsConfiguration = this.getCustomerServerRestLimitsConfiguration();
        String other$customerServerRestLimitsConfiguration = other.getCustomerServerRestLimitsConfiguration();
        if (this$customerServerRestLimitsConfiguration == null ? other$customerServerRestLimitsConfiguration != null : !this$customerServerRestLimitsConfiguration.equals(other$customerServerRestLimitsConfiguration)) {
            return false;
        }
        String this$wsUpdatesPerSessionRateLimit = this.getWsUpdatesPerSessionRateLimit();
        String other$wsUpdatesPerSessionRateLimit = other.getWsUpdatesPerSessionRateLimit();
        if (this$wsUpdatesPerSessionRateLimit == null ? other$wsUpdatesPerSessionRateLimit != null : !this$wsUpdatesPerSessionRateLimit.equals(other$wsUpdatesPerSessionRateLimit)) {
            return false;
        }
        String this$cassandraReadQueryTenantCoreRateLimits = this.getCassandraReadQueryTenantCoreRateLimits();
        String other$cassandraReadQueryTenantCoreRateLimits = other.getCassandraReadQueryTenantCoreRateLimits();
        if (this$cassandraReadQueryTenantCoreRateLimits == null ? other$cassandraReadQueryTenantCoreRateLimits != null : !this$cassandraReadQueryTenantCoreRateLimits.equals(other$cassandraReadQueryTenantCoreRateLimits)) {
            return false;
        }
        String this$cassandraWriteQueryTenantCoreRateLimits = this.getCassandraWriteQueryTenantCoreRateLimits();
        String other$cassandraWriteQueryTenantCoreRateLimits = other.getCassandraWriteQueryTenantCoreRateLimits();
        if (this$cassandraWriteQueryTenantCoreRateLimits == null ? other$cassandraWriteQueryTenantCoreRateLimits != null : !this$cassandraWriteQueryTenantCoreRateLimits.equals(other$cassandraWriteQueryTenantCoreRateLimits)) {
            return false;
        }
        String this$cassandraReadQueryTenantRuleEngineRateLimits = this.getCassandraReadQueryTenantRuleEngineRateLimits();
        String other$cassandraReadQueryTenantRuleEngineRateLimits = other.getCassandraReadQueryTenantRuleEngineRateLimits();
        if (this$cassandraReadQueryTenantRuleEngineRateLimits == null ? other$cassandraReadQueryTenantRuleEngineRateLimits != null : !this$cassandraReadQueryTenantRuleEngineRateLimits.equals(other$cassandraReadQueryTenantRuleEngineRateLimits)) {
            return false;
        }
        String this$cassandraWriteQueryTenantRuleEngineRateLimits = this.getCassandraWriteQueryTenantRuleEngineRateLimits();
        String other$cassandraWriteQueryTenantRuleEngineRateLimits = other.getCassandraWriteQueryTenantRuleEngineRateLimits();
        if (this$cassandraWriteQueryTenantRuleEngineRateLimits == null ? other$cassandraWriteQueryTenantRuleEngineRateLimits != null : !this$cassandraWriteQueryTenantRuleEngineRateLimits.equals(other$cassandraWriteQueryTenantRuleEngineRateLimits)) {
            return false;
        }
        String this$edgeEventRateLimits = this.getEdgeEventRateLimits();
        String other$edgeEventRateLimits = other.getEdgeEventRateLimits();
        if (this$edgeEventRateLimits == null ? other$edgeEventRateLimits != null : !this$edgeEventRateLimits.equals(other$edgeEventRateLimits)) {
            return false;
        }
        String this$edgeEventRateLimitsPerEdge = this.getEdgeEventRateLimitsPerEdge();
        String other$edgeEventRateLimitsPerEdge = other.getEdgeEventRateLimitsPerEdge();
        if (this$edgeEventRateLimitsPerEdge == null ? other$edgeEventRateLimitsPerEdge != null : !this$edgeEventRateLimitsPerEdge.equals(other$edgeEventRateLimitsPerEdge)) {
            return false;
        }
        String this$edgeUplinkMessagesRateLimits = this.getEdgeUplinkMessagesRateLimits();
        String other$edgeUplinkMessagesRateLimits = other.getEdgeUplinkMessagesRateLimits();
        if (this$edgeUplinkMessagesRateLimits == null ? other$edgeUplinkMessagesRateLimits != null : !this$edgeUplinkMessagesRateLimits.equals(other$edgeUplinkMessagesRateLimits)) {
            return false;
        }
        String this$edgeUplinkMessagesRateLimitsPerEdge = this.getEdgeUplinkMessagesRateLimitsPerEdge();
        String other$edgeUplinkMessagesRateLimitsPerEdge = other.getEdgeUplinkMessagesRateLimitsPerEdge();
        return !(this$edgeUplinkMessagesRateLimitsPerEdge == null ? other$edgeUplinkMessagesRateLimitsPerEdge != null : !this$edgeUplinkMessagesRateLimitsPerEdge.equals(other$edgeUplinkMessagesRateLimitsPerEdge));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultTenantProfileConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxDevices = this.getMaxDevices();
        result = result * 59 + (int)($maxDevices >>> 32 ^ $maxDevices);
        long $maxAssets = this.getMaxAssets();
        result = result * 59 + (int)($maxAssets >>> 32 ^ $maxAssets);
        long $maxCustomers = this.getMaxCustomers();
        result = result * 59 + (int)($maxCustomers >>> 32 ^ $maxCustomers);
        long $maxUsers = this.getMaxUsers();
        result = result * 59 + (int)($maxUsers >>> 32 ^ $maxUsers);
        long $maxDashboards = this.getMaxDashboards();
        result = result * 59 + (int)($maxDashboards >>> 32 ^ $maxDashboards);
        long $maxRuleChains = this.getMaxRuleChains();
        result = result * 59 + (int)($maxRuleChains >>> 32 ^ $maxRuleChains);
        long $maxEdges = this.getMaxEdges();
        result = result * 59 + (int)($maxEdges >>> 32 ^ $maxEdges);
        long $maxResourcesInBytes = this.getMaxResourcesInBytes();
        result = result * 59 + (int)($maxResourcesInBytes >>> 32 ^ $maxResourcesInBytes);
        long $maxOtaPackagesInBytes = this.getMaxOtaPackagesInBytes();
        result = result * 59 + (int)($maxOtaPackagesInBytes >>> 32 ^ $maxOtaPackagesInBytes);
        long $maxResourceSize = this.getMaxResourceSize();
        result = result * 59 + (int)($maxResourceSize >>> 32 ^ $maxResourceSize);
        long $maxReportSizeInBytes = this.getMaxReportSizeInBytes();
        result = result * 59 + (int)($maxReportSizeInBytes >>> 32 ^ $maxReportSizeInBytes);
        long $maxIntegrations = this.getMaxIntegrations();
        result = result * 59 + (int)($maxIntegrations >>> 32 ^ $maxIntegrations);
        long $maxConverters = this.getMaxConverters();
        result = result * 59 + (int)($maxConverters >>> 32 ^ $maxConverters);
        long $maxSchedulerEvents = this.getMaxSchedulerEvents();
        result = result * 59 + (int)($maxSchedulerEvents >>> 32 ^ $maxSchedulerEvents);
        long $maxTransportMessages = this.getMaxTransportMessages();
        result = result * 59 + (int)($maxTransportMessages >>> 32 ^ $maxTransportMessages);
        long $maxTransportDataPoints = this.getMaxTransportDataPoints();
        result = result * 59 + (int)($maxTransportDataPoints >>> 32 ^ $maxTransportDataPoints);
        long $maxREExecutions = this.getMaxREExecutions();
        result = result * 59 + (int)($maxREExecutions >>> 32 ^ $maxREExecutions);
        long $maxJSExecutions = this.getMaxJSExecutions();
        result = result * 59 + (int)($maxJSExecutions >>> 32 ^ $maxJSExecutions);
        long $maxTbelExecutions = this.getMaxTbelExecutions();
        result = result * 59 + (int)($maxTbelExecutions >>> 32 ^ $maxTbelExecutions);
        long $maxDPStorageDays = this.getMaxDPStorageDays();
        result = result * 59 + (int)($maxDPStorageDays >>> 32 ^ $maxDPStorageDays);
        result = result * 59 + this.getMaxRuleNodeExecutionsPerMessage();
        result = result * 59 + this.getMaxDebugModeDurationMinutes();
        long $maxEmails = this.getMaxEmails();
        result = result * 59 + (int)($maxEmails >>> 32 ^ $maxEmails);
        long $maxSms = this.getMaxSms();
        result = result * 59 + (int)($maxSms >>> 32 ^ $maxSms);
        long $maxCreatedAlarms = this.getMaxCreatedAlarms();
        result = result * 59 + (int)($maxCreatedAlarms >>> 32 ^ $maxCreatedAlarms);
        long $maxGeneratedReports = this.getMaxGeneratedReports();
        result = result * 59 + (int)($maxGeneratedReports >>> 32 ^ $maxGeneratedReports);
        result = result * 59 + this.getMaxWsSessionsPerTenant();
        result = result * 59 + this.getMaxWsSessionsPerCustomer();
        result = result * 59 + this.getMaxWsSessionsPerRegularUser();
        result = result * 59 + this.getMaxWsSessionsPerPublicUser();
        result = result * 59 + this.getWsMsgQueueLimitPerSession();
        long $maxWsSubscriptionsPerTenant = this.getMaxWsSubscriptionsPerTenant();
        result = result * 59 + (int)($maxWsSubscriptionsPerTenant >>> 32 ^ $maxWsSubscriptionsPerTenant);
        long $maxWsSubscriptionsPerCustomer = this.getMaxWsSubscriptionsPerCustomer();
        result = result * 59 + (int)($maxWsSubscriptionsPerCustomer >>> 32 ^ $maxWsSubscriptionsPerCustomer);
        long $maxWsSubscriptionsPerRegularUser = this.getMaxWsSubscriptionsPerRegularUser();
        result = result * 59 + (int)($maxWsSubscriptionsPerRegularUser >>> 32 ^ $maxWsSubscriptionsPerRegularUser);
        long $maxWsSubscriptionsPerPublicUser = this.getMaxWsSubscriptionsPerPublicUser();
        result = result * 59 + (int)($maxWsSubscriptionsPerPublicUser >>> 32 ^ $maxWsSubscriptionsPerPublicUser);
        result = result * 59 + this.getDefaultStorageTtlDays();
        result = result * 59 + this.getAlarmsTtlDays();
        result = result * 59 + this.getRpcTtlDays();
        result = result * 59 + this.getQueueStatsTtlDays();
        result = result * 59 + this.getRuleEngineExceptionsTtlDays();
        result = result * 59 + this.getBlobEntityTtlDays();
        result = result * 59 + this.getReportTtlDays();
        long $warnThreshold = Double.doubleToLongBits(this.getWarnThreshold());
        result = result * 59 + (int)($warnThreshold >>> 32 ^ $warnThreshold);
        long $maxCalculatedFieldsPerEntity = this.getMaxCalculatedFieldsPerEntity();
        result = result * 59 + (int)($maxCalculatedFieldsPerEntity >>> 32 ^ $maxCalculatedFieldsPerEntity);
        long $maxArgumentsPerCF = this.getMaxArgumentsPerCF();
        result = result * 59 + (int)($maxArgumentsPerCF >>> 32 ^ $maxArgumentsPerCF);
        long $maxDataPointsPerRollingArg = this.getMaxDataPointsPerRollingArg();
        result = result * 59 + (int)($maxDataPointsPerRollingArg >>> 32 ^ $maxDataPointsPerRollingArg);
        long $maxStateSizeInKBytes = this.getMaxStateSizeInKBytes();
        result = result * 59 + (int)($maxStateSizeInKBytes >>> 32 ^ $maxStateSizeInKBytes);
        long $maxSingleValueArgumentSizeInKBytes = this.getMaxSingleValueArgumentSizeInKBytes();
        result = result * 59 + (int)($maxSingleValueArgumentSizeInKBytes >>> 32 ^ $maxSingleValueArgumentSizeInKBytes);
        Boolean $smsEnabled = this.getSmsEnabled();
        result = result * 59 + ($smsEnabled == null ? 43 : ((Object)$smsEnabled).hashCode());
        String $transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        result = result * 59 + ($transportTenantMsgRateLimit == null ? 43 : $transportTenantMsgRateLimit.hashCode());
        String $transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        result = result * 59 + ($transportTenantTelemetryMsgRateLimit == null ? 43 : $transportTenantTelemetryMsgRateLimit.hashCode());
        String $transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportTenantTelemetryDataPointsRateLimit == null ? 43 : $transportTenantTelemetryDataPointsRateLimit.hashCode());
        String $transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        result = result * 59 + ($transportDeviceMsgRateLimit == null ? 43 : $transportDeviceMsgRateLimit.hashCode());
        String $transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        result = result * 59 + ($transportDeviceTelemetryMsgRateLimit == null ? 43 : $transportDeviceTelemetryMsgRateLimit.hashCode());
        String $transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportDeviceTelemetryDataPointsRateLimit == null ? 43 : $transportDeviceTelemetryDataPointsRateLimit.hashCode());
        String $transportGatewayMsgRateLimit = this.getTransportGatewayMsgRateLimit();
        result = result * 59 + ($transportGatewayMsgRateLimit == null ? 43 : $transportGatewayMsgRateLimit.hashCode());
        String $transportGatewayTelemetryMsgRateLimit = this.getTransportGatewayTelemetryMsgRateLimit();
        result = result * 59 + ($transportGatewayTelemetryMsgRateLimit == null ? 43 : $transportGatewayTelemetryMsgRateLimit.hashCode());
        String $transportGatewayTelemetryDataPointsRateLimit = this.getTransportGatewayTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportGatewayTelemetryDataPointsRateLimit == null ? 43 : $transportGatewayTelemetryDataPointsRateLimit.hashCode());
        String $transportGatewayDeviceMsgRateLimit = this.getTransportGatewayDeviceMsgRateLimit();
        result = result * 59 + ($transportGatewayDeviceMsgRateLimit == null ? 43 : $transportGatewayDeviceMsgRateLimit.hashCode());
        String $transportGatewayDeviceTelemetryMsgRateLimit = this.getTransportGatewayDeviceTelemetryMsgRateLimit();
        result = result * 59 + ($transportGatewayDeviceTelemetryMsgRateLimit == null ? 43 : $transportGatewayDeviceTelemetryMsgRateLimit.hashCode());
        String $transportGatewayDeviceTelemetryDataPointsRateLimit = this.getTransportGatewayDeviceTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportGatewayDeviceTelemetryDataPointsRateLimit == null ? 43 : $transportGatewayDeviceTelemetryDataPointsRateLimit.hashCode());
        String $integrationMsgsPerTenantRateLimit = this.getIntegrationMsgsPerTenantRateLimit();
        result = result * 59 + ($integrationMsgsPerTenantRateLimit == null ? 43 : $integrationMsgsPerTenantRateLimit.hashCode());
        String $integrationMsgsPerDeviceRateLimit = this.getIntegrationMsgsPerDeviceRateLimit();
        result = result * 59 + ($integrationMsgsPerDeviceRateLimit == null ? 43 : $integrationMsgsPerDeviceRateLimit.hashCode());
        String $integrationMsgsPerAssetRateLimit = this.getIntegrationMsgsPerAssetRateLimit();
        result = result * 59 + ($integrationMsgsPerAssetRateLimit == null ? 43 : $integrationMsgsPerAssetRateLimit.hashCode());
        String $tenantEntityExportRateLimit = this.getTenantEntityExportRateLimit();
        result = result * 59 + ($tenantEntityExportRateLimit == null ? 43 : $tenantEntityExportRateLimit.hashCode());
        String $tenantEntityImportRateLimit = this.getTenantEntityImportRateLimit();
        result = result * 59 + ($tenantEntityImportRateLimit == null ? 43 : $tenantEntityImportRateLimit.hashCode());
        String $tenantNotificationRequestsRateLimit = this.getTenantNotificationRequestsRateLimit();
        result = result * 59 + ($tenantNotificationRequestsRateLimit == null ? 43 : $tenantNotificationRequestsRateLimit.hashCode());
        String $tenantNotificationRequestsPerRuleRateLimit = this.getTenantNotificationRequestsPerRuleRateLimit();
        result = result * 59 + ($tenantNotificationRequestsPerRuleRateLimit == null ? 43 : $tenantNotificationRequestsPerRuleRateLimit.hashCode());
        String $tenantServerRestLimitsConfiguration = this.getTenantServerRestLimitsConfiguration();
        result = result * 59 + ($tenantServerRestLimitsConfiguration == null ? 43 : $tenantServerRestLimitsConfiguration.hashCode());
        String $customerServerRestLimitsConfiguration = this.getCustomerServerRestLimitsConfiguration();
        result = result * 59 + ($customerServerRestLimitsConfiguration == null ? 43 : $customerServerRestLimitsConfiguration.hashCode());
        String $wsUpdatesPerSessionRateLimit = this.getWsUpdatesPerSessionRateLimit();
        result = result * 59 + ($wsUpdatesPerSessionRateLimit == null ? 43 : $wsUpdatesPerSessionRateLimit.hashCode());
        String $cassandraReadQueryTenantCoreRateLimits = this.getCassandraReadQueryTenantCoreRateLimits();
        result = result * 59 + ($cassandraReadQueryTenantCoreRateLimits == null ? 43 : $cassandraReadQueryTenantCoreRateLimits.hashCode());
        String $cassandraWriteQueryTenantCoreRateLimits = this.getCassandraWriteQueryTenantCoreRateLimits();
        result = result * 59 + ($cassandraWriteQueryTenantCoreRateLimits == null ? 43 : $cassandraWriteQueryTenantCoreRateLimits.hashCode());
        String $cassandraReadQueryTenantRuleEngineRateLimits = this.getCassandraReadQueryTenantRuleEngineRateLimits();
        result = result * 59 + ($cassandraReadQueryTenantRuleEngineRateLimits == null ? 43 : $cassandraReadQueryTenantRuleEngineRateLimits.hashCode());
        String $cassandraWriteQueryTenantRuleEngineRateLimits = this.getCassandraWriteQueryTenantRuleEngineRateLimits();
        result = result * 59 + ($cassandraWriteQueryTenantRuleEngineRateLimits == null ? 43 : $cassandraWriteQueryTenantRuleEngineRateLimits.hashCode());
        String $edgeEventRateLimits = this.getEdgeEventRateLimits();
        result = result * 59 + ($edgeEventRateLimits == null ? 43 : $edgeEventRateLimits.hashCode());
        String $edgeEventRateLimitsPerEdge = this.getEdgeEventRateLimitsPerEdge();
        result = result * 59 + ($edgeEventRateLimitsPerEdge == null ? 43 : $edgeEventRateLimitsPerEdge.hashCode());
        String $edgeUplinkMessagesRateLimits = this.getEdgeUplinkMessagesRateLimits();
        result = result * 59 + ($edgeUplinkMessagesRateLimits == null ? 43 : $edgeUplinkMessagesRateLimits.hashCode());
        String $edgeUplinkMessagesRateLimitsPerEdge = this.getEdgeUplinkMessagesRateLimitsPerEdge();
        result = result * 59 + ($edgeUplinkMessagesRateLimitsPerEdge == null ? 43 : $edgeUplinkMessagesRateLimitsPerEdge.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultTenantProfileConfiguration(maxDevices=" + this.getMaxDevices() + ", maxAssets=" + this.getMaxAssets() + ", maxCustomers=" + this.getMaxCustomers() + ", maxUsers=" + this.getMaxUsers() + ", maxDashboards=" + this.getMaxDashboards() + ", maxRuleChains=" + this.getMaxRuleChains() + ", maxEdges=" + this.getMaxEdges() + ", maxResourcesInBytes=" + this.getMaxResourcesInBytes() + ", maxOtaPackagesInBytes=" + this.getMaxOtaPackagesInBytes() + ", maxResourceSize=" + this.getMaxResourceSize() + ", maxReportSizeInBytes=" + this.getMaxReportSizeInBytes() + ", maxIntegrations=" + this.getMaxIntegrations() + ", maxConverters=" + this.getMaxConverters() + ", maxSchedulerEvents=" + this.getMaxSchedulerEvents() + ", transportTenantMsgRateLimit=" + this.getTransportTenantMsgRateLimit() + ", transportTenantTelemetryMsgRateLimit=" + this.getTransportTenantTelemetryMsgRateLimit() + ", transportTenantTelemetryDataPointsRateLimit=" + this.getTransportTenantTelemetryDataPointsRateLimit() + ", transportDeviceMsgRateLimit=" + this.getTransportDeviceMsgRateLimit() + ", transportDeviceTelemetryMsgRateLimit=" + this.getTransportDeviceTelemetryMsgRateLimit() + ", transportDeviceTelemetryDataPointsRateLimit=" + this.getTransportDeviceTelemetryDataPointsRateLimit() + ", transportGatewayMsgRateLimit=" + this.getTransportGatewayMsgRateLimit() + ", transportGatewayTelemetryMsgRateLimit=" + this.getTransportGatewayTelemetryMsgRateLimit() + ", transportGatewayTelemetryDataPointsRateLimit=" + this.getTransportGatewayTelemetryDataPointsRateLimit() + ", transportGatewayDeviceMsgRateLimit=" + this.getTransportGatewayDeviceMsgRateLimit() + ", transportGatewayDeviceTelemetryMsgRateLimit=" + this.getTransportGatewayDeviceTelemetryMsgRateLimit() + ", transportGatewayDeviceTelemetryDataPointsRateLimit=" + this.getTransportGatewayDeviceTelemetryDataPointsRateLimit() + ", integrationMsgsPerTenantRateLimit=" + this.getIntegrationMsgsPerTenantRateLimit() + ", integrationMsgsPerDeviceRateLimit=" + this.getIntegrationMsgsPerDeviceRateLimit() + ", integrationMsgsPerAssetRateLimit=" + this.getIntegrationMsgsPerAssetRateLimit() + ", tenantEntityExportRateLimit=" + this.getTenantEntityExportRateLimit() + ", tenantEntityImportRateLimit=" + this.getTenantEntityImportRateLimit() + ", tenantNotificationRequestsRateLimit=" + this.getTenantNotificationRequestsRateLimit() + ", tenantNotificationRequestsPerRuleRateLimit=" + this.getTenantNotificationRequestsPerRuleRateLimit() + ", maxTransportMessages=" + this.getMaxTransportMessages() + ", maxTransportDataPoints=" + this.getMaxTransportDataPoints() + ", maxREExecutions=" + this.getMaxREExecutions() + ", maxJSExecutions=" + this.getMaxJSExecutions() + ", maxTbelExecutions=" + this.getMaxTbelExecutions() + ", maxDPStorageDays=" + this.getMaxDPStorageDays() + ", maxRuleNodeExecutionsPerMessage=" + this.getMaxRuleNodeExecutionsPerMessage() + ", maxDebugModeDurationMinutes=" + this.getMaxDebugModeDurationMinutes() + ", maxEmails=" + this.getMaxEmails() + ", smsEnabled=" + this.getSmsEnabled() + ", maxSms=" + this.getMaxSms() + ", maxCreatedAlarms=" + this.getMaxCreatedAlarms() + ", maxGeneratedReports=" + this.getMaxGeneratedReports() + ", tenantServerRestLimitsConfiguration=" + this.getTenantServerRestLimitsConfiguration() + ", customerServerRestLimitsConfiguration=" + this.getCustomerServerRestLimitsConfiguration() + ", maxWsSessionsPerTenant=" + this.getMaxWsSessionsPerTenant() + ", maxWsSessionsPerCustomer=" + this.getMaxWsSessionsPerCustomer() + ", maxWsSessionsPerRegularUser=" + this.getMaxWsSessionsPerRegularUser() + ", maxWsSessionsPerPublicUser=" + this.getMaxWsSessionsPerPublicUser() + ", wsMsgQueueLimitPerSession=" + this.getWsMsgQueueLimitPerSession() + ", maxWsSubscriptionsPerTenant=" + this.getMaxWsSubscriptionsPerTenant() + ", maxWsSubscriptionsPerCustomer=" + this.getMaxWsSubscriptionsPerCustomer() + ", maxWsSubscriptionsPerRegularUser=" + this.getMaxWsSubscriptionsPerRegularUser() + ", maxWsSubscriptionsPerPublicUser=" + this.getMaxWsSubscriptionsPerPublicUser() + ", wsUpdatesPerSessionRateLimit=" + this.getWsUpdatesPerSessionRateLimit() + ", cassandraReadQueryTenantCoreRateLimits=" + this.getCassandraReadQueryTenantCoreRateLimits() + ", cassandraWriteQueryTenantCoreRateLimits=" + this.getCassandraWriteQueryTenantCoreRateLimits() + ", cassandraReadQueryTenantRuleEngineRateLimits=" + this.getCassandraReadQueryTenantRuleEngineRateLimits() + ", cassandraWriteQueryTenantRuleEngineRateLimits=" + this.getCassandraWriteQueryTenantRuleEngineRateLimits() + ", edgeEventRateLimits=" + this.getEdgeEventRateLimits() + ", edgeEventRateLimitsPerEdge=" + this.getEdgeEventRateLimitsPerEdge() + ", edgeUplinkMessagesRateLimits=" + this.getEdgeUplinkMessagesRateLimits() + ", edgeUplinkMessagesRateLimitsPerEdge=" + this.getEdgeUplinkMessagesRateLimitsPerEdge() + ", defaultStorageTtlDays=" + this.getDefaultStorageTtlDays() + ", alarmsTtlDays=" + this.getAlarmsTtlDays() + ", rpcTtlDays=" + this.getRpcTtlDays() + ", queueStatsTtlDays=" + this.getQueueStatsTtlDays() + ", ruleEngineExceptionsTtlDays=" + this.getRuleEngineExceptionsTtlDays() + ", blobEntityTtlDays=" + this.getBlobEntityTtlDays() + ", reportTtlDays=" + this.getReportTtlDays() + ", warnThreshold=" + this.getWarnThreshold() + ", maxCalculatedFieldsPerEntity=" + this.getMaxCalculatedFieldsPerEntity() + ", maxArgumentsPerCF=" + this.getMaxArgumentsPerCF() + ", maxDataPointsPerRollingArg=" + this.getMaxDataPointsPerRollingArg() + ", maxStateSizeInKBytes=" + this.getMaxStateSizeInKBytes() + ", maxSingleValueArgumentSizeInKBytes=" + this.getMaxSingleValueArgumentSizeInKBytes() + ")";
    }

    @Generated
    public static class DefaultTenantProfileConfigurationBuilder {
        @Generated
        private long maxDevices;
        @Generated
        private long maxAssets;
        @Generated
        private long maxCustomers;
        @Generated
        private long maxUsers;
        @Generated
        private long maxDashboards;
        @Generated
        private long maxRuleChains;
        @Generated
        private long maxEdges;
        @Generated
        private long maxResourcesInBytes;
        @Generated
        private long maxOtaPackagesInBytes;
        @Generated
        private long maxResourceSize;
        @Generated
        private long maxReportSizeInBytes;
        @Generated
        private long maxIntegrations;
        @Generated
        private long maxConverters;
        @Generated
        private long maxSchedulerEvents;
        @Generated
        private String transportTenantMsgRateLimit;
        @Generated
        private String transportTenantTelemetryMsgRateLimit;
        @Generated
        private String transportTenantTelemetryDataPointsRateLimit;
        @Generated
        private String transportDeviceMsgRateLimit;
        @Generated
        private String transportDeviceTelemetryMsgRateLimit;
        @Generated
        private String transportDeviceTelemetryDataPointsRateLimit;
        @Generated
        private String transportGatewayMsgRateLimit;
        @Generated
        private String transportGatewayTelemetryMsgRateLimit;
        @Generated
        private String transportGatewayTelemetryDataPointsRateLimit;
        @Generated
        private String transportGatewayDeviceMsgRateLimit;
        @Generated
        private String transportGatewayDeviceTelemetryMsgRateLimit;
        @Generated
        private String transportGatewayDeviceTelemetryDataPointsRateLimit;
        @Generated
        private String integrationMsgsPerTenantRateLimit;
        @Generated
        private String integrationMsgsPerDeviceRateLimit;
        @Generated
        private String integrationMsgsPerAssetRateLimit;
        @Generated
        private String tenantEntityExportRateLimit;
        @Generated
        private String tenantEntityImportRateLimit;
        @Generated
        private String tenantNotificationRequestsRateLimit;
        @Generated
        private String tenantNotificationRequestsPerRuleRateLimit;
        @Generated
        private long maxTransportMessages;
        @Generated
        private long maxTransportDataPoints;
        @Generated
        private long maxREExecutions;
        @Generated
        private long maxJSExecutions;
        @Generated
        private long maxTbelExecutions;
        @Generated
        private long maxDPStorageDays;
        @Generated
        private int maxRuleNodeExecutionsPerMessage;
        @Generated
        private int maxDebugModeDurationMinutes;
        @Generated
        private long maxEmails;
        @Generated
        private Boolean smsEnabled;
        @Generated
        private long maxSms;
        @Generated
        private long maxCreatedAlarms;
        @Generated
        private long maxGeneratedReports;
        @Generated
        private String tenantServerRestLimitsConfiguration;
        @Generated
        private String customerServerRestLimitsConfiguration;
        @Generated
        private int maxWsSessionsPerTenant;
        @Generated
        private int maxWsSessionsPerCustomer;
        @Generated
        private int maxWsSessionsPerRegularUser;
        @Generated
        private int maxWsSessionsPerPublicUser;
        @Generated
        private int wsMsgQueueLimitPerSession;
        @Generated
        private long maxWsSubscriptionsPerTenant;
        @Generated
        private long maxWsSubscriptionsPerCustomer;
        @Generated
        private long maxWsSubscriptionsPerRegularUser;
        @Generated
        private long maxWsSubscriptionsPerPublicUser;
        @Generated
        private String wsUpdatesPerSessionRateLimit;
        @Generated
        private String cassandraReadQueryTenantCoreRateLimits;
        @Generated
        private String cassandraWriteQueryTenantCoreRateLimits;
        @Generated
        private String cassandraReadQueryTenantRuleEngineRateLimits;
        @Generated
        private String cassandraWriteQueryTenantRuleEngineRateLimits;
        @Generated
        private String edgeEventRateLimits;
        @Generated
        private String edgeEventRateLimitsPerEdge;
        @Generated
        private String edgeUplinkMessagesRateLimits;
        @Generated
        private String edgeUplinkMessagesRateLimitsPerEdge;
        @Generated
        private int defaultStorageTtlDays;
        @Generated
        private int alarmsTtlDays;
        @Generated
        private int rpcTtlDays;
        @Generated
        private int queueStatsTtlDays;
        @Generated
        private int ruleEngineExceptionsTtlDays;
        @Generated
        private int blobEntityTtlDays;
        @Generated
        private int reportTtlDays;
        @Generated
        private double warnThreshold;
        @Generated
        private long maxCalculatedFieldsPerEntity;
        @Generated
        private long maxArgumentsPerCF;
        @Generated
        private boolean maxDataPointsPerRollingArg$set;
        @Generated
        private long maxDataPointsPerRollingArg$value;
        @Generated
        private long maxStateSizeInKBytes;
        @Generated
        private long maxSingleValueArgumentSizeInKBytes;

        @Generated
        DefaultTenantProfileConfigurationBuilder() {
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxDevices(long maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxAssets(long maxAssets) {
            this.maxAssets = maxAssets;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxCustomers(long maxCustomers) {
            this.maxCustomers = maxCustomers;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxUsers(long maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxDashboards(long maxDashboards) {
            this.maxDashboards = maxDashboards;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxRuleChains(long maxRuleChains) {
            this.maxRuleChains = maxRuleChains;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxEdges(long maxEdges) {
            this.maxEdges = maxEdges;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxResourcesInBytes(long maxResourcesInBytes) {
            this.maxResourcesInBytes = maxResourcesInBytes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
            this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxResourceSize(long maxResourceSize) {
            this.maxResourceSize = maxResourceSize;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxReportSizeInBytes(long maxReportSizeInBytes) {
            this.maxReportSizeInBytes = maxReportSizeInBytes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxIntegrations(long maxIntegrations) {
            this.maxIntegrations = maxIntegrations;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxConverters(long maxConverters) {
            this.maxConverters = maxConverters;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxSchedulerEvents(long maxSchedulerEvents) {
            this.maxSchedulerEvents = maxSchedulerEvents;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
            this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
            this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
            this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
            this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
            this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
            this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayMsgRateLimit(String transportGatewayMsgRateLimit) {
            this.transportGatewayMsgRateLimit = transportGatewayMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayTelemetryMsgRateLimit(String transportGatewayTelemetryMsgRateLimit) {
            this.transportGatewayTelemetryMsgRateLimit = transportGatewayTelemetryMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayTelemetryDataPointsRateLimit(String transportGatewayTelemetryDataPointsRateLimit) {
            this.transportGatewayTelemetryDataPointsRateLimit = transportGatewayTelemetryDataPointsRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayDeviceMsgRateLimit(String transportGatewayDeviceMsgRateLimit) {
            this.transportGatewayDeviceMsgRateLimit = transportGatewayDeviceMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayDeviceTelemetryMsgRateLimit(String transportGatewayDeviceTelemetryMsgRateLimit) {
            this.transportGatewayDeviceTelemetryMsgRateLimit = transportGatewayDeviceTelemetryMsgRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder transportGatewayDeviceTelemetryDataPointsRateLimit(String transportGatewayDeviceTelemetryDataPointsRateLimit) {
            this.transportGatewayDeviceTelemetryDataPointsRateLimit = transportGatewayDeviceTelemetryDataPointsRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder integrationMsgsPerTenantRateLimit(String integrationMsgsPerTenantRateLimit) {
            this.integrationMsgsPerTenantRateLimit = integrationMsgsPerTenantRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder integrationMsgsPerDeviceRateLimit(String integrationMsgsPerDeviceRateLimit) {
            this.integrationMsgsPerDeviceRateLimit = integrationMsgsPerDeviceRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder integrationMsgsPerAssetRateLimit(String integrationMsgsPerAssetRateLimit) {
            this.integrationMsgsPerAssetRateLimit = integrationMsgsPerAssetRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder tenantEntityExportRateLimit(String tenantEntityExportRateLimit) {
            this.tenantEntityExportRateLimit = tenantEntityExportRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder tenantEntityImportRateLimit(String tenantEntityImportRateLimit) {
            this.tenantEntityImportRateLimit = tenantEntityImportRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder tenantNotificationRequestsRateLimit(String tenantNotificationRequestsRateLimit) {
            this.tenantNotificationRequestsRateLimit = tenantNotificationRequestsRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder tenantNotificationRequestsPerRuleRateLimit(String tenantNotificationRequestsPerRuleRateLimit) {
            this.tenantNotificationRequestsPerRuleRateLimit = tenantNotificationRequestsPerRuleRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxTransportMessages(long maxTransportMessages) {
            this.maxTransportMessages = maxTransportMessages;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxTransportDataPoints(long maxTransportDataPoints) {
            this.maxTransportDataPoints = maxTransportDataPoints;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxREExecutions(long maxREExecutions) {
            this.maxREExecutions = maxREExecutions;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxJSExecutions(long maxJSExecutions) {
            this.maxJSExecutions = maxJSExecutions;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxTbelExecutions(long maxTbelExecutions) {
            this.maxTbelExecutions = maxTbelExecutions;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxDPStorageDays(long maxDPStorageDays) {
            this.maxDPStorageDays = maxDPStorageDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
            this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxDebugModeDurationMinutes(int maxDebugModeDurationMinutes) {
            this.maxDebugModeDurationMinutes = maxDebugModeDurationMinutes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxEmails(long maxEmails) {
            this.maxEmails = maxEmails;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder smsEnabled(Boolean smsEnabled) {
            this.smsEnabled = smsEnabled;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxSms(long maxSms) {
            this.maxSms = maxSms;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxCreatedAlarms(long maxCreatedAlarms) {
            this.maxCreatedAlarms = maxCreatedAlarms;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxGeneratedReports(long maxGeneratedReports) {
            this.maxGeneratedReports = maxGeneratedReports;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder tenantServerRestLimitsConfiguration(String tenantServerRestLimitsConfiguration) {
            this.tenantServerRestLimitsConfiguration = tenantServerRestLimitsConfiguration;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder customerServerRestLimitsConfiguration(String customerServerRestLimitsConfiguration) {
            this.customerServerRestLimitsConfiguration = customerServerRestLimitsConfiguration;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerTenant(int maxWsSessionsPerTenant) {
            this.maxWsSessionsPerTenant = maxWsSessionsPerTenant;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerCustomer(int maxWsSessionsPerCustomer) {
            this.maxWsSessionsPerCustomer = maxWsSessionsPerCustomer;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerRegularUser(int maxWsSessionsPerRegularUser) {
            this.maxWsSessionsPerRegularUser = maxWsSessionsPerRegularUser;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSessionsPerPublicUser(int maxWsSessionsPerPublicUser) {
            this.maxWsSessionsPerPublicUser = maxWsSessionsPerPublicUser;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder wsMsgQueueLimitPerSession(int wsMsgQueueLimitPerSession) {
            this.wsMsgQueueLimitPerSession = wsMsgQueueLimitPerSession;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerTenant(long maxWsSubscriptionsPerTenant) {
            this.maxWsSubscriptionsPerTenant = maxWsSubscriptionsPerTenant;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerCustomer(long maxWsSubscriptionsPerCustomer) {
            this.maxWsSubscriptionsPerCustomer = maxWsSubscriptionsPerCustomer;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerRegularUser(long maxWsSubscriptionsPerRegularUser) {
            this.maxWsSubscriptionsPerRegularUser = maxWsSubscriptionsPerRegularUser;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxWsSubscriptionsPerPublicUser(long maxWsSubscriptionsPerPublicUser) {
            this.maxWsSubscriptionsPerPublicUser = maxWsSubscriptionsPerPublicUser;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder wsUpdatesPerSessionRateLimit(String wsUpdatesPerSessionRateLimit) {
            this.wsUpdatesPerSessionRateLimit = wsUpdatesPerSessionRateLimit;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder cassandraReadQueryTenantCoreRateLimits(String cassandraReadQueryTenantCoreRateLimits) {
            this.cassandraReadQueryTenantCoreRateLimits = cassandraReadQueryTenantCoreRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder cassandraWriteQueryTenantCoreRateLimits(String cassandraWriteQueryTenantCoreRateLimits) {
            this.cassandraWriteQueryTenantCoreRateLimits = cassandraWriteQueryTenantCoreRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder cassandraReadQueryTenantRuleEngineRateLimits(String cassandraReadQueryTenantRuleEngineRateLimits) {
            this.cassandraReadQueryTenantRuleEngineRateLimits = cassandraReadQueryTenantRuleEngineRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder cassandraWriteQueryTenantRuleEngineRateLimits(String cassandraWriteQueryTenantRuleEngineRateLimits) {
            this.cassandraWriteQueryTenantRuleEngineRateLimits = cassandraWriteQueryTenantRuleEngineRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder edgeEventRateLimits(String edgeEventRateLimits) {
            this.edgeEventRateLimits = edgeEventRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder edgeEventRateLimitsPerEdge(String edgeEventRateLimitsPerEdge) {
            this.edgeEventRateLimitsPerEdge = edgeEventRateLimitsPerEdge;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder edgeUplinkMessagesRateLimits(String edgeUplinkMessagesRateLimits) {
            this.edgeUplinkMessagesRateLimits = edgeUplinkMessagesRateLimits;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder edgeUplinkMessagesRateLimitsPerEdge(String edgeUplinkMessagesRateLimitsPerEdge) {
            this.edgeUplinkMessagesRateLimitsPerEdge = edgeUplinkMessagesRateLimitsPerEdge;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder defaultStorageTtlDays(int defaultStorageTtlDays) {
            this.defaultStorageTtlDays = defaultStorageTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder alarmsTtlDays(int alarmsTtlDays) {
            this.alarmsTtlDays = alarmsTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder rpcTtlDays(int rpcTtlDays) {
            this.rpcTtlDays = rpcTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder queueStatsTtlDays(int queueStatsTtlDays) {
            this.queueStatsTtlDays = queueStatsTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder ruleEngineExceptionsTtlDays(int ruleEngineExceptionsTtlDays) {
            this.ruleEngineExceptionsTtlDays = ruleEngineExceptionsTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder blobEntityTtlDays(int blobEntityTtlDays) {
            this.blobEntityTtlDays = blobEntityTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder reportTtlDays(int reportTtlDays) {
            this.reportTtlDays = reportTtlDays;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder warnThreshold(double warnThreshold) {
            this.warnThreshold = warnThreshold;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxCalculatedFieldsPerEntity(long maxCalculatedFieldsPerEntity) {
            this.maxCalculatedFieldsPerEntity = maxCalculatedFieldsPerEntity;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxArgumentsPerCF(long maxArgumentsPerCF) {
            this.maxArgumentsPerCF = maxArgumentsPerCF;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxDataPointsPerRollingArg(long maxDataPointsPerRollingArg) {
            this.maxDataPointsPerRollingArg$value = maxDataPointsPerRollingArg;
            this.maxDataPointsPerRollingArg$set = true;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxStateSizeInKBytes(long maxStateSizeInKBytes) {
            this.maxStateSizeInKBytes = maxStateSizeInKBytes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfigurationBuilder maxSingleValueArgumentSizeInKBytes(long maxSingleValueArgumentSizeInKBytes) {
            this.maxSingleValueArgumentSizeInKBytes = maxSingleValueArgumentSizeInKBytes;
            return this;
        }

        @Generated
        public DefaultTenantProfileConfiguration build() {
            long maxDataPointsPerRollingArg$value = this.maxDataPointsPerRollingArg$value;
            if (!this.maxDataPointsPerRollingArg$set) {
                maxDataPointsPerRollingArg$value = DefaultTenantProfileConfiguration.$default$maxDataPointsPerRollingArg();
            }
            return new DefaultTenantProfileConfiguration(this.maxDevices, this.maxAssets, this.maxCustomers, this.maxUsers, this.maxDashboards, this.maxRuleChains, this.maxEdges, this.maxResourcesInBytes, this.maxOtaPackagesInBytes, this.maxResourceSize, this.maxReportSizeInBytes, this.maxIntegrations, this.maxConverters, this.maxSchedulerEvents, this.transportTenantMsgRateLimit, this.transportTenantTelemetryMsgRateLimit, this.transportTenantTelemetryDataPointsRateLimit, this.transportDeviceMsgRateLimit, this.transportDeviceTelemetryMsgRateLimit, this.transportDeviceTelemetryDataPointsRateLimit, this.transportGatewayMsgRateLimit, this.transportGatewayTelemetryMsgRateLimit, this.transportGatewayTelemetryDataPointsRateLimit, this.transportGatewayDeviceMsgRateLimit, this.transportGatewayDeviceTelemetryMsgRateLimit, this.transportGatewayDeviceTelemetryDataPointsRateLimit, this.integrationMsgsPerTenantRateLimit, this.integrationMsgsPerDeviceRateLimit, this.integrationMsgsPerAssetRateLimit, this.tenantEntityExportRateLimit, this.tenantEntityImportRateLimit, this.tenantNotificationRequestsRateLimit, this.tenantNotificationRequestsPerRuleRateLimit, this.maxTransportMessages, this.maxTransportDataPoints, this.maxREExecutions, this.maxJSExecutions, this.maxTbelExecutions, this.maxDPStorageDays, this.maxRuleNodeExecutionsPerMessage, this.maxDebugModeDurationMinutes, this.maxEmails, this.smsEnabled, this.maxSms, this.maxCreatedAlarms, this.maxGeneratedReports, this.tenantServerRestLimitsConfiguration, this.customerServerRestLimitsConfiguration, this.maxWsSessionsPerTenant, this.maxWsSessionsPerCustomer, this.maxWsSessionsPerRegularUser, this.maxWsSessionsPerPublicUser, this.wsMsgQueueLimitPerSession, this.maxWsSubscriptionsPerTenant, this.maxWsSubscriptionsPerCustomer, this.maxWsSubscriptionsPerRegularUser, this.maxWsSubscriptionsPerPublicUser, this.wsUpdatesPerSessionRateLimit, this.cassandraReadQueryTenantCoreRateLimits, this.cassandraWriteQueryTenantCoreRateLimits, this.cassandraReadQueryTenantRuleEngineRateLimits, this.cassandraWriteQueryTenantRuleEngineRateLimits, this.edgeEventRateLimits, this.edgeEventRateLimitsPerEdge, this.edgeUplinkMessagesRateLimits, this.edgeUplinkMessagesRateLimitsPerEdge, this.defaultStorageTtlDays, this.alarmsTtlDays, this.rpcTtlDays, this.queueStatsTtlDays, this.ruleEngineExceptionsTtlDays, this.blobEntityTtlDays, this.reportTtlDays, this.warnThreshold, this.maxCalculatedFieldsPerEntity, this.maxArgumentsPerCF, maxDataPointsPerRollingArg$value, this.maxStateSizeInKBytes, this.maxSingleValueArgumentSizeInKBytes);
        }

        @Generated
        public String toString() {
            return "DefaultTenantProfileConfiguration.DefaultTenantProfileConfigurationBuilder(maxDevices=" + this.maxDevices + ", maxAssets=" + this.maxAssets + ", maxCustomers=" + this.maxCustomers + ", maxUsers=" + this.maxUsers + ", maxDashboards=" + this.maxDashboards + ", maxRuleChains=" + this.maxRuleChains + ", maxEdges=" + this.maxEdges + ", maxResourcesInBytes=" + this.maxResourcesInBytes + ", maxOtaPackagesInBytes=" + this.maxOtaPackagesInBytes + ", maxResourceSize=" + this.maxResourceSize + ", maxReportSizeInBytes=" + this.maxReportSizeInBytes + ", maxIntegrations=" + this.maxIntegrations + ", maxConverters=" + this.maxConverters + ", maxSchedulerEvents=" + this.maxSchedulerEvents + ", transportTenantMsgRateLimit=" + this.transportTenantMsgRateLimit + ", transportTenantTelemetryMsgRateLimit=" + this.transportTenantTelemetryMsgRateLimit + ", transportTenantTelemetryDataPointsRateLimit=" + this.transportTenantTelemetryDataPointsRateLimit + ", transportDeviceMsgRateLimit=" + this.transportDeviceMsgRateLimit + ", transportDeviceTelemetryMsgRateLimit=" + this.transportDeviceTelemetryMsgRateLimit + ", transportDeviceTelemetryDataPointsRateLimit=" + this.transportDeviceTelemetryDataPointsRateLimit + ", transportGatewayMsgRateLimit=" + this.transportGatewayMsgRateLimit + ", transportGatewayTelemetryMsgRateLimit=" + this.transportGatewayTelemetryMsgRateLimit + ", transportGatewayTelemetryDataPointsRateLimit=" + this.transportGatewayTelemetryDataPointsRateLimit + ", transportGatewayDeviceMsgRateLimit=" + this.transportGatewayDeviceMsgRateLimit + ", transportGatewayDeviceTelemetryMsgRateLimit=" + this.transportGatewayDeviceTelemetryMsgRateLimit + ", transportGatewayDeviceTelemetryDataPointsRateLimit=" + this.transportGatewayDeviceTelemetryDataPointsRateLimit + ", integrationMsgsPerTenantRateLimit=" + this.integrationMsgsPerTenantRateLimit + ", integrationMsgsPerDeviceRateLimit=" + this.integrationMsgsPerDeviceRateLimit + ", integrationMsgsPerAssetRateLimit=" + this.integrationMsgsPerAssetRateLimit + ", tenantEntityExportRateLimit=" + this.tenantEntityExportRateLimit + ", tenantEntityImportRateLimit=" + this.tenantEntityImportRateLimit + ", tenantNotificationRequestsRateLimit=" + this.tenantNotificationRequestsRateLimit + ", tenantNotificationRequestsPerRuleRateLimit=" + this.tenantNotificationRequestsPerRuleRateLimit + ", maxTransportMessages=" + this.maxTransportMessages + ", maxTransportDataPoints=" + this.maxTransportDataPoints + ", maxREExecutions=" + this.maxREExecutions + ", maxJSExecutions=" + this.maxJSExecutions + ", maxTbelExecutions=" + this.maxTbelExecutions + ", maxDPStorageDays=" + this.maxDPStorageDays + ", maxRuleNodeExecutionsPerMessage=" + this.maxRuleNodeExecutionsPerMessage + ", maxDebugModeDurationMinutes=" + this.maxDebugModeDurationMinutes + ", maxEmails=" + this.maxEmails + ", smsEnabled=" + this.smsEnabled + ", maxSms=" + this.maxSms + ", maxCreatedAlarms=" + this.maxCreatedAlarms + ", maxGeneratedReports=" + this.maxGeneratedReports + ", tenantServerRestLimitsConfiguration=" + this.tenantServerRestLimitsConfiguration + ", customerServerRestLimitsConfiguration=" + this.customerServerRestLimitsConfiguration + ", maxWsSessionsPerTenant=" + this.maxWsSessionsPerTenant + ", maxWsSessionsPerCustomer=" + this.maxWsSessionsPerCustomer + ", maxWsSessionsPerRegularUser=" + this.maxWsSessionsPerRegularUser + ", maxWsSessionsPerPublicUser=" + this.maxWsSessionsPerPublicUser + ", wsMsgQueueLimitPerSession=" + this.wsMsgQueueLimitPerSession + ", maxWsSubscriptionsPerTenant=" + this.maxWsSubscriptionsPerTenant + ", maxWsSubscriptionsPerCustomer=" + this.maxWsSubscriptionsPerCustomer + ", maxWsSubscriptionsPerRegularUser=" + this.maxWsSubscriptionsPerRegularUser + ", maxWsSubscriptionsPerPublicUser=" + this.maxWsSubscriptionsPerPublicUser + ", wsUpdatesPerSessionRateLimit=" + this.wsUpdatesPerSessionRateLimit + ", cassandraReadQueryTenantCoreRateLimits=" + this.cassandraReadQueryTenantCoreRateLimits + ", cassandraWriteQueryTenantCoreRateLimits=" + this.cassandraWriteQueryTenantCoreRateLimits + ", cassandraReadQueryTenantRuleEngineRateLimits=" + this.cassandraReadQueryTenantRuleEngineRateLimits + ", cassandraWriteQueryTenantRuleEngineRateLimits=" + this.cassandraWriteQueryTenantRuleEngineRateLimits + ", edgeEventRateLimits=" + this.edgeEventRateLimits + ", edgeEventRateLimitsPerEdge=" + this.edgeEventRateLimitsPerEdge + ", edgeUplinkMessagesRateLimits=" + this.edgeUplinkMessagesRateLimits + ", edgeUplinkMessagesRateLimitsPerEdge=" + this.edgeUplinkMessagesRateLimitsPerEdge + ", defaultStorageTtlDays=" + this.defaultStorageTtlDays + ", alarmsTtlDays=" + this.alarmsTtlDays + ", rpcTtlDays=" + this.rpcTtlDays + ", queueStatsTtlDays=" + this.queueStatsTtlDays + ", ruleEngineExceptionsTtlDays=" + this.ruleEngineExceptionsTtlDays + ", blobEntityTtlDays=" + this.blobEntityTtlDays + ", reportTtlDays=" + this.reportTtlDays + ", warnThreshold=" + this.warnThreshold + ", maxCalculatedFieldsPerEntity=" + this.maxCalculatedFieldsPerEntity + ", maxArgumentsPerCF=" + this.maxArgumentsPerCF + ", maxDataPointsPerRollingArg$value=" + this.maxDataPointsPerRollingArg$value + ", maxStateSizeInKBytes=" + this.maxStateSizeInKBytes + ", maxSingleValueArgumentSizeInKBytes=" + this.maxSingleValueArgumentSizeInKBytes + ")";
        }
    }
}

