/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.ie;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.report.ReportConfig;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;

public class SchedulerEventExportData
extends EntityExportData<SchedulerEvent> {
    public static final ObjectMapper mapper = new ObjectMapper();

    public JsonNode prepareConfiguration(JsonNode configuration, String type, Function<EntityId, EntityId> idMapper, UserId userId) {
        return switch (type) {
            case "updateFirmware", "updateSoftware" -> {
                ObjectNode msgBody = configuration.withObject("msgBody");
                String oldId = msgBody.path("id").asText(null);
                if (oldId != null) {
                    OtaPackageId otaPackageId = new OtaPackageId(UUID.fromString(oldId));
                    msgBody.put("id", idMapper.apply(otaPackageId).getId().toString());
                }
                yield configuration;
            }
            case "generateDashboardReport" -> {
                ObjectNode reportConfig = configuration.withObject("msgBody").withObject("reportConfig");
                reportConfig.put("userId", userId.getId().toString());
                String oldId = reportConfig.path("dashboardId").asText(null);
                if (oldId != null) {
                    DashboardId dashboardId = new DashboardId(UUID.fromString(oldId));
                    reportConfig.put("dashboardId", idMapper.apply(dashboardId).getId().toString());
                }
                yield configuration;
            }
            case "generateReport" -> {
                ReportConfig reportConfig = (ReportConfig)mapper.treeToValue((TreeNode)configuration, ReportConfig.class);
                reportConfig.setUserId(userId);
                reportConfig.setReportTemplateId((ReportTemplateId)idMapper.apply(reportConfig.getReportTemplateId()));
                reportConfig.setTargets(null);
                reportConfig.setNotificationTemplateId(null);
                yield mapper.valueToTree((Object)reportConfig);
            }
            default -> configuration;
        };
    }

    @Generated
    public SchedulerEventExportData() {
    }

    @Override
    @Generated
    public String toString() {
        return "SchedulerEventExportData()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerEventExportData)) {
            return false;
        }
        SchedulerEventExportData other = (SchedulerEventExportData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchedulerEventExportData;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

