/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.ie;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.sync.JsonTbEntity;
import org.thingsboard.server.common.data.sync.ie.AttributeExportData;
import org.thingsboard.server.common.data.sync.ie.DeviceExportData;
import org.thingsboard.server.common.data.sync.ie.EntityGroupExportData;
import org.thingsboard.server.common.data.sync.ie.GroupEntityExportData;
import org.thingsboard.server.common.data.sync.ie.OtaPackageExportData;
import org.thingsboard.server.common.data.sync.ie.RuleChainExportData;
import org.thingsboard.server.common.data.sync.ie.SchedulerEventExportData;
import org.thingsboard.server.common.data.sync.ie.WidgetTypeExportData;
import org.thingsboard.server.common.data.sync.ie.WidgetsBundleExportData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="entityType", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, defaultImpl=EntityExportData.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="DEVICE", value=DeviceExportData.class), @JsonSubTypes.Type(name="RULE_CHAIN", value=RuleChainExportData.class), @JsonSubTypes.Type(name="WIDGET_TYPE", value=WidgetTypeExportData.class), @JsonSubTypes.Type(name="WIDGETS_BUNDLE", value=WidgetsBundleExportData.class), @JsonSubTypes.Type(name="OTA_PACKAGE", value=OtaPackageExportData.class), @JsonSubTypes.Type(name="ENTITY_GROUP", value=EntityGroupExportData.class), @JsonSubTypes.Type(name="ASSET", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="DASHBOARD", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="CUSTOMER", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="ENTITY_VIEW", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="SCHEDULER_EVENT", value=SchedulerEventExportData.class)})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityExportData<E extends ExportableEntity<? extends EntityId>> {
    public static final Comparator<EntityRelation> relationsComparator = Comparator.comparing(EntityRelation::getFrom, Comparator.comparing(EntityId::getId)).thenComparing(EntityRelation::getTo, Comparator.comparing(EntityId::getId)).thenComparing(EntityRelation::getTypeGroup).thenComparing(EntityRelation::getType);
    public static final Comparator<AttributeExportData> attrComparator = Comparator.comparing(AttributeExportData::getKey).thenComparing(AttributeExportData::getLastUpdateTs);
    public static final Comparator<CalculatedField> calculatedFieldsComparator = Comparator.comparing(CalculatedField::getName);
    @JsonProperty(index=2)
    @JsonTbEntity
    private E entity;
    @JsonProperty(index=1)
    private EntityType entityType;
    @JsonProperty(index=100)
    private List<EntityRelation> relations;
    @JsonProperty(index=101)
    private Map<String, List<AttributeExportData>> attributes;
    @JsonProperty(index=102)
    @JsonIgnoreProperties(value={"id", "entityId", "createdTime", "version"})
    private List<CalculatedField> calculatedFields;

    public EntityExportData<E> sort() {
        if (this.relations != null && !this.relations.isEmpty()) {
            this.relations.sort(relationsComparator);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            this.attributes.values().forEach(list -> list.sort(attrComparator));
        }
        if (this.calculatedFields != null && !this.calculatedFields.isEmpty()) {
            this.calculatedFields.sort(calculatedFieldsComparator);
        }
        return this;
    }

    @JsonIgnore
    public EntityId getExternalId() {
        return this.entity.getExternalId() != null ? this.entity.getExternalId() : (EntityId)this.entity.getId();
    }

    @JsonIgnore
    public boolean hasCredentials() {
        return false;
    }

    @JsonIgnore
    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @JsonIgnore
    public boolean hasRelations() {
        return this.relations != null;
    }

    @JsonIgnore
    public boolean hasCalculatedFields() {
        return this.calculatedFields != null && !this.calculatedFields.isEmpty();
    }

    @JsonIgnore
    public boolean hasPermissions() {
        return false;
    }

    @JsonIgnore
    public boolean hasGroupEntities() {
        return false;
    }

    @Generated
    public EntityExportData() {
    }

    @Generated
    public E getEntity() {
        return this.entity;
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public List<EntityRelation> getRelations() {
        return this.relations;
    }

    @Generated
    public Map<String, List<AttributeExportData>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<CalculatedField> getCalculatedFields() {
        return this.calculatedFields;
    }

    @JsonProperty(index=2)
    @Generated
    public void setEntity(E entity) {
        this.entity = entity;
    }

    @JsonProperty(index=1)
    @Generated
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(index=100)
    @Generated
    public void setRelations(List<EntityRelation> relations) {
        this.relations = relations;
    }

    @JsonProperty(index=101)
    @Generated
    public void setAttributes(Map<String, List<AttributeExportData>> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(index=102)
    @JsonIgnoreProperties(value={"id", "entityId", "createdTime", "version"})
    @Generated
    public void setCalculatedFields(List<CalculatedField> calculatedFields) {
        this.calculatedFields = calculatedFields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityExportData)) {
            return false;
        }
        EntityExportData other = (EntityExportData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        E this$entity = this.getEntity();
        E other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        List<EntityRelation> this$relations = this.getRelations();
        List<EntityRelation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        Map<String, List<AttributeExportData>> this$attributes = this.getAttributes();
        Map<String, List<AttributeExportData>> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<CalculatedField> this$calculatedFields = this.getCalculatedFields();
        List<CalculatedField> other$calculatedFields = other.getCalculatedFields();
        return !(this$calculatedFields == null ? other$calculatedFields != null : !((Object)this$calculatedFields).equals(other$calculatedFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityExportData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        List<EntityRelation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        Map<String, List<AttributeExportData>> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<CalculatedField> $calculatedFields = this.getCalculatedFields();
        result = result * 59 + ($calculatedFields == null ? 43 : ((Object)$calculatedFields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityExportData(entity=" + String.valueOf(this.getEntity()) + ", entityType=" + String.valueOf((Object)this.getEntityType()) + ", relations=" + String.valueOf(this.getRelations()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", calculatedFields=" + String.valueOf(this.getCalculatedFields()) + ")";
    }
}

