/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sms.config;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.sms.config.SmsProviderConfiguration;
import org.thingsboard.server.common.data.sms.config.SmsProviderType;

public class SmppSmsProviderConfiguration
implements SmsProviderConfiguration {
    @Schema(description="SMPP version", allowableValues={"3.3, 3.4"}, requiredMode=Schema.RequiredMode.REQUIRED)
    private String protocolVersion;
    @Schema(description="SMPP host", requiredMode=Schema.RequiredMode.REQUIRED)
    private String host;
    @Schema(description="SMPP port", requiredMode=Schema.RequiredMode.REQUIRED)
    private Integer port;
    @Schema(description="System ID", requiredMode=Schema.RequiredMode.REQUIRED)
    private String systemId;
    @Schema(description="Password", requiredMode=Schema.RequiredMode.REQUIRED)
    private String password;
    @Schema(description="System type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String systemType;
    @Schema(description="TX - Transmitter, RX - Receiver, TRX - Transciever. By default TX is used", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private SmppBindType bindType;
    @Schema(description="Service type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String serviceType;
    @Schema(description="Source address", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String sourceAddress;
    @Schema(description="Source TON (Type of Number). Needed is source address is set. 5 by default.\n0 - Unknown\n1 - International\n2 - National\n3 - Network Specific\n4 - Subscriber Number\n5 - Alphanumeric\n6 - Abbreviated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Byte sourceTon;
    @Schema(description="Source NPI (Numbering Plan Identification). Needed is source address is set. 0 by default.\n0 - Unknown\n1 - ISDN/telephone numbering plan (E163/E164)\n3 - Data numbering plan (X.121)\n4 - Telex numbering plan (F.69)\n6 - Land Mobile (E.212) =6\n8 - National numbering plan\n9 - Private numbering plan\n10 - ERMES numbering plan (ETSI DE/PS 3 01-3)\n13 - Internet (IP)\n18 - WAP Client Id (to be defined by WAP Forum)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Byte sourceNpi;
    @Schema(description="Destination TON (Type of Number). 5 by default.\n0 - Unknown\n1 - International\n2 - National\n3 - Network Specific\n4 - Subscriber Number\n5 - Alphanumeric\n6 - Abbreviated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Byte destinationTon;
    @Schema(description="Destination NPI (Numbering Plan Identification). 0 by default.\n0 - Unknown\n1 - ISDN/telephone numbering plan (E163/E164)\n3 - Data numbering plan (X.121)\n4 - Telex numbering plan (F.69)\n6 - Land Mobile (E.212) =6\n8 - National numbering plan\n9 - Private numbering plan\n10 - ERMES numbering plan (ETSI DE/PS 3 01-3)\n13 - Internet (IP)\n18 - WAP Client Id (to be defined by WAP Forum)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Byte destinationNpi;
    @Schema(description="Address range", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String addressRange;
    @Schema(allowableValues={"0-10", "13-14"}, description="0 - SMSC Default Alphabet (ASCII for short and long code and to GSM for toll-free, used as default)\n1 - IA5 (ASCII for short and long code, Latin 9 for toll-free (ISO-8859-9))\n2 - Octet Unspecified (8-bit binary)\n3 - Latin 1 (ISO-8859-1)\n4 - Octet Unspecified (8-bit binary)\n5 - JIS (X 0208-1990)\n6 - Cyrillic (ISO-8859-5)\n7 - Latin/Hebrew (ISO-8859-8)\n8 - UCS2/UTF-16 (ISO/IEC-10646)\n9 - Pictogram Encoding\n10 - Music Codes (ISO-2022-JP)\n13 - Extended Kanji JIS (X 0212-1990)\n14 - Korean Graphic Character Set (KS C 5601/KS X 1001)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private Byte codingScheme;

    @Override
    public SmsProviderType getType() {
        return SmsProviderType.SMPP;
    }

    @Generated
    public SmppSmsProviderConfiguration() {
    }

    @Generated
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getSystemId() {
        return this.systemId;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSystemType() {
        return this.systemType;
    }

    @Generated
    public SmppBindType getBindType() {
        return this.bindType;
    }

    @Generated
    public String getServiceType() {
        return this.serviceType;
    }

    @Generated
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    @Generated
    public Byte getSourceTon() {
        return this.sourceTon;
    }

    @Generated
    public Byte getSourceNpi() {
        return this.sourceNpi;
    }

    @Generated
    public Byte getDestinationTon() {
        return this.destinationTon;
    }

    @Generated
    public Byte getDestinationNpi() {
        return this.destinationNpi;
    }

    @Generated
    public String getAddressRange() {
        return this.addressRange;
    }

    @Generated
    public Byte getCodingScheme() {
        return this.codingScheme;
    }

    @Generated
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    @Generated
    public void setBindType(SmppBindType bindType) {
        this.bindType = bindType;
    }

    @Generated
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    @Generated
    public void setSourceTon(Byte sourceTon) {
        this.sourceTon = sourceTon;
    }

    @Generated
    public void setSourceNpi(Byte sourceNpi) {
        this.sourceNpi = sourceNpi;
    }

    @Generated
    public void setDestinationTon(Byte destinationTon) {
        this.destinationTon = destinationTon;
    }

    @Generated
    public void setDestinationNpi(Byte destinationNpi) {
        this.destinationNpi = destinationNpi;
    }

    @Generated
    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    @Generated
    public void setCodingScheme(Byte codingScheme) {
        this.codingScheme = codingScheme;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmppSmsProviderConfiguration)) {
            return false;
        }
        SmppSmsProviderConfiguration other = (SmppSmsProviderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Byte this$sourceTon = this.getSourceTon();
        Byte other$sourceTon = other.getSourceTon();
        if (this$sourceTon == null ? other$sourceTon != null : !((Object)this$sourceTon).equals(other$sourceTon)) {
            return false;
        }
        Byte this$sourceNpi = this.getSourceNpi();
        Byte other$sourceNpi = other.getSourceNpi();
        if (this$sourceNpi == null ? other$sourceNpi != null : !((Object)this$sourceNpi).equals(other$sourceNpi)) {
            return false;
        }
        Byte this$destinationTon = this.getDestinationTon();
        Byte other$destinationTon = other.getDestinationTon();
        if (this$destinationTon == null ? other$destinationTon != null : !((Object)this$destinationTon).equals(other$destinationTon)) {
            return false;
        }
        Byte this$destinationNpi = this.getDestinationNpi();
        Byte other$destinationNpi = other.getDestinationNpi();
        if (this$destinationNpi == null ? other$destinationNpi != null : !((Object)this$destinationNpi).equals(other$destinationNpi)) {
            return false;
        }
        Byte this$codingScheme = this.getCodingScheme();
        Byte other$codingScheme = other.getCodingScheme();
        if (this$codingScheme == null ? other$codingScheme != null : !((Object)this$codingScheme).equals(other$codingScheme)) {
            return false;
        }
        String this$protocolVersion = this.getProtocolVersion();
        String other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$systemType = this.getSystemType();
        String other$systemType = other.getSystemType();
        if (this$systemType == null ? other$systemType != null : !this$systemType.equals(other$systemType)) {
            return false;
        }
        SmppBindType this$bindType = this.getBindType();
        SmppBindType other$bindType = other.getBindType();
        if (this$bindType == null ? other$bindType != null : !((Object)((Object)this$bindType)).equals((Object)other$bindType)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) {
            return false;
        }
        String this$sourceAddress = this.getSourceAddress();
        String other$sourceAddress = other.getSourceAddress();
        if (this$sourceAddress == null ? other$sourceAddress != null : !this$sourceAddress.equals(other$sourceAddress)) {
            return false;
        }
        String this$addressRange = this.getAddressRange();
        String other$addressRange = other.getAddressRange();
        return !(this$addressRange == null ? other$addressRange != null : !this$addressRange.equals(other$addressRange));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SmppSmsProviderConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Byte $sourceTon = this.getSourceTon();
        result = result * 59 + ($sourceTon == null ? 43 : ((Object)$sourceTon).hashCode());
        Byte $sourceNpi = this.getSourceNpi();
        result = result * 59 + ($sourceNpi == null ? 43 : ((Object)$sourceNpi).hashCode());
        Byte $destinationTon = this.getDestinationTon();
        result = result * 59 + ($destinationTon == null ? 43 : ((Object)$destinationTon).hashCode());
        Byte $destinationNpi = this.getDestinationNpi();
        result = result * 59 + ($destinationNpi == null ? 43 : ((Object)$destinationNpi).hashCode());
        Byte $codingScheme = this.getCodingScheme();
        result = result * 59 + ($codingScheme == null ? 43 : ((Object)$codingScheme).hashCode());
        String $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $systemType = this.getSystemType();
        result = result * 59 + ($systemType == null ? 43 : $systemType.hashCode());
        SmppBindType $bindType = this.getBindType();
        result = result * 59 + ($bindType == null ? 43 : ((Object)((Object)$bindType)).hashCode());
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        String $sourceAddress = this.getSourceAddress();
        result = result * 59 + ($sourceAddress == null ? 43 : $sourceAddress.hashCode());
        String $addressRange = this.getAddressRange();
        result = result * 59 + ($addressRange == null ? 43 : $addressRange.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SmppSmsProviderConfiguration(protocolVersion=" + this.getProtocolVersion() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", systemId=" + this.getSystemId() + ", password=" + this.getPassword() + ", systemType=" + this.getSystemType() + ", bindType=" + String.valueOf((Object)this.getBindType()) + ", serviceType=" + this.getServiceType() + ", sourceAddress=" + this.getSourceAddress() + ", sourceTon=" + this.getSourceTon() + ", sourceNpi=" + this.getSourceNpi() + ", destinationTon=" + this.getDestinationTon() + ", destinationNpi=" + this.getDestinationNpi() + ", addressRange=" + this.getAddressRange() + ", codingScheme=" + this.getCodingScheme() + ")";
    }

    public static enum SmppBindType {
        TX,
        RX,
        TRX;

    }
}

