/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.selfregistration;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.selfregistration.CaptchaParams;
import org.thingsboard.server.common.data.selfregistration.DefaultDashboardParams;
import org.thingsboard.server.common.data.selfregistration.HomeDashboardParams;
import org.thingsboard.server.common.data.selfregistration.SelfRegistrationParams;
import org.thingsboard.server.common.data.selfregistration.SignUpField;
import org.thingsboard.server.common.data.selfregistration.SignUpSelfRegistrationParams;

public abstract class AbstractSelfRegistrationParams
implements SelfRegistrationParams {
    @Schema(description="Indicates if self-registration is allowed via sign-up form")
    protected Boolean enabled;
    @Schema(description="The text message to appear on login form")
    @NotNull
    protected String title;
    @Schema(description="Captcha site key for 'I'm not a robot' validation")
    @NotNull
    protected CaptchaParams captcha;
    @Schema(description="List of sign-up form fields")
    @NotNull
    protected List<SignUpField> signUpFields;
    @Schema(description="Show or hide 'Privacy Policy'")
    protected Boolean showPrivacyPolicy;
    @Schema(description="Show or hide 'Terms of Use'")
    protected Boolean showTermsOfUse;
    @Schema(description="Recipient to use for notifications when new user self-registered.")
    protected NotificationTargetId notificationRecipient;
    @Schema(description="Prefix to add to created customer")
    protected String customerTitlePrefix;
    @Schema(description="Id of the customer group customer wil be added to.")
    protected EntityGroupId customerGroupId;
    @Schema(description="Group Permissions to assign for the new customer user.")
    @NotNull
    protected List<GroupPermission> permissions;
    @Schema(description="Default dashboard params")
    protected DefaultDashboardParams defaultDashboard;
    @Schema(description="Home dashboard params")
    protected HomeDashboardParams homeDashboard;
    @Schema(description="Custom menu id")
    protected CustomMenuId customMenuId;
    @Schema(description="Privacy policy text. Supports HTML.")
    protected String privacyPolicy;
    @Schema(description="Terms of User text. Supports HTML.")
    protected String termsOfUse;

    @Override
    public SignUpSelfRegistrationParams toSignUpSelfRegistrationParams(PlatformType platformType) {
        return this.enabled != false ? new SignUpSelfRegistrationParams(this.title, this.captcha.toInfo(platformType), this.signUpFields, this.showPrivacyPolicy, this.showTermsOfUse) : null;
    }

    @Generated
    public AbstractSelfRegistrationParams() {
    }

    @Override
    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Override
    @Generated
    public CaptchaParams getCaptcha() {
        return this.captcha;
    }

    @Override
    @Generated
    public List<SignUpField> getSignUpFields() {
        return this.signUpFields;
    }

    @Override
    @Generated
    public Boolean getShowPrivacyPolicy() {
        return this.showPrivacyPolicy;
    }

    @Override
    @Generated
    public Boolean getShowTermsOfUse() {
        return this.showTermsOfUse;
    }

    @Override
    @Generated
    public NotificationTargetId getNotificationRecipient() {
        return this.notificationRecipient;
    }

    @Override
    @Generated
    public String getCustomerTitlePrefix() {
        return this.customerTitlePrefix;
    }

    @Override
    @Generated
    public EntityGroupId getCustomerGroupId() {
        return this.customerGroupId;
    }

    @Override
    @Generated
    public List<GroupPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Generated
    public DefaultDashboardParams getDefaultDashboard() {
        return this.defaultDashboard;
    }

    @Override
    @Generated
    public HomeDashboardParams getHomeDashboard() {
        return this.homeDashboard;
    }

    @Override
    @Generated
    public CustomMenuId getCustomMenuId() {
        return this.customMenuId;
    }

    @Generated
    public String getPrivacyPolicy() {
        return this.privacyPolicy;
    }

    @Generated
    public String getTermsOfUse() {
        return this.termsOfUse;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCaptcha(CaptchaParams captcha) {
        this.captcha = captcha;
    }

    @Generated
    public void setSignUpFields(List<SignUpField> signUpFields) {
        this.signUpFields = signUpFields;
    }

    @Generated
    public void setShowPrivacyPolicy(Boolean showPrivacyPolicy) {
        this.showPrivacyPolicy = showPrivacyPolicy;
    }

    @Generated
    public void setShowTermsOfUse(Boolean showTermsOfUse) {
        this.showTermsOfUse = showTermsOfUse;
    }

    @Generated
    public void setNotificationRecipient(NotificationTargetId notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
    }

    @Generated
    public void setCustomerTitlePrefix(String customerTitlePrefix) {
        this.customerTitlePrefix = customerTitlePrefix;
    }

    @Generated
    public void setCustomerGroupId(EntityGroupId customerGroupId) {
        this.customerGroupId = customerGroupId;
    }

    @Generated
    public void setPermissions(List<GroupPermission> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public void setDefaultDashboard(DefaultDashboardParams defaultDashboard) {
        this.defaultDashboard = defaultDashboard;
    }

    @Generated
    public void setHomeDashboard(HomeDashboardParams homeDashboard) {
        this.homeDashboard = homeDashboard;
    }

    @Generated
    public void setCustomMenuId(CustomMenuId customMenuId) {
        this.customMenuId = customMenuId;
    }

    @Generated
    public void setPrivacyPolicy(String privacyPolicy) {
        this.privacyPolicy = privacyPolicy;
    }

    @Generated
    public void setTermsOfUse(String termsOfUse) {
        this.termsOfUse = termsOfUse;
    }

    @Generated
    public String toString() {
        return "AbstractSelfRegistrationParams(enabled=" + this.getEnabled() + ", title=" + this.getTitle() + ", captcha=" + String.valueOf(this.getCaptcha()) + ", signUpFields=" + String.valueOf(this.getSignUpFields()) + ", showPrivacyPolicy=" + this.getShowPrivacyPolicy() + ", showTermsOfUse=" + this.getShowTermsOfUse() + ", notificationRecipient=" + String.valueOf(this.getNotificationRecipient()) + ", customerTitlePrefix=" + this.getCustomerTitlePrefix() + ", customerGroupId=" + String.valueOf(this.getCustomerGroupId()) + ", permissions=" + String.valueOf(this.getPermissions()) + ", defaultDashboard=" + String.valueOf(this.getDefaultDashboard()) + ", homeDashboard=" + String.valueOf(this.getHomeDashboard()) + ", customMenuId=" + String.valueOf(this.getCustomMenuId()) + ", privacyPolicy=" + this.getPrivacyPolicy() + ", termsOfUse=" + this.getTermsOfUse() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSelfRegistrationParams)) {
            return false;
        }
        AbstractSelfRegistrationParams other = (AbstractSelfRegistrationParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$showPrivacyPolicy = this.getShowPrivacyPolicy();
        Boolean other$showPrivacyPolicy = other.getShowPrivacyPolicy();
        if (this$showPrivacyPolicy == null ? other$showPrivacyPolicy != null : !((Object)this$showPrivacyPolicy).equals(other$showPrivacyPolicy)) {
            return false;
        }
        Boolean this$showTermsOfUse = this.getShowTermsOfUse();
        Boolean other$showTermsOfUse = other.getShowTermsOfUse();
        if (this$showTermsOfUse == null ? other$showTermsOfUse != null : !((Object)this$showTermsOfUse).equals(other$showTermsOfUse)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        CaptchaParams this$captcha = this.getCaptcha();
        CaptchaParams other$captcha = other.getCaptcha();
        if (this$captcha == null ? other$captcha != null : !this$captcha.equals(other$captcha)) {
            return false;
        }
        List<SignUpField> this$signUpFields = this.getSignUpFields();
        List<SignUpField> other$signUpFields = other.getSignUpFields();
        if (this$signUpFields == null ? other$signUpFields != null : !((Object)this$signUpFields).equals(other$signUpFields)) {
            return false;
        }
        NotificationTargetId this$notificationRecipient = this.getNotificationRecipient();
        NotificationTargetId other$notificationRecipient = other.getNotificationRecipient();
        if (this$notificationRecipient == null ? other$notificationRecipient != null : !((Object)this$notificationRecipient).equals(other$notificationRecipient)) {
            return false;
        }
        String this$customerTitlePrefix = this.getCustomerTitlePrefix();
        String other$customerTitlePrefix = other.getCustomerTitlePrefix();
        if (this$customerTitlePrefix == null ? other$customerTitlePrefix != null : !this$customerTitlePrefix.equals(other$customerTitlePrefix)) {
            return false;
        }
        EntityGroupId this$customerGroupId = this.getCustomerGroupId();
        EntityGroupId other$customerGroupId = other.getCustomerGroupId();
        if (this$customerGroupId == null ? other$customerGroupId != null : !((Object)this$customerGroupId).equals(other$customerGroupId)) {
            return false;
        }
        List<GroupPermission> this$permissions = this.getPermissions();
        List<GroupPermission> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        DefaultDashboardParams this$defaultDashboard = this.getDefaultDashboard();
        DefaultDashboardParams other$defaultDashboard = other.getDefaultDashboard();
        if (this$defaultDashboard == null ? other$defaultDashboard != null : !((Object)this$defaultDashboard).equals(other$defaultDashboard)) {
            return false;
        }
        HomeDashboardParams this$homeDashboard = this.getHomeDashboard();
        HomeDashboardParams other$homeDashboard = other.getHomeDashboard();
        if (this$homeDashboard == null ? other$homeDashboard != null : !((Object)this$homeDashboard).equals(other$homeDashboard)) {
            return false;
        }
        CustomMenuId this$customMenuId = this.getCustomMenuId();
        CustomMenuId other$customMenuId = other.getCustomMenuId();
        if (this$customMenuId == null ? other$customMenuId != null : !((Object)this$customMenuId).equals(other$customMenuId)) {
            return false;
        }
        String this$privacyPolicy = this.getPrivacyPolicy();
        String other$privacyPolicy = other.getPrivacyPolicy();
        if (this$privacyPolicy == null ? other$privacyPolicy != null : !this$privacyPolicy.equals(other$privacyPolicy)) {
            return false;
        }
        String this$termsOfUse = this.getTermsOfUse();
        String other$termsOfUse = other.getTermsOfUse();
        return !(this$termsOfUse == null ? other$termsOfUse != null : !this$termsOfUse.equals(other$termsOfUse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractSelfRegistrationParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $showPrivacyPolicy = this.getShowPrivacyPolicy();
        result = result * 59 + ($showPrivacyPolicy == null ? 43 : ((Object)$showPrivacyPolicy).hashCode());
        Boolean $showTermsOfUse = this.getShowTermsOfUse();
        result = result * 59 + ($showTermsOfUse == null ? 43 : ((Object)$showTermsOfUse).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        CaptchaParams $captcha = this.getCaptcha();
        result = result * 59 + ($captcha == null ? 43 : $captcha.hashCode());
        List<SignUpField> $signUpFields = this.getSignUpFields();
        result = result * 59 + ($signUpFields == null ? 43 : ((Object)$signUpFields).hashCode());
        NotificationTargetId $notificationRecipient = this.getNotificationRecipient();
        result = result * 59 + ($notificationRecipient == null ? 43 : ((Object)$notificationRecipient).hashCode());
        String $customerTitlePrefix = this.getCustomerTitlePrefix();
        result = result * 59 + ($customerTitlePrefix == null ? 43 : $customerTitlePrefix.hashCode());
        EntityGroupId $customerGroupId = this.getCustomerGroupId();
        result = result * 59 + ($customerGroupId == null ? 43 : ((Object)$customerGroupId).hashCode());
        List<GroupPermission> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        DefaultDashboardParams $defaultDashboard = this.getDefaultDashboard();
        result = result * 59 + ($defaultDashboard == null ? 43 : ((Object)$defaultDashboard).hashCode());
        HomeDashboardParams $homeDashboard = this.getHomeDashboard();
        result = result * 59 + ($homeDashboard == null ? 43 : ((Object)$homeDashboard).hashCode());
        CustomMenuId $customMenuId = this.getCustomMenuId();
        result = result * 59 + ($customMenuId == null ? 43 : ((Object)$customMenuId).hashCode());
        String $privacyPolicy = this.getPrivacyPolicy();
        result = result * 59 + ($privacyPolicy == null ? 43 : $privacyPolicy.hashCode());
        String $termsOfUse = this.getTermsOfUse();
        result = result * 59 + ($termsOfUse == null ? 43 : $termsOfUse.hashCode());
        return result;
    }
}

