/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security.model;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import lombok.Generated;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;

@Schema
public class SecuritySettings
implements Serializable {
    private static final long serialVersionUID = -1307613974597312465L;
    @Schema(description="The user password policy object.")
    private UserPasswordPolicy passwordPolicy;
    @Schema(description="Maximum number of failed login attempts allowed before user account is locked.")
    private Integer maxFailedLoginAttempts;
    @Schema(description="Email to use for notifications about locked users.")
    private String userLockoutNotificationEmail;
    @Schema(description="Mobile secret key length")
    private Integer mobileSecretKeyLength;
    @NotNull
    @Min(value=1L)
    @Max(value=24L)
    @Schema(description="TTL in hours for user activation link", minimum="1", maximum="24", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull @Min(value=1L) @Max(value=24L) Integer userActivationTokenTtl;
    @NotNull
    @Min(value=1L)
    @Max(value=24L)
    @Schema(description="TTL in hours for password reset link", minimum="1", maximum="24", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull @Min(value=1L) @Max(value=24L) Integer passwordResetTokenTtl;

    @Generated
    public SecuritySettings() {
    }

    @Generated
    public UserPasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    @Generated
    public Integer getMaxFailedLoginAttempts() {
        return this.maxFailedLoginAttempts;
    }

    @Generated
    public String getUserLockoutNotificationEmail() {
        return this.userLockoutNotificationEmail;
    }

    @Generated
    public Integer getMobileSecretKeyLength() {
        return this.mobileSecretKeyLength;
    }

    @Generated
    public Integer getUserActivationTokenTtl() {
        return this.userActivationTokenTtl;
    }

    @Generated
    public Integer getPasswordResetTokenTtl() {
        return this.passwordResetTokenTtl;
    }

    @Generated
    public void setPasswordPolicy(UserPasswordPolicy passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    @Generated
    public void setMaxFailedLoginAttempts(Integer maxFailedLoginAttempts) {
        this.maxFailedLoginAttempts = maxFailedLoginAttempts;
    }

    @Generated
    public void setUserLockoutNotificationEmail(String userLockoutNotificationEmail) {
        this.userLockoutNotificationEmail = userLockoutNotificationEmail;
    }

    @Generated
    public void setMobileSecretKeyLength(Integer mobileSecretKeyLength) {
        this.mobileSecretKeyLength = mobileSecretKeyLength;
    }

    @Generated
    public void setUserActivationTokenTtl(Integer userActivationTokenTtl) {
        this.userActivationTokenTtl = userActivationTokenTtl;
    }

    @Generated
    public void setPasswordResetTokenTtl(Integer passwordResetTokenTtl) {
        this.passwordResetTokenTtl = passwordResetTokenTtl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecuritySettings)) {
            return false;
        }
        SecuritySettings other = (SecuritySettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxFailedLoginAttempts = this.getMaxFailedLoginAttempts();
        Integer other$maxFailedLoginAttempts = other.getMaxFailedLoginAttempts();
        if (this$maxFailedLoginAttempts == null ? other$maxFailedLoginAttempts != null : !((Object)this$maxFailedLoginAttempts).equals(other$maxFailedLoginAttempts)) {
            return false;
        }
        Integer this$mobileSecretKeyLength = this.getMobileSecretKeyLength();
        Integer other$mobileSecretKeyLength = other.getMobileSecretKeyLength();
        if (this$mobileSecretKeyLength == null ? other$mobileSecretKeyLength != null : !((Object)this$mobileSecretKeyLength).equals(other$mobileSecretKeyLength)) {
            return false;
        }
        Integer this$userActivationTokenTtl = this.getUserActivationTokenTtl();
        Integer other$userActivationTokenTtl = other.getUserActivationTokenTtl();
        if (this$userActivationTokenTtl == null ? other$userActivationTokenTtl != null : !((Object)this$userActivationTokenTtl).equals(other$userActivationTokenTtl)) {
            return false;
        }
        Integer this$passwordResetTokenTtl = this.getPasswordResetTokenTtl();
        Integer other$passwordResetTokenTtl = other.getPasswordResetTokenTtl();
        if (this$passwordResetTokenTtl == null ? other$passwordResetTokenTtl != null : !((Object)this$passwordResetTokenTtl).equals(other$passwordResetTokenTtl)) {
            return false;
        }
        UserPasswordPolicy this$passwordPolicy = this.getPasswordPolicy();
        UserPasswordPolicy other$passwordPolicy = other.getPasswordPolicy();
        if (this$passwordPolicy == null ? other$passwordPolicy != null : !((Object)this$passwordPolicy).equals(other$passwordPolicy)) {
            return false;
        }
        String this$userLockoutNotificationEmail = this.getUserLockoutNotificationEmail();
        String other$userLockoutNotificationEmail = other.getUserLockoutNotificationEmail();
        return !(this$userLockoutNotificationEmail == null ? other$userLockoutNotificationEmail != null : !this$userLockoutNotificationEmail.equals(other$userLockoutNotificationEmail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecuritySettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxFailedLoginAttempts = this.getMaxFailedLoginAttempts();
        result = result * 59 + ($maxFailedLoginAttempts == null ? 43 : ((Object)$maxFailedLoginAttempts).hashCode());
        Integer $mobileSecretKeyLength = this.getMobileSecretKeyLength();
        result = result * 59 + ($mobileSecretKeyLength == null ? 43 : ((Object)$mobileSecretKeyLength).hashCode());
        Integer $userActivationTokenTtl = this.getUserActivationTokenTtl();
        result = result * 59 + ($userActivationTokenTtl == null ? 43 : ((Object)$userActivationTokenTtl).hashCode());
        Integer $passwordResetTokenTtl = this.getPasswordResetTokenTtl();
        result = result * 59 + ($passwordResetTokenTtl == null ? 43 : ((Object)$passwordResetTokenTtl).hashCode());
        UserPasswordPolicy $passwordPolicy = this.getPasswordPolicy();
        result = result * 59 + ($passwordPolicy == null ? 43 : ((Object)$passwordPolicy).hashCode());
        String $userLockoutNotificationEmail = this.getUserLockoutNotificationEmail();
        result = result * 59 + ($userLockoutNotificationEmail == null ? 43 : $userLockoutNotificationEmail.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SecuritySettings(passwordPolicy=" + String.valueOf(this.getPasswordPolicy()) + ", maxFailedLoginAttempts=" + this.getMaxFailedLoginAttempts() + ", userLockoutNotificationEmail=" + this.getUserLockoutNotificationEmail() + ", mobileSecretKeyLength=" + this.getMobileSecretKeyLength() + ", userActivationTokenTtl=" + this.getUserActivationTokenTtl() + ", passwordResetTokenTtl=" + this.getPasswordResetTokenTtl() + ")";
    }
}

