/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;

@Schema(description="JWT Settings")
public class JwtSettings {
    @Schema(description="The JWT will expire after seconds.", example="9000")
    private Integer tokenExpirationTime;
    @Schema(description="The JWT can be refreshed during seconds.", example="604800")
    private Integer refreshTokenExpTime;
    @Schema(description="The JWT issuer.", example="thingsboard.io")
    private String tokenIssuer;
    @Schema(description="The JWT key is used to sing token. Base64 encoded.", example="dkVTUzU2M2VMWUNwVVltTUhQU2o5SUM0Tkc3M0k2Ykdwcm85QTl6R0RaQ252OFlmVDk2OEptZXBNcndGeExFZg==")
    private String tokenSigningKey;

    @ConstructorProperties(value={"tokenExpirationTime", "refreshTokenExpTime", "tokenIssuer", "tokenSigningKey"})
    @Generated
    public JwtSettings(Integer tokenExpirationTime, Integer refreshTokenExpTime, String tokenIssuer, String tokenSigningKey) {
        this.tokenExpirationTime = tokenExpirationTime;
        this.refreshTokenExpTime = refreshTokenExpTime;
        this.tokenIssuer = tokenIssuer;
        this.tokenSigningKey = tokenSigningKey;
    }

    @Generated
    public JwtSettings() {
    }

    @Generated
    public Integer getTokenExpirationTime() {
        return this.tokenExpirationTime;
    }

    @Generated
    public Integer getRefreshTokenExpTime() {
        return this.refreshTokenExpTime;
    }

    @Generated
    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    @Generated
    public String getTokenSigningKey() {
        return this.tokenSigningKey;
    }

    @Generated
    public void setTokenExpirationTime(Integer tokenExpirationTime) {
        this.tokenExpirationTime = tokenExpirationTime;
    }

    @Generated
    public void setRefreshTokenExpTime(Integer refreshTokenExpTime) {
        this.refreshTokenExpTime = refreshTokenExpTime;
    }

    @Generated
    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    @Generated
    public void setTokenSigningKey(String tokenSigningKey) {
        this.tokenSigningKey = tokenSigningKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtSettings)) {
            return false;
        }
        JwtSettings other = (JwtSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tokenExpirationTime = this.getTokenExpirationTime();
        Integer other$tokenExpirationTime = other.getTokenExpirationTime();
        if (this$tokenExpirationTime == null ? other$tokenExpirationTime != null : !((Object)this$tokenExpirationTime).equals(other$tokenExpirationTime)) {
            return false;
        }
        Integer this$refreshTokenExpTime = this.getRefreshTokenExpTime();
        Integer other$refreshTokenExpTime = other.getRefreshTokenExpTime();
        if (this$refreshTokenExpTime == null ? other$refreshTokenExpTime != null : !((Object)this$refreshTokenExpTime).equals(other$refreshTokenExpTime)) {
            return false;
        }
        String this$tokenIssuer = this.getTokenIssuer();
        String other$tokenIssuer = other.getTokenIssuer();
        if (this$tokenIssuer == null ? other$tokenIssuer != null : !this$tokenIssuer.equals(other$tokenIssuer)) {
            return false;
        }
        String this$tokenSigningKey = this.getTokenSigningKey();
        String other$tokenSigningKey = other.getTokenSigningKey();
        return !(this$tokenSigningKey == null ? other$tokenSigningKey != null : !this$tokenSigningKey.equals(other$tokenSigningKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JwtSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tokenExpirationTime = this.getTokenExpirationTime();
        result = result * 59 + ($tokenExpirationTime == null ? 43 : ((Object)$tokenExpirationTime).hashCode());
        Integer $refreshTokenExpTime = this.getRefreshTokenExpTime();
        result = result * 59 + ($refreshTokenExpTime == null ? 43 : ((Object)$refreshTokenExpTime).hashCode());
        String $tokenIssuer = this.getTokenIssuer();
        result = result * 59 + ($tokenIssuer == null ? 43 : $tokenIssuer.hashCode());
        String $tokenSigningKey = this.getTokenSigningKey();
        result = result * 59 + ($tokenSigningKey == null ? 43 : $tokenSigningKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtSettings(tokenExpirationTime=" + this.getTokenExpirationTime() + ", refreshTokenExpTime=" + this.getRefreshTokenExpTime() + ", tokenIssuer=" + this.getTokenIssuer() + ", tokenSigningKey=" + this.getTokenSigningKey() + ")";
    }
}

