/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.secret;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SecretType;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class SecretInfo
extends BaseData<SecretId>
implements TenantEntity,
HasName {
    private static final long serialVersionUID = 4356095580465337566L;
    @Schema(description="JSON object with Tenant Id. Tenant Id of the secret cannot be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @NotBlank
    @Length(fieldName="name")
    @Schema(description="Secret name", requiredMode=Schema.RequiredMode.REQUIRED, example="Secret")
    private String name;
    @NotNull
    @Schema(description="Secret type.", requiredMode=Schema.RequiredMode.REQUIRED, example="TEXT")
    private SecretType type;
    @NoXss
    @Length(fieldName="description")
    @Schema(description="Secret description.", example="Secret description")
    private String description;

    @Override
    @Schema(description="JSON object with the Secret Id. Specify this field to update the Secret. Referencing non-existing Secret Id will cause error. Omit this field to create new Secret.")
    public SecretId getId() {
        return (SecretId)super.getId();
    }

    public SecretInfo() {
    }

    public SecretInfo(SecretId id) {
        super(id);
    }

    public SecretInfo(SecretInfo secretInfo) {
        super(secretInfo);
        this.tenantId = secretInfo.getTenantId();
        this.name = secretInfo.getName();
        this.type = secretInfo.getType();
        this.description = secretInfo.getDescription();
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.SECRET;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SecretType getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(SecretType type) {
        this.type = type;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Generated
    public String toString() {
        return "SecretInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretInfo)) {
            return false;
        }
        SecretInfo other = (SecretInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SecretType this$type = this.getType();
        SecretType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecretInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SecretType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

