/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.secret;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.secret.SecretInfo;

@Schema
public class Secret
extends SecretInfo {
    private static final long serialVersionUID = 3671364019778017637L;
    private String value;
    @JsonIgnore
    private byte[] encryptedValue;

    @JsonGetter(value="encryptedValue")
    public String getEncryptedValueBase64() {
        return this.encryptedValue != null ? Base64.getEncoder().encodeToString(this.encryptedValue) : null;
    }

    @JsonSetter(value="encryptedValue")
    public void setEncryptedValueBase64(String value) {
        this.encryptedValue = value != null ? Base64.getDecoder().decode(value) : null;
    }

    public Secret() {
    }

    public Secret(SecretId id) {
        super(id);
    }

    public Secret(Secret secret) {
        super(secret);
        this.value = secret.getValue();
        this.encryptedValue = secret.getEncryptedValue();
    }

    public Secret(SecretInfo secretInfo) {
        super(secretInfo);
        this.value = null;
        this.encryptedValue = null;
    }

    public Secret(SecretInfo secretInfo, byte[] encryptedValue) {
        super(secretInfo);
        this.encryptedValue = encryptedValue;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public byte[] getEncryptedValue() {
        return this.encryptedValue;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @JsonIgnore
    @Generated
    public void setEncryptedValue(byte[] encryptedValue) {
        this.encryptedValue = encryptedValue;
    }

    @Override
    @Generated
    public String toString() {
        return "Secret(value=" + this.getValue() + ", encryptedValue=" + Arrays.toString(this.getEncryptedValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret other = (Secret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getEncryptedValue(), other.getEncryptedValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Secret;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getEncryptedValue());
        return result;
    }
}

