/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeatType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimerRepeat
implements SchedulerRepeat {
    private long repeatInterval;
    private TimeUnit timeUnit;
    private long endsOn;

    @Override
    public long getEndsOn() {
        return this.endsOn;
    }

    @Override
    public SchedulerRepeatType getType() {
        return SchedulerRepeatType.TIMER;
    }

    @Override
    public long getNext(long startTime, long ts, String timezone) {
        long interval = this.timeUnit.toMillis(this.repeatInterval);
        for (long tmp = startTime; tmp < this.endsOn; tmp += interval) {
            if (tmp <= ts) continue;
            return tmp;
        }
        return 0L;
    }

    @Generated
    public TimerRepeat() {
    }

    @Generated
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Generated
    public void setEndsOn(long endsOn) {
        this.endsOn = endsOn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimerRepeat)) {
            return false;
        }
        TimerRepeat other = (TimerRepeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRepeatInterval() != other.getRepeatInterval()) {
            return false;
        }
        if (this.getEndsOn() != other.getEndsOn()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimerRepeat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $repeatInterval = this.getRepeatInterval();
        result = result * 59 + (int)($repeatInterval >>> 32 ^ $repeatInterval);
        long $endsOn = this.getEndsOn();
        result = result * 59 + (int)($endsOn >>> 32 ^ $endsOn);
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimerRepeat(repeatInterval=" + this.getRepeatInterval() + ", timeUnit=" + String.valueOf((Object)this.getTimeUnit()) + ", endsOn=" + this.getEndsOn() + ")";
    }
}

