/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.scheduler.SchedulerEventDescriptor;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class SchedulerEventInfo
extends BaseDataWithAdditionalInfo<SchedulerEventId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId,
HasVersion,
ExportableEntity<SchedulerEventId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventInfo.class);
    private static final long serialVersionUID = 2807343040519549363L;
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @Schema(description="JSON object with Originator Id", accessMode=Schema.AccessMode.READ_ONLY)
    private EntityId originatorId;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="scheduler event name", example="Weekly Dashboard Report")
    private String name;
    @Schema(description="scheduler event type", example="generateReport")
    @NoXss
    @Length(fieldName="type")
    private String type;
    @Schema(description="a JSON value with schedule time configuration", implementation=JsonNode.class)
    private JsonNode schedule;
    @Schema(description="Enable/disable scheduler", example="true")
    @Length(fieldName="enabled")
    private boolean enabled = true;
    private SchedulerEventId externalId;
    private Long version;

    public SchedulerEventInfo() {
    }

    public SchedulerEventInfo(SchedulerEventId id) {
        super(id);
    }

    public SchedulerEventInfo(SchedulerEventInfo schedulerEventInfo) {
        super(schedulerEventInfo);
        this.tenantId = schedulerEventInfo.getTenantId();
        this.customerId = schedulerEventInfo.getCustomerId();
        this.originatorId = schedulerEventInfo.getOriginatorId();
        this.name = schedulerEventInfo.getName();
        this.type = schedulerEventInfo.getType();
        this.enabled = schedulerEventInfo.isEnabled();
        this.setSchedule(schedulerEventInfo.getSchedule());
        this.version = schedulerEventInfo.getVersion();
        this.externalId = schedulerEventInfo.getExternalId();
    }

    @Override
    @Schema(description="JSON object with the scheduler event Id. Specify this field to update the scheduler event. Referencing non-existing scheduler event Id will cause error. Omit this field to create new scheduler event")
    public SchedulerEventId getId() {
        return (SchedulerEventId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the scheduler event creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Additional parameters of the scheduler event", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @JsonIgnore
    public SchedulerEventDescriptor toDescriptor() {
        long startTime = this.schedule.get("startTime").asLong();
        String timezone = this.schedule.get("timezone").asText();
        JsonNode repeatNode = this.schedule.get("repeat");
        SchedulerRepeat repeat = null;
        if (repeatNode != null) {
            try {
                repeat = (SchedulerRepeat)mapper.treeToValue((TreeNode)repeatNode, SchedulerRepeat.class);
            }
            catch (Exception e) {
                log.error("Failed to read scheduler config for {}", (Object)this, (Object)e);
            }
        }
        return new SchedulerEventDescriptor(startTime, timezone, repeat);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.SCHEDULER_EVENT;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public EntityId getOriginatorId() {
        return this.originatorId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public JsonNode getSchedule() {
        return this.schedule;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public SchedulerEventId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setOriginatorId(EntityId originatorId) {
        this.originatorId = originatorId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSchedule(JsonNode schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @Generated
    public void setExternalId(SchedulerEventId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "SchedulerEventInfo(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", originatorId=" + String.valueOf(this.getOriginatorId()) + ", name=" + this.getName() + ", type=" + this.getType() + ", schedule=" + String.valueOf(this.getSchedule()) + ", enabled=" + this.isEnabled() + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerEventInfo)) {
            return false;
        }
        SchedulerEventInfo other = (SchedulerEventInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        EntityId this$originatorId = this.getOriginatorId();
        EntityId other$originatorId = other.getOriginatorId();
        if (this$originatorId == null ? other$originatorId != null : !this$originatorId.equals(other$originatorId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        JsonNode this$schedule = this.getSchedule();
        JsonNode other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        SchedulerEventId this$externalId = this.getExternalId();
        SchedulerEventId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchedulerEventInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        EntityId $originatorId = this.getOriginatorId();
        result = result * 59 + ($originatorId == null ? 43 : $originatorId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        JsonNode $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        SchedulerEventId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

