/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;

public class SchedulerEvent
extends SchedulerEventInfo {
    private static final long serialVersionUID = 2807343050519549363L;
    @Schema(description="a JSON value with scheduler event configuration", implementation=JsonNode.class)
    private transient JsonNode configuration;
    @JsonIgnore
    private byte[] configurationBytes;

    public SchedulerEvent() {
    }

    public SchedulerEvent(SchedulerEventId id) {
        super(id);
    }

    public SchedulerEvent(SchedulerEvent schedulerEvent) {
        super(schedulerEvent);
        this.setConfiguration(schedulerEvent.getConfiguration().deepCopy());
    }

    public SchedulerEvent(SchedulerEventInfo schedulerEventInfo, JsonNode configuration) {
        super(schedulerEventInfo);
        this.setConfiguration(configuration.deepCopy());
    }

    public JsonNode getConfiguration() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        SchedulerEvent.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    @Generated
    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    @JsonIgnore
    @Generated
    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    @Override
    @Generated
    public String toString() {
        return "SchedulerEvent(super=" + super.toString() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerEvent)) {
            return false;
        }
        SchedulerEvent other = (SchedulerEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchedulerEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        return result;
    }
}

