/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Calendar;
import lombok.Generated;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeatType;
import org.thingsboard.server.common.data.scheduler.SchedulerUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EveryNDaysRepeat
implements SchedulerRepeat {
    private long endsOn;
    private int days;

    @Override
    public SchedulerRepeatType getType() {
        return SchedulerRepeatType.EVERY_N_DAYS;
    }

    @Override
    public long getNext(long startTime, long ts, String timezone) {
        Calendar calendar = SchedulerUtils.getCalendarWithTimeZone(timezone);
        long tmp = startTime;
        int repeatIteration = 0;
        while (tmp < this.endsOn) {
            calendar.setTimeInMillis(startTime);
            calendar.add(6, repeatIteration * this.days);
            tmp = calendar.getTimeInMillis();
            if (tmp > ts && tmp < this.endsOn) {
                return tmp;
            }
            ++repeatIteration;
        }
        return 0L;
    }

    @Generated
    public EveryNDaysRepeat() {
    }

    @Override
    @Generated
    public long getEndsOn() {
        return this.endsOn;
    }

    @Generated
    public int getDays() {
        return this.days;
    }

    @Generated
    public void setEndsOn(long endsOn) {
        this.endsOn = endsOn;
    }

    @Generated
    public void setDays(int days) {
        this.days = days;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EveryNDaysRepeat)) {
            return false;
        }
        EveryNDaysRepeat other = (EveryNDaysRepeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEndsOn() != other.getEndsOn()) {
            return false;
        }
        return this.getDays() == other.getDays();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EveryNDaysRepeat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $endsOn = this.getEndsOn();
        result = result * 59 + (int)($endsOn >>> 32 ^ $endsOn);
        result = result * 59 + this.getDays();
        return result;
    }

    @Generated
    public String toString() {
        return "EveryNDaysRepeat(endsOn=" + this.getEndsOn() + ", days=" + this.getDays() + ")";
    }
}

