/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.role;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Role
extends BaseDataWithAdditionalInfo<RoleId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId,
ExportableEntity<RoleId>,
HasVersion {
    private static final long serialVersionUID = 5582010124562018986L;
    public static final String ROLE_TENANT_ADMIN_NAME = "Tenant Administrator";
    public static final String ROLE_TENANT_USER_NAME = "Tenant User";
    public static final String ROLE_CUSTOMER_ADMIN_NAME = "Customer Administrator";
    public static final String ROLE_CUSTOMER_USER_NAME = "Customer User";
    public static final String ROLE_PUBLIC_USER_NAME = "Public User";
    public static final String ROLE_PUBLIC_USER_ENTITY_GROUP_NAME = "Entity Group Public User";
    public static final String ROLE_READ_ONLY_ENTITY_GROUP_NAME = "Entity Group Read-only User";
    public static final String ROLE_WRITE_ENTITY_GROUP_NAME = "Entity Group Write User";
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id. ", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Role Name", example="Read-Only")
    private String name;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Type of the role: generic or group", example="GROUP")
    private RoleType type;
    @Schema(description="JSON object with the set of permissions. Structure is specific for role type", accessMode=Schema.AccessMode.READ_ONLY)
    private transient JsonNode permissions;
    @JsonIgnore
    private byte[] permissionsBytes;
    private RoleId externalId;
    private Long version;

    public Role() {
    }

    public Role(RoleId id) {
        super(id);
    }

    public Role(Role role) {
        super(role);
        this.setPermissions(role.getPermissions());
        this.externalId = role.getExternalId();
        this.version = role.getVersion();
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ROLE;
    }

    public JsonNode getPermissions() {
        return Role.getJson(() -> this.permissions, () -> this.permissionsBytes);
    }

    public void setPermissions(JsonNode permissions) {
        Role.setJson(permissions, json -> {
            this.permissions = json;
        }, bytes -> {
            this.permissionsBytes = bytes;
        });
    }

    @Override
    @Schema(description="JSON object with the Role Id. Specify this field to update the Role. Referencing non-existing Role Id will cause error. Omit this field to create new Role.")
    public RoleId getId() {
        return (RoleId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the role creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Additional parameters of the role", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RoleType getType() {
        return this.type;
    }

    @Generated
    public byte[] getPermissionsBytes() {
        return this.permissionsBytes;
    }

    @Override
    @Generated
    public RoleId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(RoleType type) {
        this.type = type;
    }

    @JsonIgnore
    @Generated
    public void setPermissionsBytes(byte[] permissionsBytes) {
        this.permissionsBytes = permissionsBytes;
    }

    @Override
    @Generated
    public void setExternalId(RoleId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "Role(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", permissions=" + String.valueOf(this.getPermissions()) + ", permissionsBytes=" + Arrays.toString(this.getPermissionsBytes()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @ConstructorProperties(value={"tenantId", "customerId", "name", "type", "permissions", "permissionsBytes", "externalId", "version"})
    @Generated
    public Role(TenantId tenantId, CustomerId customerId, String name, RoleType type, JsonNode permissions, byte[] permissionsBytes, RoleId externalId, Long version) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.type = type;
        this.permissions = permissions;
        this.permissionsBytes = permissionsBytes;
        this.externalId = externalId;
        this.version = version;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RoleType this$type = this.getType();
        RoleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getPermissionsBytes(), other.getPermissionsBytes())) {
            return false;
        }
        RoleId this$externalId = this.getExternalId();
        RoleId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RoleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPermissionsBytes());
        RoleId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

