/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.report.BaseReportTemplate;
import org.thingsboard.server.common.data.report.configuration.ReportTemplateConfig;
import org.thingsboard.server.common.data.report.configuration.components.DataReportComponent;
import org.thingsboard.server.common.data.report.configuration.components.ReportComponent;
import org.thingsboard.server.common.data.util.DataUtils;

@Schema
public class ReportTemplate
extends BaseReportTemplate {
    private static final long serialVersionUID = 1729877416392618039L;
    @Schema(description="a JSON value with report template configuration")
    @Valid
    @NotNull
    private ReportTemplateConfig configuration;

    public ReportTemplate() {
    }

    public ReportTemplate(ReportTemplateId id) {
        super(id);
    }

    public ReportTemplate(BaseReportTemplate reportTemplate) {
        super(reportTemplate);
    }

    public ReportTemplate(ReportTemplate reportTemplate) {
        super(reportTemplate);
        if (reportTemplate.getConfiguration() != null) {
            this.configuration = (ReportTemplateConfig)mapper.convertValue((Object)mapper.valueToTree((Object)reportTemplate.getConfiguration()), ReportTemplateConfig.class);
        }
    }

    @JsonIgnore
    public List<ObjectNode> getEntityAliasesConfig() {
        return DataUtils.getChildObjects("entityAliases", mapper.valueToTree((Object)this.configuration));
    }

    @JsonIgnore
    public List<ObjectNode> getComponentDataSources() {
        List<ReportComponent> components = this.configuration.getComponents();
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        return components.stream().filter(component -> component instanceof DataReportComponent).flatMap(component -> ((DataReportComponent)component).getDataSources().stream()).map(fromValue -> (ObjectNode)mapper.valueToTree(fromValue)).toList();
    }

    @Generated
    public ReportTemplateConfig getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(ReportTemplateConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public String toString() {
        return "ReportTemplate(super=" + super.toString() + ", configuration=" + String.valueOf(this.getConfiguration()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportTemplate)) {
            return false;
        }
        ReportTemplate other = (ReportTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReportTemplateConfig this$configuration = this.getConfiguration();
        ReportTemplateConfig other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReportTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ReportTemplateConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

