/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.report;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.UserId;

public class ReportConfig {
    @NotNull
    @Schema(description="Json object representing the report template id.")
    private ReportTemplateId reportTemplateId;
    @NotNull
    @Schema(description="Json object representing the user id.", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private UserId userId;
    @Schema(description="Timezone in which target dashboard will be presented in dashboard report.", example="Europe/Kiev", requiredMode=Schema.RequiredMode.REQUIRED)
    private String timezone;
    @Schema(description="List of ids representing the notification targets.")
    private List<UUID> targets;
    @Schema(description="Json object representing the notification template id.", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private NotificationTemplateId notificationTemplateId;

    @Generated
    public ReportConfig() {
    }

    @Generated
    public ReportTemplateId getReportTemplateId() {
        return this.reportTemplateId;
    }

    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public List<UUID> getTargets() {
        return this.targets;
    }

    @Generated
    public NotificationTemplateId getNotificationTemplateId() {
        return this.notificationTemplateId;
    }

    @Generated
    public void setReportTemplateId(ReportTemplateId reportTemplateId) {
        this.reportTemplateId = reportTemplateId;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public void setTargets(List<UUID> targets) {
        this.targets = targets;
    }

    @Generated
    public void setNotificationTemplateId(NotificationTemplateId notificationTemplateId) {
        this.notificationTemplateId = notificationTemplateId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportConfig)) {
            return false;
        }
        ReportConfig other = (ReportConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReportTemplateId this$reportTemplateId = this.getReportTemplateId();
        ReportTemplateId other$reportTemplateId = other.getReportTemplateId();
        if (this$reportTemplateId == null ? other$reportTemplateId != null : !((Object)this$reportTemplateId).equals(other$reportTemplateId)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        List<UUID> this$targets = this.getTargets();
        List<UUID> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        NotificationTemplateId this$notificationTemplateId = this.getNotificationTemplateId();
        NotificationTemplateId other$notificationTemplateId = other.getNotificationTemplateId();
        return !(this$notificationTemplateId == null ? other$notificationTemplateId != null : !((Object)this$notificationTemplateId).equals(other$notificationTemplateId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReportConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportTemplateId $reportTemplateId = this.getReportTemplateId();
        result = result * 59 + ($reportTemplateId == null ? 43 : ((Object)$reportTemplateId).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        List<UUID> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        NotificationTemplateId $notificationTemplateId = this.getNotificationTemplateId();
        result = result * 59 + ($notificationTemplateId == null ? 43 : ((Object)$notificationTemplateId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReportConfig(reportTemplateId=" + String.valueOf(this.getReportTemplateId()) + ", userId=" + String.valueOf(this.getUserId()) + ", timezone=" + this.getTimezone() + ", targets=" + String.valueOf(this.getTargets()) + ", notificationTemplateId=" + String.valueOf(this.getNotificationTemplateId()) + ")";
    }
}

