/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.relation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.EdqsObjectKey;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.validation.Length;

@Schema
public class EntityRelation
implements HasVersion,
Serializable,
EdqsObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityRelation.class);
    private static final long serialVersionUID = 2807343040519543363L;
    public static final String INTEGRATION_TYPE = "ManagedByIntegration";
    public static final String EDGE_TYPE = "ManagedByEdge";
    public static final String CONTAINS_TYPE = "Contains";
    public static final String MANAGES_TYPE = "Manages";
    public static final String USES_TYPE = "Uses";
    private EntityId from;
    private EntityId to;
    @Length(fieldName="type")
    private String type;
    private RelationTypeGroup typeGroup;
    private Long version;
    private transient JsonNode additionalInfo;
    @JsonIgnore
    private byte[] additionalInfoBytes;

    public EntityRelation() {
    }

    public EntityRelation(EntityId from, EntityId to, String type) {
        this(from, to, type, RelationTypeGroup.COMMON);
    }

    public EntityRelation(EntityId from, EntityId to, String type, RelationTypeGroup typeGroup) {
        this(from, to, type, typeGroup, null);
    }

    public EntityRelation(EntityId from, EntityId to, String type, RelationTypeGroup typeGroup, JsonNode additionalInfo) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.typeGroup = typeGroup;
        this.additionalInfo = additionalInfo;
    }

    public EntityRelation(EntityRelation entityRelation) {
        this.from = entityRelation.getFrom();
        this.to = entityRelation.getTo();
        this.type = entityRelation.getType();
        this.typeGroup = entityRelation.getTypeGroup();
        this.additionalInfo = entityRelation.getAdditionalInfo();
        this.version = entityRelation.getVersion();
    }

    @Schema(description="JSON object with [from] Entity Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getFrom() {
        return this.from;
    }

    @Schema(description="JSON object with [to] Entity Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getTo() {
        return this.to;
    }

    @Schema(description="String value of relation type.", example="Contains")
    public String getType() {
        return this.type;
    }

    @Schema(description="Represents the type group of the relation.", example="COMMON")
    public RelationTypeGroup getTypeGroup() {
        return this.typeGroup;
    }

    @Schema(description="Additional parameters of the relation", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.additionalInfo, () -> this.additionalInfoBytes);
    }

    public void setAdditionalInfo(JsonNode addInfo) {
        BaseDataWithAdditionalInfo.setJson(addInfo, json -> {
            this.additionalInfo = json;
        }, bytes -> {
            this.additionalInfoBytes = bytes;
        });
    }

    @Override
    public String stringKey() {
        return "r_" + String.valueOf(this.from) + "_" + String.valueOf(this.to) + "_" + String.valueOf((Object)this.typeGroup) + "_" + this.type;
    }

    @Override
    public Long version() {
        return this.version;
    }

    @Override
    public ObjectType type() {
        return ObjectType.RELATION;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityRelation)) {
            return false;
        }
        EntityRelation other = (EntityRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        EntityId this$from = this.getFrom();
        EntityId other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        EntityId this$to = this.getTo();
        EntityId other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        RelationTypeGroup this$typeGroup = this.getTypeGroup();
        RelationTypeGroup other$typeGroup = other.getTypeGroup();
        return !(this$typeGroup == null ? other$typeGroup != null : !((Object)((Object)this$typeGroup)).equals((Object)other$typeGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityRelation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        EntityId $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        EntityId $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        RelationTypeGroup $typeGroup = this.getTypeGroup();
        result = result * 59 + ($typeGroup == null ? 43 : ((Object)((Object)$typeGroup)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityRelation(from=" + String.valueOf(this.getFrom()) + ", to=" + String.valueOf(this.getTo()) + ", type=" + this.getType() + ", typeGroup=" + String.valueOf((Object)this.getTypeGroup()) + ", version=" + this.getVersion() + ", additionalInfo=" + String.valueOf(this.getAdditionalInfo()) + ")";
    }

    @Generated
    public void setFrom(EntityId from) {
        this.from = from;
    }

    @Generated
    public void setTo(EntityId to) {
        this.to = to;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTypeGroup(RelationTypeGroup typeGroup) {
        this.typeGroup = typeGroup;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    public record Key(UUID from, UUID to, RelationTypeGroup typeGroup, String type) implements EdqsObjectKey
    {
    }
}

