/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.queue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.QueueConfig;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Queue
extends BaseDataWithAdditionalInfo<QueueId>
implements HasName,
TenantEntity,
QueueConfig {
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    @NoXss
    @Length(fieldName="topic")
    private String topic;
    private int pollInterval;
    private int partitions;
    private boolean consumerPerPartition;
    private long packProcessingTimeout;
    private SubmitStrategy submitStrategy;
    private ProcessingStrategy processingStrategy;

    public Queue() {
    }

    public Queue(QueueId id) {
        super(id);
    }

    public Queue(TenantId tenantId, TenantProfileQueueConfiguration queueConfiguration) {
        this.tenantId = tenantId;
        this.name = queueConfiguration.getName();
        this.topic = queueConfiguration.getTopic();
        this.pollInterval = queueConfiguration.getPollInterval();
        this.partitions = queueConfiguration.getPartitions();
        this.consumerPerPartition = queueConfiguration.isConsumerPerPartition();
        this.packProcessingTimeout = queueConfiguration.getPackProcessingTimeout();
        this.submitStrategy = queueConfiguration.getSubmitStrategy();
        this.processingStrategy = queueConfiguration.getProcessingStrategy();
        this.setAdditionalInfo(queueConfiguration.getAdditionalInfo());
    }

    @JsonIgnore
    public String getCustomProperties() {
        return Optional.ofNullable(this.getAdditionalInfo()).map(info -> info.get("customProperties")).filter(JsonNode::isTextual).map(JsonNode::asText).orElse(null);
    }

    @JsonIgnore
    public boolean isDuplicateMsgToAllPartitions() {
        return Optional.ofNullable(this.getAdditionalInfo()).map(info -> info.get("duplicateMsgToAllPartitions")).filter(JsonNode::isBoolean).map(JsonNode::asBoolean).orElse(false);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.QUEUE;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Generated
    public int getPollInterval() {
        return this.pollInterval;
    }

    @Generated
    public int getPartitions() {
        return this.partitions;
    }

    @Override
    @Generated
    public boolean isConsumerPerPartition() {
        return this.consumerPerPartition;
    }

    @Generated
    public long getPackProcessingTimeout() {
        return this.packProcessingTimeout;
    }

    @Generated
    public SubmitStrategy getSubmitStrategy() {
        return this.submitStrategy;
    }

    @Generated
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Generated
    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    @Generated
    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    @Generated
    public void setConsumerPerPartition(boolean consumerPerPartition) {
        this.consumerPerPartition = consumerPerPartition;
    }

    @Generated
    public void setPackProcessingTimeout(long packProcessingTimeout) {
        this.packProcessingTimeout = packProcessingTimeout;
    }

    @Generated
    public void setSubmitStrategy(SubmitStrategy submitStrategy) {
        this.submitStrategy = submitStrategy;
    }

    @Generated
    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPollInterval() != other.getPollInterval()) {
            return false;
        }
        if (this.getPartitions() != other.getPartitions()) {
            return false;
        }
        if (this.isConsumerPerPartition() != other.isConsumerPerPartition()) {
            return false;
        }
        if (this.getPackProcessingTimeout() != other.getPackProcessingTimeout()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        SubmitStrategy this$submitStrategy = this.getSubmitStrategy();
        SubmitStrategy other$submitStrategy = other.getSubmitStrategy();
        if (this$submitStrategy == null ? other$submitStrategy != null : !((Object)this$submitStrategy).equals(other$submitStrategy)) {
            return false;
        }
        ProcessingStrategy this$processingStrategy = this.getProcessingStrategy();
        ProcessingStrategy other$processingStrategy = other.getProcessingStrategy();
        return !(this$processingStrategy == null ? other$processingStrategy != null : !((Object)this$processingStrategy).equals(other$processingStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Queue;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPollInterval();
        result = result * 59 + this.getPartitions();
        result = result * 59 + (this.isConsumerPerPartition() ? 79 : 97);
        long $packProcessingTimeout = this.getPackProcessingTimeout();
        result = result * 59 + (int)($packProcessingTimeout >>> 32 ^ $packProcessingTimeout);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        SubmitStrategy $submitStrategy = this.getSubmitStrategy();
        result = result * 59 + ($submitStrategy == null ? 43 : ((Object)$submitStrategy).hashCode());
        ProcessingStrategy $processingStrategy = this.getProcessingStrategy();
        result = result * 59 + ($processingStrategy == null ? 43 : ((Object)$processingStrategy).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Queue(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", topic=" + this.getTopic() + ", pollInterval=" + this.getPollInterval() + ", partitions=" + this.getPartitions() + ", consumerPerPartition=" + this.isConsumerPerPartition() + ", packProcessingTimeout=" + this.getPackProcessingTimeout() + ", submitStrategy=" + String.valueOf(this.getSubmitStrategy()) + ", processingStrategy=" + String.valueOf(this.getProcessingStrategy()) + ")";
    }
}

