/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import lombok.Generated;

public enum EntityKeyType {
    ATTRIBUTE("attribute"),
    CLIENT_ATTRIBUTE("clientAttribute"),
    SHARED_ATTRIBUTE("sharedAttribute"),
    SERVER_ATTRIBUTE("serverAttribute"),
    TIME_SERIES("timeseries"),
    ENTITY_FIELD("entityField"),
    ALARM_FIELD("alarm");

    private final String name;

    private EntityKeyType(String name) {
        this.name = name;
    }

    public static EntityKeyType fromName(String name) {
        for (EntityKeyType entityKeyType : EntityKeyType.values()) {
            if (!entityKeyType.getName().equals(name)) continue;
            return entityKeyType;
        }
        throw new IllegalArgumentException(String.format("Unsupported entity key type : %s", name));
    }

    public boolean isAttribute() {
        return this == ATTRIBUTE || this == CLIENT_ATTRIBUTE || this == SHARED_ATTRIBUTE || this == SERVER_ATTRIBUTE;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

