/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.query.AliasEntityId;
import org.thingsboard.server.common.data.query.ApiUsageStateFilter;
import org.thingsboard.server.common.data.query.AssetSearchQueryFilter;
import org.thingsboard.server.common.data.query.AssetTypeFilter;
import org.thingsboard.server.common.data.query.DeviceSearchQueryFilter;
import org.thingsboard.server.common.data.query.DeviceTypeFilter;
import org.thingsboard.server.common.data.query.EdgeSearchQueryFilter;
import org.thingsboard.server.common.data.query.EdgeTypeFilter;
import org.thingsboard.server.common.data.query.EntitiesByGroupNameFilter;
import org.thingsboard.server.common.data.query.EntityFilterType;
import org.thingsboard.server.common.data.query.EntityGroupFilter;
import org.thingsboard.server.common.data.query.EntityGroupListFilter;
import org.thingsboard.server.common.data.query.EntityGroupNameFilter;
import org.thingsboard.server.common.data.query.EntityListFilter;
import org.thingsboard.server.common.data.query.EntityNameFilter;
import org.thingsboard.server.common.data.query.EntitySearchQueryFilter;
import org.thingsboard.server.common.data.query.EntityTypeFilter;
import org.thingsboard.server.common.data.query.EntityViewSearchQueryFilter;
import org.thingsboard.server.common.data.query.EntityViewTypeFilter;
import org.thingsboard.server.common.data.query.RelationsQueryFilter;
import org.thingsboard.server.common.data.query.SchedulerEventFilter;
import org.thingsboard.server.common.data.query.SingleEntityFilter;
import org.thingsboard.server.common.data.query.StateEntityFilter;
import org.thingsboard.server.common.data.query.StateEntityOwnerFilter;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SingleEntityFilter.class, name="singleEntity"), @JsonSubTypes.Type(value=EntityGroupFilter.class, name="entityGroup"), @JsonSubTypes.Type(value=EntityListFilter.class, name="entityList"), @JsonSubTypes.Type(value=EntityNameFilter.class, name="entityName"), @JsonSubTypes.Type(value=EntityTypeFilter.class, name="entityType"), @JsonSubTypes.Type(value=EntityGroupListFilter.class, name="entityGroupList"), @JsonSubTypes.Type(value=EntityGroupNameFilter.class, name="entityGroupName"), @JsonSubTypes.Type(value=EntitiesByGroupNameFilter.class, name="entitiesByGroupName"), @JsonSubTypes.Type(value=StateEntityFilter.class, name="stateEntity"), @JsonSubTypes.Type(value=StateEntityOwnerFilter.class, name="stateEntityOwner"), @JsonSubTypes.Type(value=AssetTypeFilter.class, name="assetType"), @JsonSubTypes.Type(value=DeviceTypeFilter.class, name="deviceType"), @JsonSubTypes.Type(value=EdgeTypeFilter.class, name="edgeType"), @JsonSubTypes.Type(value=EntityViewTypeFilter.class, name="entityViewType"), @JsonSubTypes.Type(value=ApiUsageStateFilter.class, name="apiUsageState"), @JsonSubTypes.Type(value=RelationsQueryFilter.class, name="relationsQuery"), @JsonSubTypes.Type(value=AssetSearchQueryFilter.class, name="assetSearchQuery"), @JsonSubTypes.Type(value=DeviceSearchQueryFilter.class, name="deviceSearchQuery"), @JsonSubTypes.Type(value=EntityViewSearchQueryFilter.class, name="entityViewSearchQuery"), @JsonSubTypes.Type(value=EdgeSearchQueryFilter.class, name="edgeSearchQuery"), @JsonSubTypes.Type(value=SchedulerEventFilter.class, name="schedulerEvent")})
public interface EntityFilter {
    @JsonIgnore
    public EntityFilterType getType();

    public static void resolveEntityFilter(EntityFilter filter, TenantId tenantId, UserId userId, EntityId userOwnerId) {
        if (filter instanceof SingleEntityFilter) {
            SingleEntityFilter singleEntityFilter = (SingleEntityFilter)filter;
            AliasEntityId resolved = AliasEntityId.resolveAliasEntityId(singleEntityFilter.getSingleEntity(), tenantId, userId, userOwnerId);
            singleEntityFilter.setSingleEntity(resolved);
        } else if (filter instanceof RelationsQueryFilter) {
            RelationsQueryFilter queryFilter = (RelationsQueryFilter)filter;
            AliasEntityId resolved = AliasEntityId.resolveAliasEntityId(queryFilter.getRootEntity(), tenantId, userId, userOwnerId);
            queryFilter.setRootEntity(resolved);
        } else if (filter instanceof EntitySearchQueryFilter) {
            EntitySearchQueryFilter queryFilter = (EntitySearchQueryFilter)filter;
            AliasEntityId resolved = AliasEntityId.resolveAliasEntityId(queryFilter.getRootEntity(), tenantId, userId, userOwnerId);
            queryFilter.setRootEntity(resolved);
        } else if (filter instanceof SchedulerEventFilter) {
            SchedulerEventFilter queryFilter = (SchedulerEventFilter)filter;
            AliasEntityId resolved = AliasEntityId.resolveAliasEntityId(queryFilter.getOriginator(), tenantId, userId, userOwnerId);
            queryFilter.setOriginator(resolved);
        } else if (filter instanceof StateEntityFilter) {
            StateEntityFilter queryFilter = (StateEntityFilter)filter;
            AliasEntityId resolved = AliasEntityId.resolveAliasEntityId(queryFilter.getDefaultStateEntity(), tenantId, userId, userOwnerId);
            queryFilter.setDefaultStateEntity(resolved);
        } else if (filter instanceof StateEntityOwnerFilter) {
            StateEntityOwnerFilter queryFilter = (StateEntityOwnerFilter)filter;
            AliasEntityId resolvedEntityId = AliasEntityId.resolveAliasEntityId(queryFilter.getSingleEntity(), tenantId, userId, userOwnerId);
            queryFilter.setSingleEntity(resolvedEntityId);
            AliasEntityId resolvedDefaultEntityId = AliasEntityId.resolveAliasEntityId(queryFilter.getDefaultStateEntity(), tenantId, userId, userOwnerId);
            queryFilter.setDefaultStateEntity(resolvedDefaultEntityId);
        }
    }
}

