/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.UUID;
import org.thingsboard.server.common.data.query.AliasEntityId;

public class AliasEntityIdSerializer
extends JsonSerializer<AliasEntityId> {
    public void serialize(AliasEntityId value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        String entityType = value.isAliasEntityId() ? value.getAliasEntityType().name() : value.getEntityType().name();
        gen.writeStringField("entityType", entityType);
        UUID id = null;
        if (value.getId() != null) {
            id = value.getId();
        } else if (value.defaultEntityId() != null) {
            id = value.defaultEntityId().getId();
        }
        if (id != null) {
            gen.writeStringField("id", id.toString());
        }
        gen.writeEndObject();
    }
}

