/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.query.AliasEntityIdDeserializer;
import org.thingsboard.server.common.data.query.AliasEntityIdImpl;
import org.thingsboard.server.common.data.query.AliasEntityIdSerializer;
import org.thingsboard.server.common.data.query.AliasEntityType;

@JsonDeserialize(using=AliasEntityIdDeserializer.class)
@JsonSerialize(using=AliasEntityIdSerializer.class)
@Schema
public interface AliasEntityId
extends EntityId {
    public AliasEntityType getAliasEntityType();

    public EntityId defaultEntityId();

    public EntityId toEntityId();

    @JsonIgnore
    default public boolean isAliasEntityId() {
        return this.getAliasEntityType() != null;
    }

    public static AliasEntityId fromEntityId(EntityId entityId) {
        if (entityId != null) {
            return new AliasEntityIdImpl(entityId);
        }
        return null;
    }

    public static AliasEntityId resolveAliasEntityId(AliasEntityId aliasEntityId, TenantId tenantId, UserId userId, EntityId userOwnerId) {
        if (aliasEntityId != null) {
            if (aliasEntityId.isAliasEntityId()) {
                AliasEntityType aliasEntityType = aliasEntityId.getAliasEntityType();
                switch (aliasEntityType) {
                    case CURRENT_CUSTOMER: {
                        if (EntityType.CUSTOMER.equals((Object)userOwnerId.getEntityType())) {
                            return AliasEntityId.fromEntityId(userOwnerId);
                        }
                        return AliasEntityId.fromEntityId(aliasEntityId.defaultEntityId());
                    }
                    case CURRENT_TENANT: {
                        return AliasEntityId.fromEntityId(tenantId);
                    }
                    case CURRENT_USER: {
                        return AliasEntityId.fromEntityId(userId);
                    }
                    case CURRENT_USER_OWNER: {
                        return AliasEntityId.fromEntityId(userOwnerId);
                    }
                }
            } else {
                return aliasEntityId;
            }
        }
        return null;
    }
}

