/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.security.Authority;

public enum Resource {
    ALL,
    PROFILE,
    ADMIN_SETTINGS(EntityType.ADMIN_SETTINGS),
    ALARM(EntityType.ALARM),
    DEVICE(EntityType.DEVICE),
    ASSET(EntityType.ASSET),
    CUSTOMER(EntityType.CUSTOMER),
    DASHBOARD(EntityType.DASHBOARD),
    ENTITY_VIEW(EntityType.ENTITY_VIEW),
    EDGE(EntityType.EDGE),
    TENANT(EntityType.TENANT),
    RULE_CHAIN(EntityType.RULE_CHAIN),
    USER(EntityType.USER),
    WIDGETS_BUNDLE(EntityType.WIDGETS_BUNDLE),
    WIDGET_TYPE(EntityType.WIDGET_TYPE),
    OAUTH2_CLIENT(EntityType.OAUTH2_CLIENT),
    DOMAIN(EntityType.DOMAIN),
    MOBILE_APP(EntityType.MOBILE_APP),
    MOBILE_APP_BUNDLE(EntityType.MOBILE_APP_BUNDLE),
    OAUTH2_CONFIGURATION_TEMPLATE,
    TENANT_PROFILE(EntityType.TENANT_PROFILE),
    DEVICE_PROFILE(EntityType.DEVICE_PROFILE),
    ASSET_PROFILE(EntityType.ASSET_PROFILE),
    CONVERTER(EntityType.CONVERTER),
    INTEGRATION(EntityType.INTEGRATION),
    SCHEDULER_EVENT(EntityType.SCHEDULER_EVENT),
    BLOB_ENTITY(EntityType.BLOB_ENTITY),
    CUSTOMER_GROUP(EntityType.ENTITY_GROUP),
    DEVICE_GROUP(EntityType.ENTITY_GROUP),
    ASSET_GROUP(EntityType.ENTITY_GROUP),
    USER_GROUP(EntityType.ENTITY_GROUP),
    ENTITY_VIEW_GROUP(EntityType.ENTITY_GROUP),
    EDGE_GROUP(EntityType.ENTITY_GROUP),
    DASHBOARD_GROUP(EntityType.ENTITY_GROUP),
    ROLE(EntityType.ROLE),
    GROUP_PERMISSION(EntityType.GROUP_PERMISSION),
    WHITE_LABELING,
    AUDIT_LOG,
    API_USAGE_STATE(EntityType.API_USAGE_STATE),
    TB_RESOURCE(EntityType.TB_RESOURCE),
    OTA_PACKAGE(EntityType.OTA_PACKAGE),
    QUEUE(EntityType.QUEUE),
    QUEUE_STATS(EntityType.QUEUE_STATS),
    VERSION_CONTROL,
    NOTIFICATION(EntityType.NOTIFICATION_TARGET, EntityType.NOTIFICATION_TEMPLATE, EntityType.NOTIFICATION_REQUEST, EntityType.NOTIFICATION_RULE),
    MOBILE_APP_SETTINGS,
    CUSTOM_MENU,
    JOB(EntityType.JOB),
    SECRET(EntityType.SECRET),
    REPORT_TEMPLATE(EntityType.REPORT_TEMPLATE),
    REPORT(EntityType.REPORT),
    AI_MODEL(EntityType.AI_MODEL);

    private static final Map<EntityType, Resource> groupResourceByGroupType;
    private static final Map<EntityType, Resource> resourceByEntityType;
    public static final Map<Resource, Set<Operation>> operationsByResource;
    public static final Map<Authority, Set<Resource>> resourcesByAuthority;
    private final Set<EntityType> entityTypes;

    public static Resource groupResourceFromGroupType(EntityType groupType) {
        return groupResourceByGroupType.get((Object)groupType);
    }

    public static Resource resourceFromEntityType(EntityType entityType) {
        return resourceByEntityType.get((Object)entityType);
    }

    public static Set<Operation> operationsForResource(Resource resource) {
        return operationsByResource.get((Object)resource);
    }

    private Resource() {
        this.entityTypes = Collections.emptySet();
    }

    private Resource(EntityType ... entityTypes) {
        this.entityTypes = Set.of(entityTypes);
    }

    public Set<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    static {
        groupResourceByGroupType = new HashMap<EntityType, Resource>();
        resourceByEntityType = new HashMap<EntityType, Resource>();
        operationsByResource = new HashMap<Resource, Set<Operation>>();
        resourcesByAuthority = new HashMap<Authority, Set<Resource>>();
        groupResourceByGroupType.put(EntityType.CUSTOMER, CUSTOMER_GROUP);
        groupResourceByGroupType.put(EntityType.DEVICE, DEVICE_GROUP);
        groupResourceByGroupType.put(EntityType.ASSET, ASSET_GROUP);
        groupResourceByGroupType.put(EntityType.USER, USER_GROUP);
        groupResourceByGroupType.put(EntityType.ENTITY_VIEW, ENTITY_VIEW_GROUP);
        groupResourceByGroupType.put(EntityType.EDGE, EDGE_GROUP);
        groupResourceByGroupType.put(EntityType.DASHBOARD, DASHBOARD_GROUP);
        for (EntityType entityType : EntityType.values()) {
            if (entityType.equals((Object)EntityType.ENTITY_GROUP)) continue;
            for (Resource resource : Resource.values()) {
                if (!resource.getEntityTypes().contains((Object)entityType)) continue;
                resourceByEntityType.put(entityType, resource);
            }
        }
        operationsByResource.put(ALL, Set.of(Operation.values()));
        operationsByResource.put(PROFILE, Set.of(Operation.ALL, Operation.WRITE));
        operationsByResource.put(ADMIN_SETTINGS, Set.of(Operation.ALL, Operation.READ, Operation.WRITE));
        operationsByResource.put(OAUTH2_CLIENT, Operation.crudOperations);
        operationsByResource.put(DOMAIN, Operation.crudOperations);
        operationsByResource.put(MOBILE_APP, Operation.crudOperations);
        operationsByResource.put(MOBILE_APP_BUNDLE, Operation.crudOperations);
        operationsByResource.put(OAUTH2_CONFIGURATION_TEMPLATE, Operation.crudOperations);
        operationsByResource.put(ALARM, Set.of(Operation.ALL, Operation.READ, Operation.WRITE, Operation.CREATE));
        operationsByResource.put(DEVICE, Set.of(Operation.ALL, Operation.READ, Operation.WRITE, Operation.CREATE, Operation.DELETE, Operation.RPC_CALL, Operation.READ_CREDENTIALS, Operation.WRITE_CREDENTIALS, Operation.READ_ATTRIBUTES, Operation.WRITE_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_TELEMETRY, Operation.CLAIM_DEVICES, Operation.CHANGE_OWNER, Operation.ASSIGN_TO_TENANT, Operation.READ_CALCULATED_FIELD, Operation.WRITE_CALCULATED_FIELD));
        operationsByResource.put(DEVICE_PROFILE, Operation.defaultCFEntityOperations);
        operationsByResource.put(ASSET_PROFILE, Operation.defaultCFEntityOperations);
        operationsByResource.put(OTA_PACKAGE, Operation.defaultEntityOperations);
        operationsByResource.put(ASSET, Operation.defaultCFEntityOperations);
        operationsByResource.put(CUSTOMER, Operation.defaultEntityOperations);
        operationsByResource.put(DASHBOARD, Operation.defaultEntityOperations);
        operationsByResource.put(ENTITY_VIEW, Operation.defaultEntityOperations);
        operationsByResource.put(EDGE, Operation.defaultEntityOperations);
        operationsByResource.put(TENANT, Operation.defaultEntityOperations);
        operationsByResource.put(TENANT_PROFILE, Operation.defaultEntityOperations);
        operationsByResource.put(API_USAGE_STATE, Set.of(Operation.ALL, Operation.READ, Operation.READ_TELEMETRY));
        operationsByResource.put(RULE_CHAIN, Operation.defaultEntityOperations);
        HashSet<Operation> userOperations = new HashSet<Operation>(Operation.defaultEntityOperations);
        userOperations.add(Operation.IMPERSONATE);
        operationsByResource.put(USER, userOperations);
        operationsByResource.put(WIDGETS_BUNDLE, Operation.crudOperations);
        operationsByResource.put(WIDGET_TYPE, Operation.crudOperations);
        operationsByResource.put(TB_RESOURCE, Operation.defaultEntityOperations);
        operationsByResource.put(CONVERTER, Operation.defaultEntityOperations);
        operationsByResource.put(INTEGRATION, Operation.defaultEntityOperations);
        operationsByResource.put(SCHEDULER_EVENT, Operation.defaultEntityOperations);
        operationsByResource.put(BLOB_ENTITY, Operation.defaultEntityOperations);
        operationsByResource.put(CUSTOMER_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(DEVICE_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ASSET_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(USER_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ENTITY_VIEW_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(EDGE_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(DASHBOARD_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ROLE, Operation.defaultEntityOperations);
        operationsByResource.put(GROUP_PERMISSION, Operation.crudOperations);
        operationsByResource.put(WHITE_LABELING, Set.of(Operation.ALL, Operation.READ, Operation.WRITE));
        operationsByResource.put(AUDIT_LOG, Set.of(Operation.ALL, Operation.READ));
        operationsByResource.put(QUEUE, Set.of(Operation.ALL, Operation.READ));
        operationsByResource.put(QUEUE_STATS, Set.of(Operation.ALL, Operation.READ));
        operationsByResource.put(VERSION_CONTROL, Set.of(Operation.ALL, Operation.READ, Operation.WRITE, Operation.DELETE));
        operationsByResource.put(NOTIFICATION, Operation.crudOperations);
        operationsByResource.put(MOBILE_APP_SETTINGS, Set.of(Operation.ALL, Operation.READ, Operation.WRITE));
        operationsByResource.put(JOB, Operation.crudOperations);
        operationsByResource.put(SECRET, Operation.crudOperations);
        operationsByResource.put(REPORT_TEMPLATE, Operation.crudOperations);
        operationsByResource.put(REPORT, Operation.crudOperations);
        operationsByResource.put(AI_MODEL, Operation.crudOperations);
        resourcesByAuthority.put(Authority.SYS_ADMIN, Set.of(ALL, PROFILE, ADMIN_SETTINGS, DASHBOARD, ALARM, TENANT, TENANT_PROFILE, USER, WIDGETS_BUNDLE, WIDGET_TYPE, ROLE, WHITE_LABELING, OAUTH2_CLIENT, DOMAIN, MOBILE_APP, MOBILE_APP_BUNDLE, OAUTH2_CONFIGURATION_TEMPLATE, TB_RESOURCE, QUEUE, QUEUE_STATS, NOTIFICATION, MOBILE_APP_SETTINGS, SECRET));
        resourcesByAuthority.put(Authority.TENANT_ADMIN, Set.of(ALL, PROFILE, ALARM, DEVICE, DEVICE_PROFILE, ASSET_PROFILE, API_USAGE_STATE, ASSET, ENTITY_VIEW, EDGE, CUSTOMER, DASHBOARD, TENANT, USER, WIDGETS_BUNDLE, WIDGET_TYPE, RULE_CHAIN, ROLE, CONVERTER, INTEGRATION, SCHEDULER_EVENT, BLOB_ENTITY, CUSTOMER_GROUP, USER_GROUP, DEVICE_GROUP, ASSET_GROUP, DASHBOARD_GROUP, ENTITY_VIEW_GROUP, EDGE_GROUP, GROUP_PERMISSION, WHITE_LABELING, OAUTH2_CLIENT, DOMAIN, MOBILE_APP, MOBILE_APP_BUNDLE, AUDIT_LOG, TB_RESOURCE, OTA_PACKAGE, QUEUE, QUEUE_STATS, VERSION_CONTROL, NOTIFICATION, MOBILE_APP_SETTINGS, SECRET, JOB, REPORT_TEMPLATE, REPORT, AI_MODEL));
        resourcesByAuthority.put(Authority.CUSTOMER_USER, Set.of(ALL, PROFILE, ALARM, DEVICE, ASSET, ENTITY_VIEW, EDGE, CUSTOMER, DASHBOARD, USER, WIDGETS_BUNDLE, WIDGET_TYPE, ROLE, SCHEDULER_EVENT, BLOB_ENTITY, CUSTOMER_GROUP, USER_GROUP, DEVICE_GROUP, ASSET_GROUP, DASHBOARD_GROUP, ENTITY_VIEW_GROUP, EDGE_GROUP, GROUP_PERMISSION, WHITE_LABELING, DOMAIN, OAUTH2_CLIENT, AUDIT_LOG, DEVICE_PROFILE, ASSET_PROFILE, MOBILE_APP_SETTINGS, REPORT_TEMPLATE, REPORT));
    }
}

