/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.query.EntitiesByGroupNameFilter;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityFilterType;
import org.thingsboard.server.common.data.query.EntityGroupFilter;
import org.thingsboard.server.common.data.query.EntityGroupListFilter;
import org.thingsboard.server.common.data.query.EntityGroupNameFilter;

public class QueryContext {
    private final TenantId tenantId;
    private final CustomerId customerId;
    private final EntityType entityType;
    private final boolean ignorePermissionCheck;
    private final MergedUserPermissions userPermissions;
    private final EntityFilter entityFilter;
    private final EntityId ownerId;
    private final EntityType entityGroupType;
    private final Map<UUID, UUID> relatedParentIdMap = new HashMap<UUID, UUID>();

    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, MergedUserPermissions userPermissions, EntityFilter entityFilter) {
        this(tenantId, customerId, entityType, userPermissions, entityFilter, null, null, false);
    }

    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, MergedUserPermissions userPermissions, EntityFilter entityFilter, boolean ignorePermissionCheck) {
        this(tenantId, customerId, entityType, userPermissions, entityFilter, null, null, ignorePermissionCheck);
    }

    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, MergedUserPermissions userPermissions, EntityFilter entityFilter, EntityId ownerId, boolean ignorePermissionCheck) {
        this(tenantId, customerId, entityType, userPermissions, entityFilter, ownerId, null, ignorePermissionCheck);
    }

    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, MergedUserPermissions userPermissions, EntityFilter entityFilter, EntityType entityGroupType, boolean ignorePermissionCheck) {
        this(tenantId, customerId, entityType, userPermissions, entityFilter, null, entityGroupType, ignorePermissionCheck);
    }

    private QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, MergedUserPermissions userPermissions, EntityFilter entityFilter, EntityId ownerId, EntityType entityGroupType, boolean ignorePermissionCheck) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.entityType = entityType;
        this.userPermissions = ignorePermissionCheck ? new MergedUserPermissions(Collections.singletonMap(Resource.ALL, Collections.singleton(Operation.ALL)), Collections.emptyMap()) : userPermissions;
        this.entityFilter = entityFilter;
        this.ownerId = ownerId;
        this.entityGroupType = entityGroupType;
        this.ignorePermissionCheck = ignorePermissionCheck;
    }

    public boolean isTenantUser() {
        return this.customerId == null || this.customerId.isNullUid();
    }

    public boolean hasGeneric(Operation operation) {
        return this.userPermissions.hasGenericPermission(Resource.resourceFromEntityType(this.entityType), operation);
    }

    public MergedGroupTypePermissionInfo getMergedReadPermissionsByEntityType() {
        return this.userPermissions.getReadEntityPermissions().get((Object)this.getResource());
    }

    public MergedGroupTypePermissionInfo getMergedReadGroupPermissionsByEntityType() {
        return this.userPermissions.getReadGroupPermissions().get((Object)this.entityType);
    }

    public EntityType getEntityType() {
        EntityType entityType;
        if (this.entityFilter != null) {
            entityType = switch (this.entityFilter.getType()) {
                case EntityFilterType.ENTITY_GROUP_NAME -> ((EntityGroupNameFilter)this.entityFilter).getGroupType();
                case EntityFilterType.ENTITIES_BY_GROUP_NAME -> ((EntitiesByGroupNameFilter)this.entityFilter).getGroupType();
                case EntityFilterType.ENTITY_GROUP -> ((EntityGroupFilter)this.entityFilter).getGroupType();
                default -> this.entityType;
            };
        } else {
            entityType = this.entityType;
        }
        return entityType;
    }

    private Resource getResource() {
        if (this.entityFilter != null) {
            switch (this.entityFilter.getType()) {
                case ENTITY_GROUP_NAME: {
                    return Resource.groupResourceFromGroupType(((EntityGroupNameFilter)this.entityFilter).getGroupType());
                }
                case ENTITY_GROUP_LIST: {
                    return Resource.groupResourceFromGroupType(((EntityGroupListFilter)this.entityFilter).getGroupType());
                }
            }
        }
        if (this.entityGroupType != null) {
            return Resource.groupResourceFromGroupType(this.entityGroupType);
        }
        return Resource.resourceFromEntityType(this.entityType);
    }

    public MergedGroupTypePermissionInfo getMergedReadAttrPermissionsByEntityType() {
        return this.userPermissions.getReadAttrPermissions().get((Object)this.getResource());
    }

    public MergedGroupTypePermissionInfo getMergedReadTsPermissionsByEntityType() {
        return this.userPermissions.getReadTsPermissions().get((Object)this.getResource());
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getMergedReadEntityPermissionsMap() {
        return this.userPermissions.getReadEntityPermissions();
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getMergedReadAttrPermissionsMap() {
        return this.userPermissions.getReadAttrPermissions();
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getMergedReadTsPermissionsMap() {
        return this.userPermissions.getReadTsPermissions();
    }

    public boolean isEntityGroup() {
        return EntityType.ENTITY_GROUP.equals((Object)this.entityType) || EntityFilterType.ENTITY_GROUP_NAME.equals((Object)this.entityFilter.getType()) || EntityFilterType.ENTITY_GROUP_LIST.equals((Object)this.entityFilter.getType());
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public boolean isIgnorePermissionCheck() {
        return this.ignorePermissionCheck;
    }

    @Generated
    public EntityId getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public EntityType getEntityGroupType() {
        return this.entityGroupType;
    }

    @Generated
    public Map<UUID, UUID> getRelatedParentIdMap() {
        return this.relatedParentIdMap;
    }
}

