/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public enum Operation {
    ALL(true),
    CREATE(true, true, true),
    READ(true),
    WRITE(true, false, true),
    DELETE(true, true, true),
    RPC_CALL(true),
    READ_CREDENTIALS(true),
    WRITE_CREDENTIALS(true),
    READ_ATTRIBUTES(true),
    WRITE_ATTRIBUTES(true, false, true),
    READ_TELEMETRY(true),
    WRITE_TELEMETRY(true, false, true),
    ADD_TO_GROUP,
    REMOVE_FROM_GROUP,
    CHANGE_OWNER,
    IMPERSONATE,
    CLAIM_DEVICES,
    SHARE_GROUP(true),
    ASSIGN_TO_TENANT,
    READ_CALCULATED_FIELD,
    WRITE_CALCULATED_FIELD;

    public static Set<Operation> defaultEntityOperations;
    public static Set<Operation> defaultEntityGroupOperations;
    public static Set<Operation> crudOperations;
    public static Set<Operation> allowedForGroupRoleOperations;
    public static Set<Operation> allowedForGroupOwnerOnlyOperations;
    public static Set<Operation> allowedForGroupOwnerOnlyGroupOperations;
    public static Set<Operation> defaultCFEntityOperations;
    private boolean allowedForGroupRole;
    private boolean allowedForGroupOwnerOnly;
    private boolean groupOperationAllowedForGroupOwnerOnly;

    private Operation() {
        this(false, false, false);
    }

    private Operation(boolean allowedForGroupRole) {
        this(allowedForGroupRole, false, false);
    }

    private Operation(boolean allowedForGroupRole, boolean allowedForGroupOwnerOnly) {
        this(allowedForGroupRole, allowedForGroupOwnerOnly, false);
    }

    private Operation(boolean allowedForGroupRole, boolean allowedForGroupOwnerOnly, boolean groupOperationAllowedForGroupOwnerOnly) {
        this.allowedForGroupRole = allowedForGroupRole;
        this.allowedForGroupOwnerOnly = allowedForGroupOwnerOnly;
        this.groupOperationAllowedForGroupOwnerOnly = groupOperationAllowedForGroupOwnerOnly;
    }

    @Generated
    public boolean isAllowedForGroupRole() {
        return this.allowedForGroupRole;
    }

    @Generated
    public boolean isAllowedForGroupOwnerOnly() {
        return this.allowedForGroupOwnerOnly;
    }

    @Generated
    public boolean isGroupOperationAllowedForGroupOwnerOnly() {
        return this.groupOperationAllowedForGroupOwnerOnly;
    }

    static {
        defaultEntityOperations = new HashSet<Operation>(Arrays.asList(ALL, READ, WRITE, CREATE, DELETE, READ_ATTRIBUTES, WRITE_ATTRIBUTES, READ_TELEMETRY, WRITE_TELEMETRY, CHANGE_OWNER));
        defaultEntityGroupOperations = new HashSet<Operation>(Arrays.asList(ALL, READ, WRITE, CREATE, DELETE, READ_ATTRIBUTES, WRITE_ATTRIBUTES, READ_TELEMETRY, WRITE_TELEMETRY, ADD_TO_GROUP, REMOVE_FROM_GROUP, SHARE_GROUP));
        crudOperations = new HashSet<Operation>(Arrays.asList(ALL, READ, WRITE, CREATE, DELETE));
        allowedForGroupRoleOperations = new HashSet<Operation>();
        for (Operation operation : Operation.values()) {
            if (!operation.isAllowedForGroupRole()) continue;
            allowedForGroupRoleOperations.add(operation);
        }
        allowedForGroupOwnerOnlyOperations = new HashSet<Operation>();
        for (Operation operation : Operation.values()) {
            if (!operation.isAllowedForGroupOwnerOnly()) continue;
            allowedForGroupOwnerOnlyOperations.add(operation);
        }
        allowedForGroupOwnerOnlyGroupOperations = new HashSet<Operation>();
        for (Operation operation : Operation.values()) {
            if (!operation.isGroupOperationAllowedForGroupOwnerOnly()) continue;
            allowedForGroupOwnerOnlyGroupOperations.add(operation);
        }
        defaultCFEntityOperations = new HashSet<Operation>(defaultEntityOperations);
        defaultCFEntityOperations.add(READ_CALCULATED_FIELD);
        defaultCFEntityOperations.add(WRITE_CALCULATED_FIELD);
    }
}

