/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.permission.MergedGroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;

@Schema
public final class MergedUserPermissions
implements Serializable {
    @Schema(description="Map of permissions defined using generic roles ('Customer Administrator', etc)")
    private final Map<Resource, Set<Operation>> genericPermissions;
    @Schema(description="Map of permissions defined using group roles ('Read' or 'Write' access to specific entity group, etc)")
    private final Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions;
    @Schema(description="Map of read permissions per entity type. Used on the UI to enable/disable certain components.")
    private final Map<EntityType, MergedGroupTypePermissionInfo> readGroupPermissions;
    @Schema(description="Map of read permissions per resource. Used on the UI to enable/disable certain components.")
    private final Map<Resource, MergedGroupTypePermissionInfo> readEntityPermissions;
    @Schema(description="Map of read entity attributes permissions per resource. Used on the UI to enable/disable certain tabs.")
    private final Map<Resource, MergedGroupTypePermissionInfo> readAttrPermissions;
    @Schema(description="Map of read entity time-series permissions per resource. Used on the UI to enable/disable certain tabs.")
    private final Map<Resource, MergedGroupTypePermissionInfo> readTsPermissions;
    public static final MergedUserPermissions ALL = new MergedUserPermissions(Map.of(Resource.ALL, Set.of(Operation.ALL)), Collections.emptyMap());

    @JsonCreator
    public MergedUserPermissions(@JsonProperty(value="genericPermissions") Map<Resource, Set<Operation>> genericPermissions, @JsonProperty(value="groupPermissions") Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions) {
        boolean hasGenericRead;
        Resource resource;
        this.genericPermissions = genericPermissions;
        this.groupPermissions = groupPermissions;
        this.readGroupPermissions = new HashMap<EntityType, MergedGroupTypePermissionInfo>();
        this.readEntityPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        this.readAttrPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        this.readTsPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        for (EntityType groupType : EntityGroup.groupTypes) {
            resource = Resource.groupResourceFromGroupType(groupType);
            hasGenericRead = this.hasGenericPermission(resource, Operation.READ);
            this.readGroupPermissions.put(groupType, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericRead));
            this.readEntityPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericRead));
            boolean hasGenericAttrRead = this.hasGenericPermission(resource, Operation.READ_ATTRIBUTES);
            this.readAttrPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericAttrRead));
            boolean hasGenericTsRead = this.hasGenericPermission(resource, Operation.READ_TELEMETRY);
            this.readTsPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericTsRead));
        }
        for (EntityType entityType : EntityType.values()) {
            resource = Resource.resourceFromEntityType(entityType);
            if (resource == null) continue;
            hasGenericRead = this.hasGenericPermission(resource, Operation.READ);
            this.readEntityPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericRead));
            boolean hasGenericReadAttributes = this.hasGenericPermission(resource, Operation.READ_ATTRIBUTES);
            this.readAttrPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericReadAttributes));
            boolean hasGenericReadTelemetry = this.hasGenericPermission(resource, Operation.READ_TELEMETRY);
            this.readTsPermissions.put(resource, MergedGroupTypePermissionInfo.ofEmptyGroups(hasGenericReadTelemetry));
        }
        if (!this.groupPermissions.isEmpty()) {
            HashMap readGroupPermissionIds = new HashMap();
            HashMap readEntityPermissionIds = new HashMap();
            HashMap readAttrPermissionIds = new HashMap();
            HashMap readTsPermissionIds = new HashMap();
            this.groupPermissions.forEach((id, info) -> {
                Resource groupResource;
                Resource entityResource;
                if (this.checkOperation(info.getOperations(), Operation.READ)) {
                    readGroupPermissionIds.computeIfAbsent(info.getEntityType(), et -> new ArrayList()).add(id);
                    entityResource = Resource.resourceFromEntityType(info.getEntityType());
                    readEntityPermissionIds.computeIfAbsent(entityResource, et -> new ArrayList()).add(id);
                    groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                    if (groupResource != null) {
                        readEntityPermissionIds.computeIfAbsent(groupResource, et -> new ArrayList()).add(id);
                    }
                }
                if (this.checkOperation(info.getOperations(), Operation.READ_ATTRIBUTES)) {
                    entityResource = Resource.resourceFromEntityType(info.getEntityType());
                    readAttrPermissionIds.computeIfAbsent(entityResource, et -> new ArrayList()).add(id);
                    groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                    if (groupResource != null) {
                        readAttrPermissionIds.computeIfAbsent(groupResource, et -> new ArrayList()).add(id);
                    }
                }
                if (this.checkOperation(info.getOperations(), Operation.READ_TELEMETRY)) {
                    entityResource = Resource.resourceFromEntityType(info.getEntityType());
                    readTsPermissionIds.computeIfAbsent(entityResource, et -> new ArrayList()).add(id);
                    groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                    if (groupResource != null) {
                        readTsPermissionIds.computeIfAbsent(groupResource, et -> new ArrayList()).add(id);
                    }
                }
            });
            this.addIds(this.readGroupPermissions, readGroupPermissionIds);
            this.addIds(this.readEntityPermissions, readEntityPermissionIds);
            this.addIds(this.readAttrPermissions, readAttrPermissionIds);
            this.addIds(this.readTsPermissions, readTsPermissionIds);
        }
    }

    <T> void addIds(Map<T, MergedGroupTypePermissionInfo> permissions, Map<T, List<EntityGroupId>> ids) {
        ids.forEach((key, value) -> {
            MergedGroupTypePermissionInfo mergedGroupTypePermissionInfo = (MergedGroupTypePermissionInfo)permissions.get(key);
            MergedGroupTypePermissionInfo newInfo = mergedGroupTypePermissionInfo.addIds((List<EntityGroupId>)value);
            permissions.put(key, newInfo);
        });
    }

    public MergedGroupTypePermissionInfo getGroupPermissionsByEntityTypeAndOperation(EntityType entityType, Operation operation) {
        Resource resource = Resource.resourceFromEntityType(entityType);
        boolean hasGenericPermission = this.hasGenericPermission(resource, operation);
        List<EntityGroupId> groupIds = this.groupPermissions.entrySet().stream().filter(entry -> ((MergedGroupPermissionInfo)entry.getValue()).getEntityType().equals((Object)entityType) && this.checkOperation(((MergedGroupPermissionInfo)entry.getValue()).getOperations(), operation)).map(Map.Entry::getKey).collect(Collectors.toList());
        return new MergedGroupTypePermissionInfo(groupIds, hasGenericPermission);
    }

    public boolean hasGenericPermission(Resource resource, Operation operation) {
        return this.hasGenericResourcePermission(resource, operation) || this.hasGenericAllPermission(operation);
    }

    private boolean hasGenericAllPermission(Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)Resource.ALL);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean hasGenericResourcePermission(Resource resource, Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)resource);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean checkOperation(Set<Operation> operations, Operation operation) {
        return operations.contains((Object)Operation.ALL) || operations.contains((Object)operation);
    }

    public boolean hasGroupPermissions(EntityGroupId entityGroupId, Operation operation) {
        MergedGroupPermissionInfo permissionInfo = this.groupPermissions.get(entityGroupId);
        return permissionInfo != null && this.checkOperation(permissionInfo.getOperations(), operation);
    }

    @Generated
    public Map<Resource, Set<Operation>> getGenericPermissions() {
        return this.genericPermissions;
    }

    @Generated
    public Map<EntityGroupId, MergedGroupPermissionInfo> getGroupPermissions() {
        return this.groupPermissions;
    }

    @Generated
    public Map<EntityType, MergedGroupTypePermissionInfo> getReadGroupPermissions() {
        return this.readGroupPermissions;
    }

    @Generated
    public Map<Resource, MergedGroupTypePermissionInfo> getReadEntityPermissions() {
        return this.readEntityPermissions;
    }

    @Generated
    public Map<Resource, MergedGroupTypePermissionInfo> getReadAttrPermissions() {
        return this.readAttrPermissions;
    }

    @Generated
    public Map<Resource, MergedGroupTypePermissionInfo> getReadTsPermissions() {
        return this.readTsPermissions;
    }
}

