/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityGroupId;

@Schema
public class MergedGroupTypePermissionInfo {
    public static final MergedGroupTypePermissionInfo MERGED_GROUP_TYPE_PERMISSION_INFO_EMPTY_GROUPS_HAS_GENERIC_READ_TRUE = new MergedGroupTypePermissionInfo(Collections.emptyList(), true);
    public static final MergedGroupTypePermissionInfo MERGED_GROUP_TYPE_PERMISSION_INFO_EMPTY_GROUPS_HAS_GENERIC_READ_FALSE = new MergedGroupTypePermissionInfo(Collections.emptyList(), false);
    @Schema(description="List of Entity Groups in case of group roles are assigned to the user (user group)")
    private final List<EntityGroupId> entityGroupIds;
    @Schema(description="Indicates if generic permission assigned to the user group.")
    private final boolean hasGenericRead;

    public MergedGroupTypePermissionInfo(List<EntityGroupId> entityGroupIds, boolean hasGenericRead) {
        this.entityGroupIds = entityGroupIds == null ? null : List.copyOf(entityGroupIds);
        this.hasGenericRead = hasGenericRead;
    }

    public static MergedGroupTypePermissionInfo ofEmptyGroups(boolean hasGenericRead) {
        return hasGenericRead ? MERGED_GROUP_TYPE_PERMISSION_INFO_EMPTY_GROUPS_HAS_GENERIC_READ_TRUE : MERGED_GROUP_TYPE_PERMISSION_INFO_EMPTY_GROUPS_HAS_GENERIC_READ_FALSE;
    }

    public MergedGroupTypePermissionInfo addId(EntityGroupId id) {
        if (this.entityGroupIds == null || this.entityGroupIds.isEmpty()) {
            return new MergedGroupTypePermissionInfo(List.of(id), this.hasGenericRead);
        }
        ArrayList<EntityGroupId> mergedList = new ArrayList<EntityGroupId>(this.entityGroupIds.size() + 1);
        mergedList.addAll(this.entityGroupIds);
        mergedList.add(id);
        return new MergedGroupTypePermissionInfo(mergedList, this.hasGenericRead);
    }

    public MergedGroupTypePermissionInfo addIds(List<EntityGroupId> ids) {
        if (this.entityGroupIds == null || this.entityGroupIds.isEmpty()) {
            return new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(ids), this.hasGenericRead);
        }
        LinkedHashSet<EntityGroupId> result = new LinkedHashSet<EntityGroupId>();
        result.addAll(this.entityGroupIds);
        result.addAll(ids);
        return new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(result), this.hasGenericRead);
    }

    @Generated
    public List<EntityGroupId> getEntityGroupIds() {
        return this.entityGroupIds;
    }

    @Generated
    public boolean isHasGenericRead() {
        return this.hasGenericRead;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergedGroupTypePermissionInfo)) {
            return false;
        }
        MergedGroupTypePermissionInfo other = (MergedGroupTypePermissionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasGenericRead() != other.isHasGenericRead()) {
            return false;
        }
        List<EntityGroupId> this$entityGroupIds = this.getEntityGroupIds();
        List<EntityGroupId> other$entityGroupIds = other.getEntityGroupIds();
        return !(this$entityGroupIds == null ? other$entityGroupIds != null : !((Object)this$entityGroupIds).equals(other$entityGroupIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MergedGroupTypePermissionInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasGenericRead() ? 79 : 97);
        List<EntityGroupId> $entityGroupIds = this.getEntityGroupIds();
        result = result * 59 + ($entityGroupIds == null ? 43 : ((Object)$entityGroupIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MergedGroupTypePermissionInfo(entityGroupIds=" + String.valueOf(this.getEntityGroupIds()) + ", hasGenericRead=" + this.isHasGenericRead() + ")";
    }
}

