/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;

@Schema
public class AllowedPermissionsInfo {
    @Schema(description="Static map (vocabulary) of allowed operations by resource type")
    private Map<Resource, Set<Operation>> operationsByResource;
    @Schema(description="Static set (vocabulary) of allowed operations for group roles")
    private Set<Operation> allowedForGroupRoleOperations;
    @Schema(description="Static set (vocabulary) of allowed operations for group owner")
    private Set<Operation> allowedForGroupOwnerOnlyOperations;
    @Schema(description="Static set (vocabulary) of allowed group operations for group owner")
    private Set<Operation> allowedForGroupOwnerOnlyGroupOperations;
    @Schema(description="Static set (vocabulary) of all possibly allowed resources. Static and depends only on the authority of the user")
    private Set<Resource> allowedResources;
    @Schema(description="JSON object with merged permission for all generic and group roles assigned to all user groups the user belongs to")
    private MergedUserPermissions userPermissions;
    @Schema(description="Owner Id of the user (Tenant or Customer)")
    private EntityId userOwnerId;

    @Generated
    public Map<Resource, Set<Operation>> getOperationsByResource() {
        return this.operationsByResource;
    }

    @Generated
    public Set<Operation> getAllowedForGroupRoleOperations() {
        return this.allowedForGroupRoleOperations;
    }

    @Generated
    public Set<Operation> getAllowedForGroupOwnerOnlyOperations() {
        return this.allowedForGroupOwnerOnlyOperations;
    }

    @Generated
    public Set<Operation> getAllowedForGroupOwnerOnlyGroupOperations() {
        return this.allowedForGroupOwnerOnlyGroupOperations;
    }

    @Generated
    public Set<Resource> getAllowedResources() {
        return this.allowedResources;
    }

    @Generated
    public MergedUserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    @Generated
    public EntityId getUserOwnerId() {
        return this.userOwnerId;
    }

    @Generated
    public void setOperationsByResource(Map<Resource, Set<Operation>> operationsByResource) {
        this.operationsByResource = operationsByResource;
    }

    @Generated
    public void setAllowedForGroupRoleOperations(Set<Operation> allowedForGroupRoleOperations) {
        this.allowedForGroupRoleOperations = allowedForGroupRoleOperations;
    }

    @Generated
    public void setAllowedForGroupOwnerOnlyOperations(Set<Operation> allowedForGroupOwnerOnlyOperations) {
        this.allowedForGroupOwnerOnlyOperations = allowedForGroupOwnerOnlyOperations;
    }

    @Generated
    public void setAllowedForGroupOwnerOnlyGroupOperations(Set<Operation> allowedForGroupOwnerOnlyGroupOperations) {
        this.allowedForGroupOwnerOnlyGroupOperations = allowedForGroupOwnerOnlyGroupOperations;
    }

    @Generated
    public void setAllowedResources(Set<Resource> allowedResources) {
        this.allowedResources = allowedResources;
    }

    @Generated
    public void setUserPermissions(MergedUserPermissions userPermissions) {
        this.userPermissions = userPermissions;
    }

    @Generated
    public void setUserOwnerId(EntityId userOwnerId) {
        this.userOwnerId = userOwnerId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowedPermissionsInfo)) {
            return false;
        }
        AllowedPermissionsInfo other = (AllowedPermissionsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Resource, Set<Operation>> this$operationsByResource = this.getOperationsByResource();
        Map<Resource, Set<Operation>> other$operationsByResource = other.getOperationsByResource();
        if (this$operationsByResource == null ? other$operationsByResource != null : !((Object)this$operationsByResource).equals(other$operationsByResource)) {
            return false;
        }
        Set<Operation> this$allowedForGroupRoleOperations = this.getAllowedForGroupRoleOperations();
        Set<Operation> other$allowedForGroupRoleOperations = other.getAllowedForGroupRoleOperations();
        if (this$allowedForGroupRoleOperations == null ? other$allowedForGroupRoleOperations != null : !((Object)this$allowedForGroupRoleOperations).equals(other$allowedForGroupRoleOperations)) {
            return false;
        }
        Set<Operation> this$allowedForGroupOwnerOnlyOperations = this.getAllowedForGroupOwnerOnlyOperations();
        Set<Operation> other$allowedForGroupOwnerOnlyOperations = other.getAllowedForGroupOwnerOnlyOperations();
        if (this$allowedForGroupOwnerOnlyOperations == null ? other$allowedForGroupOwnerOnlyOperations != null : !((Object)this$allowedForGroupOwnerOnlyOperations).equals(other$allowedForGroupOwnerOnlyOperations)) {
            return false;
        }
        Set<Operation> this$allowedForGroupOwnerOnlyGroupOperations = this.getAllowedForGroupOwnerOnlyGroupOperations();
        Set<Operation> other$allowedForGroupOwnerOnlyGroupOperations = other.getAllowedForGroupOwnerOnlyGroupOperations();
        if (this$allowedForGroupOwnerOnlyGroupOperations == null ? other$allowedForGroupOwnerOnlyGroupOperations != null : !((Object)this$allowedForGroupOwnerOnlyGroupOperations).equals(other$allowedForGroupOwnerOnlyGroupOperations)) {
            return false;
        }
        Set<Resource> this$allowedResources = this.getAllowedResources();
        Set<Resource> other$allowedResources = other.getAllowedResources();
        if (this$allowedResources == null ? other$allowedResources != null : !((Object)this$allowedResources).equals(other$allowedResources)) {
            return false;
        }
        MergedUserPermissions this$userPermissions = this.getUserPermissions();
        MergedUserPermissions other$userPermissions = other.getUserPermissions();
        if (this$userPermissions == null ? other$userPermissions != null : !this$userPermissions.equals(other$userPermissions)) {
            return false;
        }
        EntityId this$userOwnerId = this.getUserOwnerId();
        EntityId other$userOwnerId = other.getUserOwnerId();
        return !(this$userOwnerId == null ? other$userOwnerId != null : !this$userOwnerId.equals(other$userOwnerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowedPermissionsInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Resource, Set<Operation>> $operationsByResource = this.getOperationsByResource();
        result = result * 59 + ($operationsByResource == null ? 43 : ((Object)$operationsByResource).hashCode());
        Set<Operation> $allowedForGroupRoleOperations = this.getAllowedForGroupRoleOperations();
        result = result * 59 + ($allowedForGroupRoleOperations == null ? 43 : ((Object)$allowedForGroupRoleOperations).hashCode());
        Set<Operation> $allowedForGroupOwnerOnlyOperations = this.getAllowedForGroupOwnerOnlyOperations();
        result = result * 59 + ($allowedForGroupOwnerOnlyOperations == null ? 43 : ((Object)$allowedForGroupOwnerOnlyOperations).hashCode());
        Set<Operation> $allowedForGroupOwnerOnlyGroupOperations = this.getAllowedForGroupOwnerOnlyGroupOperations();
        result = result * 59 + ($allowedForGroupOwnerOnlyGroupOperations == null ? 43 : ((Object)$allowedForGroupOwnerOnlyGroupOperations).hashCode());
        Set<Resource> $allowedResources = this.getAllowedResources();
        result = result * 59 + ($allowedResources == null ? 43 : ((Object)$allowedResources).hashCode());
        MergedUserPermissions $userPermissions = this.getUserPermissions();
        result = result * 59 + ($userPermissions == null ? 43 : $userPermissions.hashCode());
        EntityId $userOwnerId = this.getUserOwnerId();
        result = result * 59 + ($userOwnerId == null ? 43 : $userOwnerId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AllowedPermissionsInfo(operationsByResource=" + String.valueOf(this.getOperationsByResource()) + ", allowedForGroupRoleOperations=" + String.valueOf(this.getAllowedForGroupRoleOperations()) + ", allowedForGroupOwnerOnlyOperations=" + String.valueOf(this.getAllowedForGroupOwnerOnlyOperations()) + ", allowedForGroupOwnerOnlyGroupOperations=" + String.valueOf(this.getAllowedForGroupOwnerOnlyGroupOperations()) + ", allowedResources=" + String.valueOf(this.getAllowedResources()) + ", userPermissions=" + String.valueOf(this.getUserPermissions()) + ", userOwnerId=" + String.valueOf(this.getUserOwnerId()) + ")";
    }

    @ConstructorProperties(value={"operationsByResource", "allowedForGroupRoleOperations", "allowedForGroupOwnerOnlyOperations", "allowedForGroupOwnerOnlyGroupOperations", "allowedResources", "userPermissions", "userOwnerId"})
    @Generated
    public AllowedPermissionsInfo(Map<Resource, Set<Operation>> operationsByResource, Set<Operation> allowedForGroupRoleOperations, Set<Operation> allowedForGroupOwnerOnlyOperations, Set<Operation> allowedForGroupOwnerOnlyGroupOperations, Set<Resource> allowedResources, MergedUserPermissions userPermissions, EntityId userOwnerId) {
        this.operationsByResource = operationsByResource;
        this.allowedForGroupRoleOperations = allowedForGroupRoleOperations;
        this.allowedForGroupOwnerOnlyOperations = allowedForGroupOwnerOnlyOperations;
        this.allowedForGroupOwnerOnlyGroupOperations = allowedForGroupOwnerOnlyGroupOperations;
        this.allowedResources = allowedResources;
        this.userPermissions = userPermissions;
        this.userOwnerId = userOwnerId;
    }
}

