/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema
public class PageData<T>
implements Serializable {
    public static final PageData EMPTY_PAGE_DATA = new PageData();
    private final List<T> data;
    private final int totalPages;
    private final long totalElements;
    private final boolean hasNext;

    public PageData() {
        this(Collections.emptyList(), 0, 0L, false);
    }

    @JsonCreator
    public PageData(@JsonProperty(value="data") List<T> data, @JsonProperty(value="totalPages") int totalPages, @JsonProperty(value="totalElements") long totalElements, @JsonProperty(value="hasNext") boolean hasNext) {
        this.data = data;
        this.totalPages = totalPages;
        this.totalElements = totalElements;
        this.hasNext = hasNext;
    }

    public static <T> PageData<T> emptyPageData() {
        return EMPTY_PAGE_DATA;
    }

    @Schema(description="Array of the entities", accessMode=Schema.AccessMode.READ_ONLY)
    public List<T> getData() {
        return this.data;
    }

    @Schema(description="Total number of available pages. Calculated based on the 'pageSize' request parameter and total number of entities that match search criteria", accessMode=Schema.AccessMode.READ_ONLY)
    public int getTotalPages() {
        return this.totalPages;
    }

    @Schema(description="Total number of elements in all available pages", accessMode=Schema.AccessMode.READ_ONLY)
    public long getTotalElements() {
        return this.totalElements;
    }

    @Schema(description="'false' value indicates the end of the result set", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(value="hasNext")
    public boolean hasNext() {
        return this.hasNext;
    }

    public <D> PageData<D> mapData(Function<T, D> mapper) {
        return new PageData(this.getData().stream().map(mapper).collect(Collectors.toList()), this.getTotalPages(), this.getTotalElements(), this.hasNext());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageData)) {
            return false;
        }
        PageData other = (PageData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.hasNext != other.hasNext) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalPages();
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        result = result * 59 + (this.hasNext ? 79 : 97);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageData(data=" + String.valueOf(this.getData()) + ", totalPages=" + this.getTotalPages() + ", totalElements=" + this.getTotalElements() + ", hasNext=" + this.hasNext + ")";
    }
}

