/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.PlatformType;

@Schema
public class OAuth2ClientInfo
extends BaseData<OAuth2ClientId>
implements HasName {
    @Schema(description="Oauth2 client registration title (e.g. My google)")
    private String title;
    @Schema(description="Oauth2 client provider name (e.g. Google)")
    private String providerName;
    @Schema(description="List of platforms for which usage of the OAuth2 client is allowed (empty for all allowed)")
    private List<PlatformType> platforms;

    public OAuth2ClientInfo() {
    }

    public OAuth2ClientInfo(OAuth2ClientId id) {
        super(id);
    }

    public OAuth2ClientInfo(OAuth2Client oAuth2Client) {
        super(oAuth2Client);
        this.title = oAuth2Client.getTitle();
        this.providerName = oAuth2Client.getAdditionalInfoField("providerName", JsonNode::asText, "");
        this.platforms = oAuth2Client.getPlatforms();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public List<PlatformType> getPlatforms() {
        return this.platforms;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Generated
    public void setPlatforms(List<PlatformType> platforms) {
        this.platforms = platforms;
    }

    @Override
    @Generated
    public String toString() {
        return "OAuth2ClientInfo(title=" + this.getTitle() + ", providerName=" + this.getProviderName() + ", platforms=" + String.valueOf(this.getPlatforms()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ClientInfo)) {
            return false;
        }
        OAuth2ClientInfo other = (OAuth2ClientInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$providerName = this.getProviderName();
        String other$providerName = other.getProviderName();
        if (this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName)) {
            return false;
        }
        List<PlatformType> this$platforms = this.getPlatforms();
        List<PlatformType> other$platforms = other.getPlatforms();
        return !(this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2ClientInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $providerName = this.getProviderName();
        result = result * 59 + ($providerName == null ? 43 : $providerName.hashCode());
        List<PlatformType> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        return result;
    }
}

