/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.validation.Length;

public class OAuth2Client
extends BaseDataWithAdditionalInfo<OAuth2ClientId>
implements HasName,
TenantEntity,
HasOwnerId {
    @Schema(description="JSON object with Tenant Id")
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id")
    private CustomerId customerId;
    @Schema(description="Oauth2 client title")
    @NotBlank
    @Length(fieldName="title", max=100, message="cannot be longer than 100 chars")
    private String title;
    @Schema(description="Config for mapping OAuth2 log in response to platform entities", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    private OAuth2MapperConfig mapperConfig;
    @Schema(description="OAuth2 client ID. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="clientId")
    private String clientId;
    @Schema(description="OAuth2 client secret. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="clientSecret", max=2048)
    private String clientSecret;
    @Schema(description="Authorization URI of the OAuth2 provider. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="authorizationUri")
    private String authorizationUri;
    @Schema(description="Access token URI of the OAuth2 provider. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="accessTokenUri")
    private String accessTokenUri;
    @Schema(description="OAuth scopes that will be requested from OAuth2 platform. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotEmpty
    @Length(fieldName="scope")
    private List<String> scope;
    @Schema(description="User info URI of the OAuth2 provider")
    @Length(fieldName="userInfoUri")
    private String userInfoUri;
    @Schema(description="Name of the username attribute in OAuth2 provider response. Cannot be empty")
    @NotBlank
    @Length(fieldName="userNameAttributeName")
    private String userNameAttributeName;
    @Schema(description="JSON Web Key URI of the OAuth2 provider")
    @Length(fieldName="jwkSetUri")
    private String jwkSetUri;
    @Schema(description="Client authentication method to use: 'BASIC' or 'POST'. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="clientAuthenticationMethod")
    private String clientAuthenticationMethod;
    @Schema(description="OAuth2 provider label. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="loginButtonLabel")
    private String loginButtonLabel;
    @Schema(description="Log in button icon for OAuth2 provider")
    @Length(fieldName="loginButtonIcon")
    private String loginButtonIcon;
    @Schema(description="List of platforms for which usage of the OAuth2 client is allowed (empty for all allowed)")
    @Length(fieldName="platforms")
    private List<PlatformType> platforms;
    @Schema(description="Additional info of OAuth2 client (e.g. providerName)", requiredMode=Schema.RequiredMode.REQUIRED)
    private JsonNode additionalInfo;

    public OAuth2Client() {
    }

    public OAuth2Client(OAuth2ClientId id) {
        super(id);
    }

    public OAuth2Client(OAuth2Client oAuth2Client) {
        super(oAuth2Client);
        this.tenantId = oAuth2Client.tenantId;
        this.customerId = oAuth2Client.customerId;
        this.title = oAuth2Client.title;
        this.mapperConfig = oAuth2Client.mapperConfig;
        this.clientId = oAuth2Client.clientId;
        this.clientSecret = oAuth2Client.clientSecret;
        this.authorizationUri = oAuth2Client.authorizationUri;
        this.accessTokenUri = oAuth2Client.accessTokenUri;
        this.scope = oAuth2Client.scope;
        this.userInfoUri = oAuth2Client.userInfoUri;
        this.userNameAttributeName = oAuth2Client.userNameAttributeName;
        this.jwkSetUri = oAuth2Client.jwkSetUri;
        this.clientAuthenticationMethod = oAuth2Client.clientAuthenticationMethod;
        this.loginButtonLabel = oAuth2Client.loginButtonLabel;
        this.loginButtonIcon = oAuth2Client.loginButtonIcon;
        this.platforms = oAuth2Client.platforms;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.OAUTH2_CLIENT;
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Client)) {
            return false;
        }
        OAuth2Client other = (OAuth2Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        OAuth2MapperConfig this$mapperConfig = this.getMapperConfig();
        OAuth2MapperConfig other$mapperConfig = other.getMapperConfig();
        if (this$mapperConfig == null ? other$mapperConfig != null : !((Object)this$mapperConfig).equals(other$mapperConfig)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$authorizationUri = this.getAuthorizationUri();
        String other$authorizationUri = other.getAuthorizationUri();
        if (this$authorizationUri == null ? other$authorizationUri != null : !this$authorizationUri.equals(other$authorizationUri)) {
            return false;
        }
        String this$accessTokenUri = this.getAccessTokenUri();
        String other$accessTokenUri = other.getAccessTokenUri();
        if (this$accessTokenUri == null ? other$accessTokenUri != null : !this$accessTokenUri.equals(other$accessTokenUri)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        if (this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri)) {
            return false;
        }
        String this$userNameAttributeName = this.getUserNameAttributeName();
        String other$userNameAttributeName = other.getUserNameAttributeName();
        if (this$userNameAttributeName == null ? other$userNameAttributeName != null : !this$userNameAttributeName.equals(other$userNameAttributeName)) {
            return false;
        }
        String this$jwkSetUri = this.getJwkSetUri();
        String other$jwkSetUri = other.getJwkSetUri();
        if (this$jwkSetUri == null ? other$jwkSetUri != null : !this$jwkSetUri.equals(other$jwkSetUri)) {
            return false;
        }
        String this$clientAuthenticationMethod = this.getClientAuthenticationMethod();
        String other$clientAuthenticationMethod = other.getClientAuthenticationMethod();
        if (this$clientAuthenticationMethod == null ? other$clientAuthenticationMethod != null : !this$clientAuthenticationMethod.equals(other$clientAuthenticationMethod)) {
            return false;
        }
        String this$loginButtonLabel = this.getLoginButtonLabel();
        String other$loginButtonLabel = other.getLoginButtonLabel();
        if (this$loginButtonLabel == null ? other$loginButtonLabel != null : !this$loginButtonLabel.equals(other$loginButtonLabel)) {
            return false;
        }
        String this$loginButtonIcon = this.getLoginButtonIcon();
        String other$loginButtonIcon = other.getLoginButtonIcon();
        if (this$loginButtonIcon == null ? other$loginButtonIcon != null : !this$loginButtonIcon.equals(other$loginButtonIcon)) {
            return false;
        }
        List<PlatformType> this$platforms = this.getPlatforms();
        List<PlatformType> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        return !(this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2Client;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        OAuth2MapperConfig $mapperConfig = this.getMapperConfig();
        result = result * 59 + ($mapperConfig == null ? 43 : ((Object)$mapperConfig).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $authorizationUri = this.getAuthorizationUri();
        result = result * 59 + ($authorizationUri == null ? 43 : $authorizationUri.hashCode());
        String $accessTokenUri = this.getAccessTokenUri();
        result = result * 59 + ($accessTokenUri == null ? 43 : $accessTokenUri.hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
        String $userNameAttributeName = this.getUserNameAttributeName();
        result = result * 59 + ($userNameAttributeName == null ? 43 : $userNameAttributeName.hashCode());
        String $jwkSetUri = this.getJwkSetUri();
        result = result * 59 + ($jwkSetUri == null ? 43 : $jwkSetUri.hashCode());
        String $clientAuthenticationMethod = this.getClientAuthenticationMethod();
        result = result * 59 + ($clientAuthenticationMethod == null ? 43 : $clientAuthenticationMethod.hashCode());
        String $loginButtonLabel = this.getLoginButtonLabel();
        result = result * 59 + ($loginButtonLabel == null ? 43 : $loginButtonLabel.hashCode());
        String $loginButtonIcon = this.getLoginButtonIcon();
        result = result * 59 + ($loginButtonIcon == null ? 43 : $loginButtonIcon.hashCode());
        List<PlatformType> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        return result;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public OAuth2MapperConfig getMapperConfig() {
        return this.mapperConfig;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    @Generated
    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    @Generated
    public List<String> getScope() {
        return this.scope;
    }

    @Generated
    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    @Generated
    public String getUserNameAttributeName() {
        return this.userNameAttributeName;
    }

    @Generated
    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    @Generated
    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    @Generated
    public String getLoginButtonLabel() {
        return this.loginButtonLabel;
    }

    @Generated
    public String getLoginButtonIcon() {
        return this.loginButtonIcon;
    }

    @Generated
    public List<PlatformType> getPlatforms() {
        return this.platforms;
    }

    @Override
    @Generated
    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setMapperConfig(OAuth2MapperConfig mapperConfig) {
        this.mapperConfig = mapperConfig;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    @Generated
    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    @Generated
    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    @Generated
    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    @Generated
    public void setUserNameAttributeName(String userNameAttributeName) {
        this.userNameAttributeName = userNameAttributeName;
    }

    @Generated
    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    @Generated
    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    @Generated
    public void setLoginButtonLabel(String loginButtonLabel) {
        this.loginButtonLabel = loginButtonLabel;
    }

    @Generated
    public void setLoginButtonIcon(String loginButtonIcon) {
        this.loginButtonIcon = loginButtonIcon;
    }

    @Generated
    public void setPlatforms(List<PlatformType> platforms) {
        this.platforms = platforms;
    }

    @Override
    @Generated
    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    @Generated
    public String toString() {
        return "OAuth2Client(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", title=" + this.getTitle() + ", mapperConfig=" + String.valueOf(this.getMapperConfig()) + ", clientId=" + this.getClientId() + ", authorizationUri=" + this.getAuthorizationUri() + ", accessTokenUri=" + this.getAccessTokenUri() + ", scope=" + String.valueOf(this.getScope()) + ", userInfoUri=" + this.getUserInfoUri() + ", userNameAttributeName=" + this.getUserNameAttributeName() + ", jwkSetUri=" + this.getJwkSetUri() + ", clientAuthenticationMethod=" + this.getClientAuthenticationMethod() + ", loginButtonLabel=" + this.getLoginButtonLabel() + ", loginButtonIcon=" + this.getLoginButtonIcon() + ", platforms=" + String.valueOf(this.getPlatforms()) + ", additionalInfo=" + String.valueOf(this.getAdditionalInfo()) + ")";
    }
}

