/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.oauth2.TenantNameStrategyType;
import org.thingsboard.server.common.data.validation.Length;

@Schema
public class OAuth2BasicMapperConfig {
    @Length(fieldName="emailAttributeKey", max=31)
    @Schema(description="Email attribute key of OAuth2 principal attributes. Must be specified for BASIC mapper type and cannot be specified for GITHUB type")
    private final String emailAttributeKey;
    @Length(fieldName="firstNameAttributeKey", max=31)
    @Schema(description="First name attribute key")
    private final String firstNameAttributeKey;
    @Length(fieldName="lastNameAttributeKey", max=31)
    @Schema(description="Last name attribute key")
    private final String lastNameAttributeKey;
    @Schema(description="Tenant naming strategy. For DOMAIN type, domain for tenant name will be taken from the email (substring before '@')", requiredMode=Schema.RequiredMode.REQUIRED)
    private final TenantNameStrategyType tenantNameStrategy;
    @Length(fieldName="tenantNamePattern")
    @Schema(description="Tenant name pattern for CUSTOM naming strategy. OAuth2 attributes in the pattern can be used by enclosing attribute key in '%{' and '}'", example="%{email}")
    private final String tenantNamePattern;
    @Length(fieldName="customerNamePattern")
    @Schema(description="Customer name pattern. When creating a user on the first OAuth2 log in, if specified, customer name will be used to create or find existing customer in the platform and assign customerId to the user")
    private final String customerNamePattern;
    @Length(fieldName="defaultDashboardName")
    @Schema(description="Name of the tenant's dashboard to set as default dashboard for newly created user")
    private final String defaultDashboardName;
    @Schema(description="Whether default dashboard should be open in full screen")
    private final boolean alwaysFullScreen;
    private final String parentCustomerNamePattern;
    private final List<String> userGroupsNamePattern;

    @ConstructorProperties(value={"emailAttributeKey", "firstNameAttributeKey", "lastNameAttributeKey", "tenantNameStrategy", "tenantNamePattern", "customerNamePattern", "defaultDashboardName", "alwaysFullScreen", "parentCustomerNamePattern", "userGroupsNamePattern"})
    @Generated
    OAuth2BasicMapperConfig(String emailAttributeKey, String firstNameAttributeKey, String lastNameAttributeKey, TenantNameStrategyType tenantNameStrategy, String tenantNamePattern, String customerNamePattern, String defaultDashboardName, boolean alwaysFullScreen, String parentCustomerNamePattern, List<String> userGroupsNamePattern) {
        this.emailAttributeKey = emailAttributeKey;
        this.firstNameAttributeKey = firstNameAttributeKey;
        this.lastNameAttributeKey = lastNameAttributeKey;
        this.tenantNameStrategy = tenantNameStrategy;
        this.tenantNamePattern = tenantNamePattern;
        this.customerNamePattern = customerNamePattern;
        this.defaultDashboardName = defaultDashboardName;
        this.alwaysFullScreen = alwaysFullScreen;
        this.parentCustomerNamePattern = parentCustomerNamePattern;
        this.userGroupsNamePattern = userGroupsNamePattern;
    }

    @Generated
    public static OAuth2BasicMapperConfigBuilder builder() {
        return new OAuth2BasicMapperConfigBuilder();
    }

    @Generated
    public OAuth2BasicMapperConfigBuilder toBuilder() {
        return new OAuth2BasicMapperConfigBuilder().emailAttributeKey(this.emailAttributeKey).firstNameAttributeKey(this.firstNameAttributeKey).lastNameAttributeKey(this.lastNameAttributeKey).tenantNameStrategy(this.tenantNameStrategy).tenantNamePattern(this.tenantNamePattern).customerNamePattern(this.customerNamePattern).defaultDashboardName(this.defaultDashboardName).alwaysFullScreen(this.alwaysFullScreen).parentCustomerNamePattern(this.parentCustomerNamePattern).userGroupsNamePattern(this.userGroupsNamePattern);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2BasicMapperConfig)) {
            return false;
        }
        OAuth2BasicMapperConfig other = (OAuth2BasicMapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAlwaysFullScreen() != other.isAlwaysFullScreen()) {
            return false;
        }
        String this$emailAttributeKey = this.getEmailAttributeKey();
        String other$emailAttributeKey = other.getEmailAttributeKey();
        if (this$emailAttributeKey == null ? other$emailAttributeKey != null : !this$emailAttributeKey.equals(other$emailAttributeKey)) {
            return false;
        }
        String this$firstNameAttributeKey = this.getFirstNameAttributeKey();
        String other$firstNameAttributeKey = other.getFirstNameAttributeKey();
        if (this$firstNameAttributeKey == null ? other$firstNameAttributeKey != null : !this$firstNameAttributeKey.equals(other$firstNameAttributeKey)) {
            return false;
        }
        String this$lastNameAttributeKey = this.getLastNameAttributeKey();
        String other$lastNameAttributeKey = other.getLastNameAttributeKey();
        if (this$lastNameAttributeKey == null ? other$lastNameAttributeKey != null : !this$lastNameAttributeKey.equals(other$lastNameAttributeKey)) {
            return false;
        }
        TenantNameStrategyType this$tenantNameStrategy = this.getTenantNameStrategy();
        TenantNameStrategyType other$tenantNameStrategy = other.getTenantNameStrategy();
        if (this$tenantNameStrategy == null ? other$tenantNameStrategy != null : !((Object)((Object)this$tenantNameStrategy)).equals((Object)other$tenantNameStrategy)) {
            return false;
        }
        String this$tenantNamePattern = this.getTenantNamePattern();
        String other$tenantNamePattern = other.getTenantNamePattern();
        if (this$tenantNamePattern == null ? other$tenantNamePattern != null : !this$tenantNamePattern.equals(other$tenantNamePattern)) {
            return false;
        }
        String this$customerNamePattern = this.getCustomerNamePattern();
        String other$customerNamePattern = other.getCustomerNamePattern();
        if (this$customerNamePattern == null ? other$customerNamePattern != null : !this$customerNamePattern.equals(other$customerNamePattern)) {
            return false;
        }
        String this$defaultDashboardName = this.getDefaultDashboardName();
        String other$defaultDashboardName = other.getDefaultDashboardName();
        if (this$defaultDashboardName == null ? other$defaultDashboardName != null : !this$defaultDashboardName.equals(other$defaultDashboardName)) {
            return false;
        }
        String this$parentCustomerNamePattern = this.getParentCustomerNamePattern();
        String other$parentCustomerNamePattern = other.getParentCustomerNamePattern();
        if (this$parentCustomerNamePattern == null ? other$parentCustomerNamePattern != null : !this$parentCustomerNamePattern.equals(other$parentCustomerNamePattern)) {
            return false;
        }
        List<String> this$userGroupsNamePattern = this.getUserGroupsNamePattern();
        List<String> other$userGroupsNamePattern = other.getUserGroupsNamePattern();
        return !(this$userGroupsNamePattern == null ? other$userGroupsNamePattern != null : !((Object)this$userGroupsNamePattern).equals(other$userGroupsNamePattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2BasicMapperConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlwaysFullScreen() ? 79 : 97);
        String $emailAttributeKey = this.getEmailAttributeKey();
        result = result * 59 + ($emailAttributeKey == null ? 43 : $emailAttributeKey.hashCode());
        String $firstNameAttributeKey = this.getFirstNameAttributeKey();
        result = result * 59 + ($firstNameAttributeKey == null ? 43 : $firstNameAttributeKey.hashCode());
        String $lastNameAttributeKey = this.getLastNameAttributeKey();
        result = result * 59 + ($lastNameAttributeKey == null ? 43 : $lastNameAttributeKey.hashCode());
        TenantNameStrategyType $tenantNameStrategy = this.getTenantNameStrategy();
        result = result * 59 + ($tenantNameStrategy == null ? 43 : ((Object)((Object)$tenantNameStrategy)).hashCode());
        String $tenantNamePattern = this.getTenantNamePattern();
        result = result * 59 + ($tenantNamePattern == null ? 43 : $tenantNamePattern.hashCode());
        String $customerNamePattern = this.getCustomerNamePattern();
        result = result * 59 + ($customerNamePattern == null ? 43 : $customerNamePattern.hashCode());
        String $defaultDashboardName = this.getDefaultDashboardName();
        result = result * 59 + ($defaultDashboardName == null ? 43 : $defaultDashboardName.hashCode());
        String $parentCustomerNamePattern = this.getParentCustomerNamePattern();
        result = result * 59 + ($parentCustomerNamePattern == null ? 43 : $parentCustomerNamePattern.hashCode());
        List<String> $userGroupsNamePattern = this.getUserGroupsNamePattern();
        result = result * 59 + ($userGroupsNamePattern == null ? 43 : ((Object)$userGroupsNamePattern).hashCode());
        return result;
    }

    @Generated
    public String getEmailAttributeKey() {
        return this.emailAttributeKey;
    }

    @Generated
    public String getFirstNameAttributeKey() {
        return this.firstNameAttributeKey;
    }

    @Generated
    public String getLastNameAttributeKey() {
        return this.lastNameAttributeKey;
    }

    @Generated
    public TenantNameStrategyType getTenantNameStrategy() {
        return this.tenantNameStrategy;
    }

    @Generated
    public String getTenantNamePattern() {
        return this.tenantNamePattern;
    }

    @Generated
    public String getCustomerNamePattern() {
        return this.customerNamePattern;
    }

    @Generated
    public String getDefaultDashboardName() {
        return this.defaultDashboardName;
    }

    @Generated
    public boolean isAlwaysFullScreen() {
        return this.alwaysFullScreen;
    }

    @Generated
    public String getParentCustomerNamePattern() {
        return this.parentCustomerNamePattern;
    }

    @Generated
    public List<String> getUserGroupsNamePattern() {
        return this.userGroupsNamePattern;
    }

    @Generated
    public String toString() {
        return "OAuth2BasicMapperConfig(emailAttributeKey=" + this.getEmailAttributeKey() + ", firstNameAttributeKey=" + this.getFirstNameAttributeKey() + ", lastNameAttributeKey=" + this.getLastNameAttributeKey() + ", tenantNameStrategy=" + String.valueOf((Object)this.getTenantNameStrategy()) + ", tenantNamePattern=" + this.getTenantNamePattern() + ", customerNamePattern=" + this.getCustomerNamePattern() + ", defaultDashboardName=" + this.getDefaultDashboardName() + ", alwaysFullScreen=" + this.isAlwaysFullScreen() + ", parentCustomerNamePattern=" + this.getParentCustomerNamePattern() + ", userGroupsNamePattern=" + String.valueOf(this.getUserGroupsNamePattern()) + ")";
    }

    @Generated
    public static class OAuth2BasicMapperConfigBuilder {
        @Generated
        private String emailAttributeKey;
        @Generated
        private String firstNameAttributeKey;
        @Generated
        private String lastNameAttributeKey;
        @Generated
        private TenantNameStrategyType tenantNameStrategy;
        @Generated
        private String tenantNamePattern;
        @Generated
        private String customerNamePattern;
        @Generated
        private String defaultDashboardName;
        @Generated
        private boolean alwaysFullScreen;
        @Generated
        private String parentCustomerNamePattern;
        @Generated
        private List<String> userGroupsNamePattern;

        @Generated
        OAuth2BasicMapperConfigBuilder() {
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder emailAttributeKey(String emailAttributeKey) {
            this.emailAttributeKey = emailAttributeKey;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder firstNameAttributeKey(String firstNameAttributeKey) {
            this.firstNameAttributeKey = firstNameAttributeKey;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder lastNameAttributeKey(String lastNameAttributeKey) {
            this.lastNameAttributeKey = lastNameAttributeKey;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder tenantNameStrategy(TenantNameStrategyType tenantNameStrategy) {
            this.tenantNameStrategy = tenantNameStrategy;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder tenantNamePattern(String tenantNamePattern) {
            this.tenantNamePattern = tenantNamePattern;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder customerNamePattern(String customerNamePattern) {
            this.customerNamePattern = customerNamePattern;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder defaultDashboardName(String defaultDashboardName) {
            this.defaultDashboardName = defaultDashboardName;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder alwaysFullScreen(boolean alwaysFullScreen) {
            this.alwaysFullScreen = alwaysFullScreen;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder parentCustomerNamePattern(String parentCustomerNamePattern) {
            this.parentCustomerNamePattern = parentCustomerNamePattern;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfigBuilder userGroupsNamePattern(List<String> userGroupsNamePattern) {
            this.userGroupsNamePattern = userGroupsNamePattern;
            return this;
        }

        @Generated
        public OAuth2BasicMapperConfig build() {
            return new OAuth2BasicMapperConfig(this.emailAttributeKey, this.firstNameAttributeKey, this.lastNameAttributeKey, this.tenantNameStrategy, this.tenantNamePattern, this.customerNamePattern, this.defaultDashboardName, this.alwaysFullScreen, this.parentCustomerNamePattern, this.userGroupsNamePattern);
        }

        @Generated
        public String toString() {
            return "OAuth2BasicMapperConfig.OAuth2BasicMapperConfigBuilder(emailAttributeKey=" + this.emailAttributeKey + ", firstNameAttributeKey=" + this.firstNameAttributeKey + ", lastNameAttributeKey=" + this.lastNameAttributeKey + ", tenantNameStrategy=" + String.valueOf((Object)this.tenantNameStrategy) + ", tenantNamePattern=" + this.tenantNamePattern + ", customerNamePattern=" + this.customerNamePattern + ", defaultDashboardName=" + this.defaultDashboardName + ", alwaysFullScreen=" + this.alwaysFullScreen + ", parentCustomerNamePattern=" + this.parentCustomerNamePattern + ", userGroupsNamePattern=" + String.valueOf(this.userGroupsNamePattern) + ")";
        }
    }
}

