/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.HasSubject;
import org.thingsboard.server.common.data.notification.template.TemplatableValue;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class WebDeliveryMethodNotificationTemplate
extends DeliveryMethodNotificationTemplate
implements HasSubject {
    @NoXss(fieldName="web notification subject")
    @Length(fieldName="web notification subject", max=150, message="cannot be longer than 150 chars")
    @NotEmpty
    private String subject;
    private JsonNode additionalConfig;
    private final List<TemplatableValue> templatableValues = List.of(TemplatableValue.of(this::getBody, this::setBody), TemplatableValue.of(this::getSubject, this::setSubject), TemplatableValue.of(this::getButtonText, this::setButtonText), TemplatableValue.of(this::getButtonLink, this::setButtonLink));

    public WebDeliveryMethodNotificationTemplate(WebDeliveryMethodNotificationTemplate other) {
        super(other);
        this.subject = other.subject;
        this.additionalConfig = other.additionalConfig != null ? other.additionalConfig.deepCopy() : null;
    }

    @Override
    @Length(fieldName="web notification message", max=250, message="cannot be longer than 250 chars")
    public String getBody() {
        return super.getBody();
    }

    @NoXss(fieldName="web notification button text")
    @Length(fieldName="web notification button text", max=50, message="cannot be longer than 50 chars")
    @JsonIgnore
    public String getButtonText() {
        return this.getButtonConfigProperty("text");
    }

    @JsonIgnore
    public void setButtonText(String buttonText) {
        this.getButtonConfig().ifPresent(buttonConfig -> buttonConfig.set("text", (JsonNode)new TextNode(buttonText)));
    }

    @NoXss(fieldName="web notification button link")
    @Length(fieldName="web notification button link", max=300, message="cannot be longer than 300 chars")
    @JsonIgnore
    public String getButtonLink() {
        return this.getButtonConfigProperty("link");
    }

    @JsonIgnore
    public void setButtonLink(String buttonLink) {
        this.getButtonConfig().ifPresent(buttonConfig -> buttonConfig.set("link", (JsonNode)new TextNode(buttonLink)));
    }

    private String getButtonConfigProperty(String property) {
        return this.getButtonConfig().map(buttonConfig -> buttonConfig.get(property)).filter(JsonNode::isTextual).map(JsonNode::asText).orElse(null);
    }

    private Optional<ObjectNode> getButtonConfig() {
        return Optional.ofNullable(this.additionalConfig).map(config -> config.get("actionButtonConfig")).filter(JsonNode::isObject).map(config -> (ObjectNode)config);
    }

    @Override
    public NotificationDeliveryMethod getMethod() {
        return NotificationDeliveryMethod.WEB;
    }

    @Override
    public WebDeliveryMethodNotificationTemplate copy() {
        return new WebDeliveryMethodNotificationTemplate(this);
    }

    @Override
    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public JsonNode getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Override
    @Generated
    public List<TemplatableValue> getTemplatableValues() {
        return this.templatableValues;
    }

    @Override
    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setAdditionalConfig(JsonNode additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Generated
    public WebDeliveryMethodNotificationTemplate() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebDeliveryMethodNotificationTemplate)) {
            return false;
        }
        WebDeliveryMethodNotificationTemplate other = (WebDeliveryMethodNotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        JsonNode this$additionalConfig = this.getAdditionalConfig();
        JsonNode other$additionalConfig = other.getAdditionalConfig();
        if (this$additionalConfig == null ? other$additionalConfig != null : !this$additionalConfig.equals(other$additionalConfig)) {
            return false;
        }
        List<TemplatableValue> this$templatableValues = this.getTemplatableValues();
        List<TemplatableValue> other$templatableValues = other.getTemplatableValues();
        return !(this$templatableValues == null ? other$templatableValues != null : !((Object)this$templatableValues).equals(other$templatableValues));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebDeliveryMethodNotificationTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        JsonNode $additionalConfig = this.getAdditionalConfig();
        result = result * 59 + ($additionalConfig == null ? 43 : $additionalConfig.hashCode());
        List<TemplatableValue> $templatableValues = this.getTemplatableValues();
        result = result * 59 + ($templatableValues == null ? 43 : ((Object)$templatableValues).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WebDeliveryMethodNotificationTemplate(super=" + super.toString() + ", subject=" + this.getSubject() + ", additionalConfig=" + String.valueOf(this.getAdditionalConfig()) + ", templatableValues=" + String.valueOf(this.getTemplatableValues()) + ")";
    }
}

