/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;

public class NotificationTemplateConfig {
    @Valid
    @NotEmpty
    private Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> deliveryMethodsTemplates;
    private boolean attachReport;
    private ReportTemplateId reportTemplateId;
    private UserId userId;
    private String timezone;

    public NotificationTemplateConfig copy() {
        HashMap<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> templates = new HashMap<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate>(this.deliveryMethodsTemplates);
        templates.replaceAll((deliveryMethod, template) -> template.copy());
        NotificationTemplateConfig copy = new NotificationTemplateConfig();
        copy.setDeliveryMethodsTemplates(templates);
        copy.setAttachReport(this.attachReport);
        copy.setReportTemplateId(this.reportTemplateId);
        copy.setUserId(this.userId);
        copy.setTimezone(this.timezone);
        return copy;
    }

    @Generated
    public NotificationTemplateConfig() {
    }

    @Generated
    public Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> getDeliveryMethodsTemplates() {
        return this.deliveryMethodsTemplates;
    }

    @Generated
    public boolean isAttachReport() {
        return this.attachReport;
    }

    @Generated
    public ReportTemplateId getReportTemplateId() {
        return this.reportTemplateId;
    }

    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public void setDeliveryMethodsTemplates(Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> deliveryMethodsTemplates) {
        this.deliveryMethodsTemplates = deliveryMethodsTemplates;
    }

    @Generated
    public void setAttachReport(boolean attachReport) {
        this.attachReport = attachReport;
    }

    @Generated
    public void setReportTemplateId(ReportTemplateId reportTemplateId) {
        this.reportTemplateId = reportTemplateId;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationTemplateConfig)) {
            return false;
        }
        NotificationTemplateConfig other = (NotificationTemplateConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAttachReport() != other.isAttachReport()) {
            return false;
        }
        Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> this$deliveryMethodsTemplates = this.getDeliveryMethodsTemplates();
        Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> other$deliveryMethodsTemplates = other.getDeliveryMethodsTemplates();
        if (this$deliveryMethodsTemplates == null ? other$deliveryMethodsTemplates != null : !((Object)this$deliveryMethodsTemplates).equals(other$deliveryMethodsTemplates)) {
            return false;
        }
        ReportTemplateId this$reportTemplateId = this.getReportTemplateId();
        ReportTemplateId other$reportTemplateId = other.getReportTemplateId();
        if (this$reportTemplateId == null ? other$reportTemplateId != null : !((Object)this$reportTemplateId).equals(other$reportTemplateId)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationTemplateConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttachReport() ? 79 : 97);
        Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> $deliveryMethodsTemplates = this.getDeliveryMethodsTemplates();
        result = result * 59 + ($deliveryMethodsTemplates == null ? 43 : ((Object)$deliveryMethodsTemplates).hashCode());
        ReportTemplateId $reportTemplateId = this.getReportTemplateId();
        result = result * 59 + ($reportTemplateId == null ? 43 : ((Object)$reportTemplateId).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationTemplateConfig(deliveryMethodsTemplates=" + String.valueOf(this.getDeliveryMethodsTemplates()) + ", attachReport=" + this.isAttachReport() + ", reportTemplateId=" + String.valueOf(this.getReportTemplateId()) + ", userId=" + String.valueOf(this.getUserId()) + ", timezone=" + this.getTimezone() + ")";
    }
}

