/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.template.NotificationTemplateConfig;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class NotificationTemplate
extends BaseData<NotificationTemplateId>
implements TenantEntity,
HasName,
ExportableEntity<NotificationTemplateId> {
    private TenantId tenantId;
    @NoXss
    @NotEmpty
    @Length(max=255, message="cannot be longer than 255 chars")
    private String name;
    @NoXss
    @NotNull
    private NotificationType notificationType;
    @Valid
    @NotNull
    private NotificationTemplateConfig configuration;
    private NotificationTemplateId externalId;

    public NotificationTemplate() {
    }

    public NotificationTemplate(NotificationTemplate other) {
        super(other);
        this.tenantId = other.tenantId;
        this.name = other.name;
        this.notificationType = other.notificationType;
        this.configuration = other.configuration != null ? other.configuration.copy() : null;
        this.externalId = other.externalId;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.NOTIFICATION_TEMPLATE;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public NotificationTemplateConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public NotificationTemplateId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    @Generated
    public void setConfiguration(NotificationTemplateConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public void setExternalId(NotificationTemplateId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "NotificationTemplate(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", notificationType=" + String.valueOf((Object)this.getNotificationType()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationTemplate)) {
            return false;
        }
        NotificationTemplate other = (NotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationType this$notificationType = this.getNotificationType();
        NotificationType other$notificationType = other.getNotificationType();
        if (this$notificationType == null ? other$notificationType != null : !((Object)((Object)this$notificationType)).equals((Object)other$notificationType)) {
            return false;
        }
        NotificationTemplateConfig this$configuration = this.getConfiguration();
        NotificationTemplateConfig other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        NotificationTemplateId this$externalId = this.getExternalId();
        NotificationTemplateId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationType $notificationType = this.getNotificationType();
        result = result * 59 + ($notificationType == null ? 43 : ((Object)((Object)$notificationType)).hashCode());
        NotificationTemplateConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        NotificationTemplateId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

