/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.HasSubject;
import org.thingsboard.server.common.data.notification.template.TemplatableValue;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class EmailDeliveryMethodNotificationTemplate
extends DeliveryMethodNotificationTemplate
implements HasSubject {
    @NoXss(fieldName="email subject")
    @Length(fieldName="email subject", max=250, message="cannot be longer than 250 chars")
    @NotEmpty
    private String subject;
    private final List<TemplatableValue> templatableValues = List.of(TemplatableValue.of(this::getBody, this::setBody), TemplatableValue.of(this::getSubject, this::setSubject));

    public EmailDeliveryMethodNotificationTemplate(EmailDeliveryMethodNotificationTemplate other) {
        super(other);
        this.subject = other.subject;
    }

    @Override
    public NotificationDeliveryMethod getMethod() {
        return NotificationDeliveryMethod.EMAIL;
    }

    @Override
    public EmailDeliveryMethodNotificationTemplate copy() {
        return new EmailDeliveryMethodNotificationTemplate(this);
    }

    @Override
    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Override
    @Generated
    public List<TemplatableValue> getTemplatableValues() {
        return this.templatableValues;
    }

    @Override
    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public EmailDeliveryMethodNotificationTemplate() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailDeliveryMethodNotificationTemplate)) {
            return false;
        }
        EmailDeliveryMethodNotificationTemplate other = (EmailDeliveryMethodNotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        List<TemplatableValue> this$templatableValues = this.getTemplatableValues();
        List<TemplatableValue> other$templatableValues = other.getTemplatableValues();
        return !(this$templatableValues == null ? other$templatableValues != null : !((Object)this$templatableValues).equals(other$templatableValues));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmailDeliveryMethodNotificationTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        List<TemplatableValue> $templatableValues = this.getTemplatableValues();
        result = result * 59 + ($templatableValues == null ? 43 : ((Object)$templatableValues).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EmailDeliveryMethodNotificationTemplate(super=" + super.toString() + ", subject=" + this.getSubject() + ", templatableValues=" + String.valueOf(this.getTemplatableValues()) + ")";
    }
}

