/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.settings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetType;

public class UserNotificationSettings {
    @NotNull
    @Valid
    private final Map<NotificationType, NotificationPref> prefs;
    public static final UserNotificationSettings DEFAULT = new UserNotificationSettings(Collections.emptyMap());
    public static final Set<NotificationDeliveryMethod> deliveryMethods = NotificationTargetType.PLATFORM_USERS.getSupportedDeliveryMethods();

    @JsonCreator
    public UserNotificationSettings(@JsonProperty(value="prefs") Map<NotificationType, NotificationPref> prefs) {
        this.prefs = prefs;
    }

    public boolean isEnabled(NotificationType notificationType, NotificationDeliveryMethod deliveryMethod) {
        NotificationPref pref = this.prefs.get((Object)notificationType);
        if (pref == null) {
            return true;
        }
        if (!pref.isEnabled()) {
            return false;
        }
        return pref.getEnabledDeliveryMethods().getOrDefault((Object)deliveryMethod, true);
    }

    @Generated
    public Map<NotificationType, NotificationPref> getPrefs() {
        return this.prefs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserNotificationSettings)) {
            return false;
        }
        UserNotificationSettings other = (UserNotificationSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<NotificationType, NotificationPref> this$prefs = this.getPrefs();
        Map<NotificationType, NotificationPref> other$prefs = other.getPrefs();
        return !(this$prefs == null ? other$prefs != null : !((Object)this$prefs).equals(other$prefs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserNotificationSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<NotificationType, NotificationPref> $prefs = this.getPrefs();
        result = result * 59 + ($prefs == null ? 43 : ((Object)$prefs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserNotificationSettings(prefs=" + String.valueOf(this.getPrefs()) + ")";
    }

    public static class NotificationPref {
        private boolean enabled;
        @NotNull
        private Map<NotificationDeliveryMethod, Boolean> enabledDeliveryMethods;

        public static NotificationPref createDefault() {
            NotificationPref pref = new NotificationPref();
            pref.setEnabled(true);
            pref.setEnabledDeliveryMethods(deliveryMethods.stream().collect(Collectors.toMap(v -> v, v -> true)));
            return pref;
        }

        @JsonIgnore
        @AssertTrue(message="Only email, Web and SMS delivery methods are allowed")
        public @AssertTrue(message="Only email, Web and SMS delivery methods are allowed") boolean isValid() {
            return this.enabledDeliveryMethods.entrySet().stream().allMatch(entry -> deliveryMethods.contains(entry.getKey()) && entry.getValue() != null);
        }

        @Generated
        public NotificationPref() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<NotificationDeliveryMethod, Boolean> getEnabledDeliveryMethods() {
            return this.enabledDeliveryMethods;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setEnabledDeliveryMethods(Map<NotificationDeliveryMethod, Boolean> enabledDeliveryMethods) {
            this.enabledDeliveryMethods = enabledDeliveryMethods;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationPref)) {
                return false;
            }
            NotificationPref other = (NotificationPref)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Map<NotificationDeliveryMethod, Boolean> this$enabledDeliveryMethods = this.getEnabledDeliveryMethods();
            Map<NotificationDeliveryMethod, Boolean> other$enabledDeliveryMethods = other.getEnabledDeliveryMethods();
            return !(this$enabledDeliveryMethods == null ? other$enabledDeliveryMethods != null : !((Object)this$enabledDeliveryMethods).equals(other$enabledDeliveryMethods));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NotificationPref;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Map<NotificationDeliveryMethod, Boolean> $enabledDeliveryMethods = this.getEnabledDeliveryMethods();
            result = result * 59 + ($enabledDeliveryMethods == null ? 43 : ((Object)$enabledDeliveryMethods).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserNotificationSettings.NotificationPref(enabled=" + this.isEnabled() + ", enabledDeliveryMethods=" + String.valueOf(this.getEnabledDeliveryMethods()) + ")";
        }
    }
}

