/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.AssertTrue;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.settings.NotificationDeliveryMethodConfig;

public class MobileAppNotificationDeliveryMethodConfig
implements NotificationDeliveryMethodConfig {
    private String firebaseServiceAccountCredentialsFileName;
    private String firebaseServiceAccountCredentials;
    private boolean useSystemSettings;

    @Override
    public NotificationDeliveryMethod getMethod() {
        return NotificationDeliveryMethod.MOBILE_APP;
    }

    @JsonIgnore
    @AssertTrue(message="Firebase service account credentials must be specified")
    public @AssertTrue(message="Firebase service account credentials must be specified") boolean isValid() {
        if (this.useSystemSettings) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)this.firebaseServiceAccountCredentials);
    }

    @Generated
    public MobileAppNotificationDeliveryMethodConfig() {
    }

    @Generated
    public String getFirebaseServiceAccountCredentialsFileName() {
        return this.firebaseServiceAccountCredentialsFileName;
    }

    @Generated
    public String getFirebaseServiceAccountCredentials() {
        return this.firebaseServiceAccountCredentials;
    }

    @Generated
    public boolean isUseSystemSettings() {
        return this.useSystemSettings;
    }

    @Generated
    public void setFirebaseServiceAccountCredentialsFileName(String firebaseServiceAccountCredentialsFileName) {
        this.firebaseServiceAccountCredentialsFileName = firebaseServiceAccountCredentialsFileName;
    }

    @Generated
    public void setFirebaseServiceAccountCredentials(String firebaseServiceAccountCredentials) {
        this.firebaseServiceAccountCredentials = firebaseServiceAccountCredentials;
    }

    @Generated
    public void setUseSystemSettings(boolean useSystemSettings) {
        this.useSystemSettings = useSystemSettings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileAppNotificationDeliveryMethodConfig)) {
            return false;
        }
        MobileAppNotificationDeliveryMethodConfig other = (MobileAppNotificationDeliveryMethodConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSystemSettings() != other.isUseSystemSettings()) {
            return false;
        }
        String this$firebaseServiceAccountCredentialsFileName = this.getFirebaseServiceAccountCredentialsFileName();
        String other$firebaseServiceAccountCredentialsFileName = other.getFirebaseServiceAccountCredentialsFileName();
        if (this$firebaseServiceAccountCredentialsFileName == null ? other$firebaseServiceAccountCredentialsFileName != null : !this$firebaseServiceAccountCredentialsFileName.equals(other$firebaseServiceAccountCredentialsFileName)) {
            return false;
        }
        String this$firebaseServiceAccountCredentials = this.getFirebaseServiceAccountCredentials();
        String other$firebaseServiceAccountCredentials = other.getFirebaseServiceAccountCredentials();
        return !(this$firebaseServiceAccountCredentials == null ? other$firebaseServiceAccountCredentials != null : !this$firebaseServiceAccountCredentials.equals(other$firebaseServiceAccountCredentials));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MobileAppNotificationDeliveryMethodConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSystemSettings() ? 79 : 97);
        String $firebaseServiceAccountCredentialsFileName = this.getFirebaseServiceAccountCredentialsFileName();
        result = result * 59 + ($firebaseServiceAccountCredentialsFileName == null ? 43 : $firebaseServiceAccountCredentialsFileName.hashCode());
        String $firebaseServiceAccountCredentials = this.getFirebaseServiceAccountCredentials();
        result = result * 59 + ($firebaseServiceAccountCredentials == null ? 43 : $firebaseServiceAccountCredentials.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MobileAppNotificationDeliveryMethodConfig(firebaseServiceAccountCredentialsFileName=" + this.getFirebaseServiceAccountCredentialsFileName() + ", firebaseServiceAccountCredentials=" + this.getFirebaseServiceAccountCredentials() + ", useSystemSettings=" + this.isUseSystemSettings() + ")";
    }
}

