/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class ResourcesShortageTrigger
implements NotificationRuleTrigger {
    private static final long serialVersionUID = 6024216015202949570L;
    private Resource resource;
    private Long usage;
    private String serviceId;
    private String serviceType;

    @Override
    public TenantId getTenantId() {
        return TenantId.SYS_TENANT_ID;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return TenantId.SYS_TENANT_ID;
    }

    @Override
    public NotificationRuleTrigger.DeduplicationStrategy getDeduplicationStrategy() {
        return NotificationRuleTrigger.DeduplicationStrategy.ONLY_MATCHING;
    }

    @Override
    public String getDeduplicationKey() {
        return String.join((CharSequence)":", this.resource.name(), this.serviceId, this.serviceType);
    }

    @Override
    public long getDefaultDeduplicationDuration() {
        return TimeUnit.HOURS.toMillis(1L);
    }

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.RESOURCES_SHORTAGE;
    }

    @ConstructorProperties(value={"resource", "usage", "serviceId", "serviceType"})
    @Generated
    ResourcesShortageTrigger(Resource resource, Long usage, String serviceId, String serviceType) {
        this.resource = resource;
        this.usage = usage;
        this.serviceId = serviceId;
        this.serviceType = serviceType;
    }

    @Generated
    public static ResourcesShortageTriggerBuilder builder() {
        return new ResourcesShortageTriggerBuilder();
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public Long getUsage() {
        return this.usage;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceType() {
        return this.serviceType;
    }

    @Generated
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Generated
    public void setUsage(Long usage) {
        this.usage = usage;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcesShortageTrigger)) {
            return false;
        }
        ResourcesShortageTrigger other = (ResourcesShortageTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$usage = this.getUsage();
        Long other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)((Object)this$resource)).equals((Object)other$resource)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        return !(this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourcesShortageTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)((Object)$resource)).hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourcesShortageTrigger(resource=" + String.valueOf((Object)this.getResource()) + ", usage=" + this.getUsage() + ", serviceId=" + this.getServiceId() + ", serviceType=" + this.getServiceType() + ")";
    }

    public static enum Resource {
        CPU,
        RAM,
        STORAGE;

    }

    @Generated
    public static class ResourcesShortageTriggerBuilder {
        @Generated
        private Resource resource;
        @Generated
        private Long usage;
        @Generated
        private String serviceId;
        @Generated
        private String serviceType;

        @Generated
        ResourcesShortageTriggerBuilder() {
        }

        @Generated
        public ResourcesShortageTriggerBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public ResourcesShortageTriggerBuilder usage(Long usage) {
            this.usage = usage;
            return this;
        }

        @Generated
        public ResourcesShortageTriggerBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public ResourcesShortageTriggerBuilder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Generated
        public ResourcesShortageTrigger build() {
            return new ResourcesShortageTrigger(this.resource, this.usage, this.serviceId, this.serviceType);
        }

        @Generated
        public String toString() {
            return "ResourcesShortageTrigger.ResourcesShortageTriggerBuilder(resource=" + String.valueOf((Object)this.resource) + ", usage=" + this.usage + ", serviceId=" + this.serviceId + ", serviceType=" + this.serviceType + ")";
        }
    }
}

