/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class EdgeConnectionTrigger
implements NotificationRuleTrigger {
    private static final long serialVersionUID = -261939829962721957L;
    private final TenantId tenantId;
    private final CustomerId customerId;
    private final EdgeId edgeId;
    private final boolean connected;
    private final String edgeName;

    @Override
    public NotificationRuleTrigger.DeduplicationStrategy getDeduplicationStrategy() {
        return NotificationRuleTrigger.DeduplicationStrategy.ALL;
    }

    @Override
    public String getDeduplicationKey() {
        return String.join((CharSequence)":", NotificationRuleTrigger.super.getDeduplicationKey(), String.valueOf(this.connected));
    }

    @Override
    public long getDefaultDeduplicationDuration() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.EDGE_CONNECTION;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.edgeId;
    }

    @ConstructorProperties(value={"tenantId", "customerId", "edgeId", "connected", "edgeName"})
    @Generated
    EdgeConnectionTrigger(TenantId tenantId, CustomerId customerId, EdgeId edgeId, boolean connected, String edgeName) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.edgeId = edgeId;
        this.connected = connected;
        this.edgeName = edgeName;
    }

    @Generated
    public static EdgeConnectionTriggerBuilder builder() {
        return new EdgeConnectionTriggerBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public EdgeId getEdgeId() {
        return this.edgeId;
    }

    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    @Generated
    public String getEdgeName() {
        return this.edgeName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeConnectionTrigger)) {
            return false;
        }
        EdgeConnectionTrigger other = (EdgeConnectionTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        EdgeId this$edgeId = this.getEdgeId();
        EdgeId other$edgeId = other.getEdgeId();
        if (this$edgeId == null ? other$edgeId != null : !((Object)this$edgeId).equals(other$edgeId)) {
            return false;
        }
        String this$edgeName = this.getEdgeName();
        String other$edgeName = other.getEdgeName();
        return !(this$edgeName == null ? other$edgeName != null : !this$edgeName.equals(other$edgeName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdgeConnectionTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConnected() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        EdgeId $edgeId = this.getEdgeId();
        result = result * 59 + ($edgeId == null ? 43 : ((Object)$edgeId).hashCode());
        String $edgeName = this.getEdgeName();
        result = result * 59 + ($edgeName == null ? 43 : $edgeName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdgeConnectionTrigger(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", edgeId=" + String.valueOf(this.getEdgeId()) + ", connected=" + this.isConnected() + ", edgeName=" + this.getEdgeName() + ")";
    }

    @Generated
    public static class EdgeConnectionTriggerBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private CustomerId customerId;
        @Generated
        private EdgeId edgeId;
        @Generated
        private boolean connected;
        @Generated
        private String edgeName;

        @Generated
        EdgeConnectionTriggerBuilder() {
        }

        @Generated
        public EdgeConnectionTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public EdgeConnectionTriggerBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        @Generated
        public EdgeConnectionTriggerBuilder edgeId(EdgeId edgeId) {
            this.edgeId = edgeId;
            return this;
        }

        @Generated
        public EdgeConnectionTriggerBuilder connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Generated
        public EdgeConnectionTriggerBuilder edgeName(String edgeName) {
            this.edgeName = edgeName;
            return this;
        }

        @Generated
        public EdgeConnectionTrigger build() {
            return new EdgeConnectionTrigger(this.tenantId, this.customerId, this.edgeId, this.connected, this.edgeName);
        }

        @Generated
        public String toString() {
            return "EdgeConnectionTrigger.EdgeConnectionTriggerBuilder(tenantId=" + String.valueOf(this.tenantId) + ", customerId=" + String.valueOf(this.customerId) + ", edgeId=" + String.valueOf(this.edgeId) + ", connected=" + this.connected + ", edgeName=" + this.edgeName + ")";
        }
    }
}

